/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.imageSupport;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.OldPCXFilter;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Civ3PCXFilter;
import com.civfanatics.civ3.xplatformeditor.imageSupport.ImageResources;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Units32Supplier {
    static Logger logger = Logger.getLogger(Units32Supplier.class);
    static Civ3PCXFilter units_32;
    static Map<String, BufferedImage> iconCache;

    public static BufferedImage getUnit32Image(int iconIndex, int colorIndex) {
        String key;
        if (units_32 == null) {
            Units32Supplier.loadUnits32();
        }
        if (iconCache.containsKey(key = iconIndex + " " + colorIndex)) {
            return iconCache.get(key);
        }
        Units32Supplier.setCivSpecificColors(colorIndex);
        BufferedImage unit32Icon = Units32Supplier.getUnitImageFromUnits32(iconIndex);
        iconCache.put(key, unit32Icon);
        return unit32Icon;
    }

    private static void loadUnits32() {
        String units32Name = null;
        try {
            units32Name = utils.findFile("units_32.pcx", "Art" + Main.fileSlash + "Units" + Main.fileSlash, Main.biqFile.get(Main.biqIndex));
        }
        catch (FileNotFoundException e) {
            logger.error("Could not find units_32.pcx; civInstallDir = " + Main.settings.civInstallDir, e);
            return;
        }
        units_32 = new Civ3PCXFilter(units32Name);
        if (logger.isDebugEnabled()) {
            logger.debug("about to read the units32");
        }
        units_32.readFile();
        if (logger.isDebugEnabled()) {
            logger.debug("about to parse the units32");
        }
        units_32.parse();
        if (logger.isDebugEnabled()) {
            logger.debug("about to buffer the units32");
        }
        units_32.createBufferedImage();
    }

    private static BufferedImage getUnitImageFromUnits32(int iconIndex) {
        units_32.createBufferedImage();
        BufferedImage units32 = units_32.getBufferedImage();
        int iconWidth = (units32.getWidth() - 1) / 32;
        int iconX = iconIndex % iconWidth;
        int iconY = iconIndex / iconWidth;
        BufferedImage image = units32.getSubimage(iconX * 32 + 1 + iconX, iconY * 32 + 1 + iconY, 32, 32);
        return image;
    }

    private static void setCivSpecificColors(int index) {
        int i;
        Color[] palette = Units32Supplier.loadColorPalette(index);
        for (i = 0; i < 15; ++i) {
            units_32.setColor(i, palette[i]);
        }
        for (i = 16; i < 64; i += 2) {
            units_32.setColor(i, palette[i]);
        }
    }

    private static Color[] loadColorPalette(int index) {
        String pcxString = null;
        try {
            IO biq = Main.biqFile.get(Main.biqIndex);
            pcxString = utils.findFile(ImageResources.ntpNames[index] + ".pcx", "Art" + Main.fileSlash + "units" + Main.fileSlash + "palettes" + Main.fileSlash, biq);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Couldn't find it " + e.getMessage());
        }
        OldPCXFilter pcx = new OldPCXFilter(pcxString);
        pcx.readFile();
        pcx.parse();
        Color[] palette = pcx.palette.palette;
        return palette;
    }

    static {
        iconCache = new HashMap<String, BufferedImage>();
    }
}

