/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.imageSupport;

import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import com.civfanatics.civ3.biqFile.util.LittleEndianDataOutputStream;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Bitmap;
import com.civfanatics.civ3.xplatformeditor.imageSupport.ImageFilter;
import com.civfanatics.civ3.xplatformeditor.imageSupport.UnsupportedVariantException;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class WindowsBMPFilter
implements ImageFilter {
    int bmpVersion;
    public static final int WINDOWS_2_BMP = 14;
    public static final int WINDOWS_3_BMP = 40;
    public static final int WINDOWS_NT_BMP = 52;
    public static final int WINDOWS_NT_ALPHA_BMP = 56;
    public static final int OS2_2_BMP = 64;
    public static final int WINDOWS_95_BMP = 108;
    Logger logger = Logger.getLogger(WindowsBMPFilter.class);
    String newline = "\n";
    File bmpFile;
    byte[] buffer;
    Bitmap bitmap;
    BufferedImage thisBufferedImage;
    byte[] rawImageData;
    short type;
    public static final short TYPE_WIN1 = 0;
    public static final short TYPE_WIN234 = 19778;
    short win1_width;
    short win1_height;
    short byteWidth;
    byte win1_planes;
    byte win1_bitsPerPixel;
    int fileLength;
    short xHotSpot;
    short yHotSpot;
    int bitmapOffset;
    int size;
    int width;
    int height;
    int widthInt;
    int heightInt;
    short widthShort;
    short heightShort;
    short planes;
    short bitsPerPixel;
    int compression;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_8BIT_RLE = 1;
    public static final int COMPRESSION_4BIT_RLE = 2;
    public static final int COMPRESSION_BITFIELDS = 3;
    int sizeOfBitmap;
    int horizontalResolution;
    int verticalResolution;
    int colorsUsed;
    int colorsImportant;
    int redMask;
    int greenMask;
    int blueMask;
    int alphaMask;
    int colorSpaceType;
    public static final int COLORSPACE_CALIBRATED_RGB = 0;
    public static final int COLORSPACE_DEVICE_DEPENDENT_RGB = 1;
    public static final int COLORSPACE_DEVICE_DEPENDENT_CYMK = 2;
    int redX;
    int redY;
    int redZ;
    int greenX;
    int greenY;
    int greenZ;
    int blueX;
    int blueY;
    int blueZ;
    int gammaRed;
    int gammaGreen;
    int gammaBlue;
    short units;
    short reserved;
    short recording;
    short rendering;
    int size1;
    int size2;
    int colorEncoding;
    int identifier;
    Palette palette;

    public WindowsBMPFilter() {
    }

    public WindowsBMPFilter(String string) {
        this.bmpFile = new File(string);
    }

    public void processFile(boolean createImage) {
        block5: {
            try {
                if (createImage) {
                    this.processFile();
                    break block5;
                }
                this.readFile();
                this.parse();
            }
            catch (UnsupportedVariantException unsupportedVariantException) {
                // empty catch block
            }
        }
    }

    @Override
    public void processFile() throws UnsupportedVariantException {
        this.readFile();
        this.parse();
        this.createBufferedImage();
    }

    public void readFile() {
        FilterInputStream inFile = null;
        try {
            inFile = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(this.bmpFile)));
            this.buffer = new byte[(int)this.bmpFile.length()];
            ((LittleEndianDataInputStream)inFile).readFully(this.buffer);
        }
        catch (IOException e) {
            this.logger.error("IO exception while reading", e);
        }
        finally {
            try {
                inFile.close();
            }
            catch (IOException e) {
                this.logger.error("IO exception while closing", e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void parse() throws UnsupportedVariantException {
        block74: {
            in = new LittleEndianDataInputStream(new ByteArrayInputStream(this.buffer));
            try {
                in.mark(this.buffer.length);
                this.type = in.readShort();
                if (this.type == 0) {
                    throw new UnsupportedVariantException("Windows 1 bitmaps are not currently supported");
                }
                if (this.type == 16706) {
                    throw new UnsupportedVariantException("OS/2 bitmap arrrays are not currently supported");
                }
                if (this.type == 17225) {
                    throw new UnsupportedVariantException("OS/2 bitmap icons are not currently supported");
                }
                if (this.type == 18755) {
                    throw new UnsupportedVariantException("OS/2 bitmap color icons are not currently supported");
                }
                if (this.type == 21584) {
                    throw new UnsupportedVariantException("OS/2 bitmap pointers are not currently supported");
                }
                if (this.type == 20547) {
                    throw new UnsupportedVariantException("OS/2 bitmap color pointers are not currently supported");
                }
                if (this.type != 19778) {
                    throw new UnsupportedVariantException("Unrecgonized bitmap format");
                }
                this.fileLength = in.readInt();
                this.xHotSpot = in.readShort();
                this.yHotSpot = in.readShort();
                this.bitmapOffset = in.readInt();
                this.size = in.readInt();
                if (this.size == 12) {
                    this.widthShort = in.readShort();
                    this.heightShort = in.readShort();
                    this.width = this.widthShort;
                    this.height = this.heightShort;
                } else {
                    this.widthInt = in.readInt();
                    this.heightInt = in.readInt();
                    this.width = this.widthInt;
                    this.height = this.heightInt;
                }
                rightSideUp = this.height < 0;
                this.planes = in.readShort();
                this.bitsPerPixel = in.readShort();
                if (this.size > 12) {
                    this.compression = in.readInt();
                    this.sizeOfBitmap = in.readInt();
                    this.horizontalResolution = in.readInt();
                    this.verticalResolution = in.readInt();
                    this.colorsUsed = in.readInt();
                    this.colorsImportant = in.readInt();
                    System.out.println(this);
                    if (this.compression == 2) {
                        throw new UnsupportedVariantException("Compressed bitmaps (4-bit RLE) are not currently supported");
                    }
                }
                numBytesSoFar = 40;
                if (this.size == 64) {
                    this.bmpVersion = 64;
                    this.units = in.readShort();
                    this.reserved = in.readShort();
                    this.recording = in.readShort();
                    this.rendering = in.readShort();
                    this.size1 = in.readInt();
                    this.size2 = in.readInt();
                    this.colorEncoding = in.readInt();
                    this.identifier = in.readInt();
                    numBytesSoFar = 64;
                }
                if ((size = this.size) == 40 && this.compression == 3) {
                    size += 12;
                }
                if (numBytesSoFar < size) {
                    this.redMask = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.greenMask = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.blueMask = in.readInt();
                    numBytesSoFar += 4;
                }
                System.out.println("NT ends here");
                if (numBytesSoFar < size) {
                    this.alphaMask = in.readInt();
                    numBytesSoFar += 4;
                }
                System.out.println("NT Photoshop (with alpha) ends here");
                if (numBytesSoFar < size) {
                    this.colorSpaceType = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.redX = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.redY = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.redZ = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.greenX = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.greenY = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.greenZ = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.blueX = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.blueY = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.blueZ = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.gammaRed = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.gammaGreen = in.readInt();
                    numBytesSoFar += 4;
                }
                if (numBytesSoFar < size) {
                    this.gammaBlue = in.readInt();
                    numBytesSoFar += 4;
                }
                totalColorsUsed = 0;
                if (this.colorsUsed != 0) {
                    totalColorsUsed = this.colorsUsed;
                } else if (this.bitsPerPixel < 16) {
                    totalColorsUsed = 1 << this.bitsPerPixel;
                }
                if (this.bitsPerPixel <= 8) {
                    this.palette = new Palette(totalColorsUsed);
                    for (i = 0; i < totalColorsUsed; ++i) {
                        blue = in.readByte();
                        green = in.readByte();
                        red = in.readByte();
                        if (size > 12) {
                            var10_19 = in.readByte();
                        }
                        this.palette.addColor(red, green, blue);
                    }
                    in.reset();
                    in.skip(this.bitmapOffset);
                    this.bitmap = new Bitmap(this.width, Math.abs(this.height), rightSideUp);
                    if (this.compression == 0) {
                        if (this.bitsPerPixel == 1) {
                            for (i = 0; i < Math.abs(this.height); ++i) {
                                bytesReadThisRow = 0;
                                h = 0;
                                block4: while (h < this.width) {
                                    next = in.readByte();
                                    ++bytesReadThisRow;
                                    for (j = 0; j < 8; ++j) {
                                        bit = (byte)((next & 128) >>> 7);
                                        this.bitmap.add(this.palette.getColor(bit));
                                        next = (byte)(next << 1);
                                        if (++h == this.width) continue block4;
                                    }
                                }
                                skipBytes = 4 - bytesReadThisRow % 4;
                                if (skipBytes == 4) {
                                    skipBytes = 0;
                                }
                                in.skip(skipBytes);
                            }
                        } else if (this.bitsPerPixel == 8) {
                            for (i = 0; i < Math.abs(this.height); ++i) {
                                for (j = 0; j < this.width; ++j) {
                                    next = in.readByte();
                                    this.bitmap.add(this.palette.getColor(next));
                                }
                                skipBytes = 4 - this.width % 4;
                                if (skipBytes == 4) {
                                    skipBytes = 0;
                                }
                                in.skip(skipBytes);
                            }
                        } else if (this.bitsPerPixel == 4) {
                            for (i = 0; i < Math.abs(this.height); ++i) {
                                bytesReadThisRow = 0;
                                for (j = 0; j < this.width; ++j) {
                                    next = in.readByte();
                                    ++bytesReadThisRow;
                                    nibble = (byte)(next >> 4 & 15);
                                    this.bitmap.add(this.palette.getColor(nibble));
                                    if (++j == this.width) break;
                                    nibble = (byte)(next & 15);
                                    this.bitmap.add(this.palette.getColor(nibble));
                                }
                                if ((skipBytes = 4 - bytesReadThisRow % 4) == 4) {
                                    skipBytes = 0;
                                }
                                in.skip(skipBytes);
                            }
                        }
                        break block74;
                    }
                    if (this.compression != 1 || this.bitsPerPixel != 4 && this.bitsPerPixel != 8) break block74;
                    block10: while (true) {
                        if ((nextByte = in.readByte()) == 0) {
                            code = in.readByte();
                            if (code != 1) {
                                if (code == 0) {
                                    this.bitmap.goToNextScanLine();
                                    continue;
                                }
                                if (code == 2) {
                                    throw new UnsupportedVariantException("Don't yet support delta code in encoded BMPs");
                                }
                                uCode = (short)(code & 255);
                                System.out.println(uCode + " bytes of unencoded data");
                                i = 0;
                                while (true) {
                                    if (i >= uCode) continue block10;
                                    data = in.readByte();
                                    this.bitmap.add(this.palette.getColor(data));
                                    ++i;
                                }
                            }
                            break block74;
                        }
                        data = in.readByte();
                        uNum = nextByte & 255;
                        System.out.println(uNum + " bytes of encoded data");
                        i = 0;
                        while (true) {
                            if (i < uNum) ** break;
                            continue block10;
                            this.bitmap.add(this.palette.getColor(data));
                            ++i;
                        }
                        break;
                    }
                }
                if (this.compression == 0 && this.bitsPerPixel == 24) {
                    in.reset();
                    in.skip(this.bitmapOffset);
                    this.bitmap = new Bitmap(this.width, Math.abs(this.height), rightSideUp);
                    for (i = 0; i < Math.abs(this.height); ++i) {
                        for (j = 0; j < this.width; ++j) {
                            blue = in.readByte();
                            green = in.readByte();
                            red = in.readByte();
                            sBlue = blue & 255;
                            sGreen = green & 255;
                            sRed = red & 255;
                            this.bitmap.add(new Color(sRed, sGreen, sBlue));
                        }
                        numThrowawayBytes = 4 - this.width * 3 % 4;
                        if (numThrowawayBytes == 4) {
                            numThrowawayBytes = 0;
                        }
                        in.skip(numThrowawayBytes);
                    }
                } else if (this.compression == 3 && this.bitsPerPixel == 32) {
                    in.reset();
                    in.skip(this.bitmapOffset);
                    this.bitmap = new Bitmap(this.width, Math.abs(this.height), rightSideUp);
                    maskHunt = 1;
                    redShift = 0;
                    while ((this.redMask & maskHunt) != maskHunt) {
                        maskHunt <<= 1;
                        ++redShift;
                    }
                    maskHunt = 1;
                    greenShift = 0;
                    while ((this.greenMask & maskHunt) != maskHunt) {
                        maskHunt <<= 1;
                        ++greenShift;
                    }
                    blueShift = 0;
                    maskHunt = 1;
                    while ((this.blueMask & maskHunt) != maskHunt) {
                        maskHunt <<= 1;
                        ++blueShift;
                    }
                    alphaShift = 0;
                    maskHunt = 1;
                    while ((this.alphaMask & maskHunt) != maskHunt) {
                        maskHunt <<= 1;
                        ++alphaShift;
                    }
                    System.out.println("redShift: " + redShift + ", greenShift: " + greenShift + ", blueShift: " + blueShift + ", alphaShift: " + alphaShift);
                    for (i = 0; i < Math.abs(this.height); ++i) {
                        for (j = 0; j < this.width; ++j) {
                            nextPixel = in.readInt();
                            red = nextPixel & this.redMask;
                            green = nextPixel & this.greenMask;
                            blue = nextPixel & this.blueMask;
                            alpha = nextPixel & this.alphaMask;
                            this.bitmap.add(new Color(red >>>= redShift, green >>>= greenShift, blue >>>= blueShift, 255 - (alpha >>>= alphaShift)));
                        }
                    }
                } else {
                    System.out.println("Shouldn't get here");
                }
            }
            catch (IOException e) {
                this.logger.error("IOException", e);
            }
        }
    }

    public void createBufferedImage() {
        this.thisBufferedImage = new BufferedImage(this.width, Math.abs(this.height), 2);
        int[] rgbArray = new int[this.width * Math.abs(this.height)];
        for (int y = 0; y < Math.abs(this.height); ++y) {
            for (int x = 0; x < this.width; ++x) {
                rgbArray[y * this.width + x] = this.bitmap.getPixelRGB(x, y);
            }
        }
        this.thisBufferedImage.setRGB(0, 0, this.width, Math.abs(this.height), rgbArray, 0, this.width);
    }

    @Override
    public BufferedImage getBufferedImage() {
        return this.thisBufferedImage;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("type: " + this.type + this.newline);
        buf.append("fileLength: " + this.fileLength + this.newline);
        buf.append("reserved1: " + this.xHotSpot + this.newline);
        buf.append("reserved2: " + this.yHotSpot + this.newline);
        buf.append("bitmapOffset: " + this.bitmapOffset + this.newline);
        buf.append("size: " + this.size + this.newline);
        buf.append("width: " + this.width + this.newline);
        buf.append("height: " + this.height + this.newline);
        buf.append("planes: " + this.planes + this.newline);
        buf.append("bitsPerPixel: " + this.bitsPerPixel + this.newline);
        buf.append("compression: " + this.compression + this.newline);
        buf.append("sizeOfBitmap: " + this.sizeOfBitmap + this.newline);
        buf.append("horizontalResolution: " + this.horizontalResolution + this.newline);
        buf.append("verticalResolution: " + this.verticalResolution + this.newline);
        buf.append("compressUsed: " + this.colorsUsed + this.newline);
        buf.append("colorsImportant: " + this.colorsImportant + this.newline);
        if (this.size >= 52) {
            buf.append("redMask: " + this.redMask + this.newline);
            buf.append("greenMask: " + this.greenMask + this.newline);
            buf.append("blueMask: " + this.blueMask + this.newline);
        }
        if (this.size >= 56) {
            buf.append("alphaMask: " + this.alphaMask + this.newline);
        }
        if (this.size >= 108) {
            buf.append("colorSpaceType: " + this.colorSpaceType + this.newline);
            buf.append("redX: " + this.redX + this.newline);
            buf.append("redY: " + this.redY + this.newline);
            buf.append("redZ: " + this.redZ + this.newline);
            buf.append("greenX: " + this.greenX + this.newline);
            buf.append("greenY: " + this.greenY + this.newline);
            buf.append("greenZ: " + this.greenZ + this.newline);
            buf.append("blueX: " + this.blueX + this.newline);
            buf.append("blueY: " + this.blueY + this.newline);
            buf.append("blueZ: " + this.blueZ + this.newline);
            buf.append("gammaRed: " + this.gammaRed + this.newline);
            buf.append("gammaGreen: " + this.gammaGreen + this.newline);
            buf.append("gammaBlue: " + this.gammaBlue + this.newline);
        }
        if (this.palette != null) {
            for (int i = 0; i < this.palette.paletteSize; ++i) {
                buf.append("palette color " + i + ": " + this.palette.getColor((byte)i).toString() + "\n");
            }
        }
        return buf.toString();
    }

    public void createBitmapFilter(BufferedImage image) {
        this.type = (short)19778;
        this.fileLength = 54;
        int sizeOfRow = 3 * image.getWidth();
        int additionalBytes = 4 - sizeOfRow % 4;
        if (additionalBytes == 4) {
            additionalBytes = 0;
        }
        this.fileLength += (sizeOfRow += additionalBytes) * image.getHeight();
        this.xHotSpot = 0;
        this.yHotSpot = 0;
        this.bitmapOffset = 54;
        this.size = 40;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.planes = 1;
        this.bitsPerPixel = (short)24;
        this.compression = 0;
        this.sizeOfBitmap = sizeOfRow * this.height;
        this.horizontalResolution = 0;
        this.verticalResolution = 0;
        this.colorsUsed = 1 << this.bitsPerPixel;
        this.colorsImportant = 0;
        this.bitmap = new Bitmap(this.width, this.height, false);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.bitmap.add(new Color(image.getRGB(j, this.height - 1 - i)));
            }
        }
    }

    public void createRawData() {
        int additionalBytes = 4 - this.width * 3 % 4;
        if (additionalBytes == 4) {
            additionalBytes = 0;
        }
        System.out.println("Additional bytes per row: " + additionalBytes);
        this.rawImageData = new byte[this.sizeOfBitmap];
        int ptr = 0;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.rawImageData[ptr] = (byte)(this.bitmap.getPixelBlue(x, this.height - 1 - y) & 0xFF);
                this.rawImageData[++ptr] = (byte)(this.bitmap.getPixelGreen(x, this.height - 1 - y) & 0xFF);
                this.rawImageData[++ptr] = (byte)(this.bitmap.getPixelRed(x, this.height - 1 - y) & 0xFF);
                ++ptr;
            }
            for (int i = 0; i < additionalBytes; ++i) {
                this.rawImageData[ptr] = 0;
                ++ptr;
            }
        }
    }

    public void exportFile(String fileName) {
        File outFile = new File(fileName);
        LittleEndianDataOutputStream fos = null;
        try {
            fos = new LittleEndianDataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        }
        catch (FileNotFoundException e) {
            this.logger.error("File not found", e);
        }
        try {
            fos.writeShort(this.type);
            fos.writeInt(this.fileLength);
            fos.writeShort(this.xHotSpot);
            fos.writeShort(this.yHotSpot);
            fos.writeInt(this.bitmapOffset);
            fos.writeInt(this.size);
            fos.writeInt(this.width);
            fos.writeInt(this.height);
            fos.writeShort(this.planes);
            fos.writeShort(this.bitsPerPixel);
            fos.writeInt(this.compression);
            fos.writeInt(this.sizeOfBitmap);
            fos.writeInt(this.horizontalResolution);
            fos.writeInt(this.verticalResolution);
            fos.writeInt(this.colorsUsed);
            fos.writeInt(this.colorsImportant);
            fos.write(this.rawImageData);
            fos.close();
        }
        catch (IOException e) {
            this.logger.error("", e);
        }
    }

    public void exportImage(BufferedImage image, String fileName) {
        this.createBitmapFilter(image);
        this.createRawData();
        this.exportFile(fileName);
    }

    public int getPaletteSize() {
        return this.palette.paletteSize;
    }

    public Color[] getPaletteColors() {
        return this.palette.palette;
    }

    public int getPaletteIndexAt(int x, int y) {
        Color c = this.bitmap.getPixel(x, y);
        for (int i = 0; i < this.palette.paletteSize; ++i) {
            if (!this.palette.palette[i].equals(c)) continue;
            return i;
        }
        return 0;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public class Palette {
        Color[] palette;
        int paletteSize;
        int maxSize;

        public Palette(int size) {
            this.palette = new Color[size];
            this.maxSize = size;
            this.paletteSize = 0;
        }

        public boolean addColor(byte red, byte green, byte blue) {
            int sBlue;
            if (this.paletteSize >= this.maxSize) {
                return false;
            }
            int sRed = red < 0 ? red + 256 : red;
            int sGreen = green < 0 ? green + 256 : green;
            int n = sBlue = blue < 0 ? blue + 256 : blue;
            if (WindowsBMPFilter.this.logger.isDebugEnabled()) {
                WindowsBMPFilter.this.logger.debug("sRed: " + sRed + " sGreen: " + sGreen + " sBlue: " + sBlue);
            }
            this.palette[this.paletteSize] = new Color(sRed, sGreen, sBlue);
            ++this.paletteSize;
            return true;
        }

        public boolean makeTransparent(int index) {
            Color newColor;
            if (index > 255) {
                return false;
            }
            Color currentColor = this.palette[index];
            this.palette[index] = newColor = new Color(currentColor.getRed(), currentColor.getGreen(), currentColor.getBlue(), 0);
            return true;
        }

        public void setColor(int index, Color color) {
            Color oldColor = this.palette[index];
            this.palette[index] = color;
            for (int x = 0; x < WindowsBMPFilter.this.bitmap.xsize; ++x) {
                for (int y = 0; y < WindowsBMPFilter.this.bitmap.ysize; ++y) {
                    if (WindowsBMPFilter.this.bitmap.map[x][y] != oldColor.getRGB()) continue;
                    WindowsBMPFilter.this.bitmap.map[x][y] = color.getRGB();
                }
            }
        }

        public Color getColor(byte index) {
            int sIndex = index & 0xFF;
            return this.palette[sIndex];
        }

        public String toString() {
            StringBuffer toRtn = new StringBuffer();
            for (int i = 0; i < this.paletteSize; ++i) {
                toRtn.append(this.palette[i].toString() + WindowsBMPFilter.this.newline);
            }
            return toRtn.toString();
        }
    }
}

