/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.playground;

import com.civfanatics.civ3.biqFile.util.LittleEndianDataInputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DiploTableTest {
    public static void main(String[] args) throws FileNotFoundException {
        File f = new File("D:\\Civilization III\\Conquests\\Saves\\Quint 1752 LEAD 0x02 Unknown Section.bin");
        LittleEndianDataInputStream lis = new LittleEndianDataInputStream(new BufferedInputStream(new FileInputStream(f)));
        try {
            for (int i = 0; i < 32; ++i) {
                int numEntries = lis.readInt();
                System.out.println("\nNum entries for LEAD " + i + " + is " + numEntries);
                if (numEntries < 0) {
                    System.exit(numEntries);
                }
                for (int n = 0; n < numEntries; ++n) {
                    int type = lis.readInt();
                    int data1 = lis.readInt();
                    int data2 = lis.readInt();
                    System.out.println("  Deal found!  Type " + DiploTableTest.getType(type, data1) + ", data 1 = " + data1 + ", data2 = " + data2);
                    if (type != -1) continue;
                    System.out.println("  Processing group deal with " + data1 + " items, expiring on turn " + data2);
                    for (int x = 0; x < data1; ++x) {
                        int subType = lis.readInt();
                        int subdata1 = lis.readInt();
                        int subdata2 = lis.readInt();
                        System.out.println("    Processed sub-deal!  Type = " + DiploTableTest.getType(subType, subdata1) + "; data1 = " + subdata1 + "; data2 = " + subdata2);
                    }
                }
                System.out.println("  End of LEAD " + i + "; bytes read = " + lis.numBytesRead);
            }
        }
        catch (IOException ex) {
            System.err.println("Boom!!!!");
            System.err.println(ex.getMessage());
        }
        try {
            lis.readByte();
            System.err.println("BOOM!  Was able to continue reading.");
        }
        catch (EOFException ex) {
            System.out.println("Correctly found end of file");
        }
        catch (IOException ex) {
            System.err.println("Unexpected BOOM!");
        }
    }

    private static String getType(int type, int data1) {
        switch (type) {
            case 0: {
                if (data1 == 0) {
                    return "Peace Treaty";
                }
                if (data1 == 1) {
                    return "Mutual Protection Pact";
                }
                if (data1 == 2) {
                    return "Right of Passage";
                }
                return "***Some Random Agreement** (" + data1 + ")";
            }
            case 1: {
                return "Alliance";
            }
            case 2: {
                return "Embargo";
            }
            case 5: {
                return "Strategic Resource";
            }
            case 6: {
                return "Luxury Resource";
            }
            case 7: {
                return "Gold Per Turn";
            }
            case -1: {
                return "Start of Group";
            }
        }
        return "***Unknown*** (" + type + ")";
    }
}

