/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.savFunctionality;

import com.sun.javafx.charts.Legend;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class CustomHistograph
extends Application {
    private static final Comparator<Integer> VALUE = Comparator.comparing(Integer::intValue);
    private static final int Y_AXIS_GRANULARITY = 2000;
    private int numPlayers;
    private String label;
    private List<List<Integer>> scores;
    private List<String> civNames;
    private List<Color> colors;
    private List<Boolean> visible;

    public void provideScores(List<List<Integer>> scores) {
        this.scores = scores;
    }

    public void provideCivNames(List<String> names) {
        this.civNames = names;
    }

    public void sendData(String label, List<List<Integer>> scores, List<String> names, List<Color> colors) {
        this.numPlayers = scores.size();
        this.label = label;
        this.scores = scores;
        this.civNames = names;
        this.colors = colors;
        this.visible = new ArrayList<Boolean>(scores.size());
        for (String name : names) {
            this.visible.add(true);
        }
    }

    public void start(Stage primaryStage) throws Exception {
        NumberAxis xaxis = new NumberAxis(0.0, (double)(this.scores.get(0).size() + 10), 10.0);
        NumberAxis yaxis = new NumberAxis(0.0, (double)this.getScoresUpperBound(this.scores), 2000.0);
        xaxis.setLabel("Turn");
        yaxis.setLabel(this.label);
        LineChart linechart = new LineChart((Axis)xaxis, (Axis)yaxis);
        linechart.getStylesheets().add((Object)"styles/styles.css");
        linechart.setCreateSymbols(true);
        for (int i = 0; i < this.civNames.size(); ++i) {
            System.out.println(this.civNames.get(i));
        }
        String[] symbolStyles = new String[this.scores.size()];
        for (int h = 0; h < this.scores.size(); ++h) {
            XYChart.Series series = new XYChart.Series();
            series.setName(this.civNames.get(h));
            for (int i = 0; i < this.scores.get(h).size(); ++i) {
                System.out.println("Adding " + i + ", " + this.scores.get(h).get(i) + " to player " + (h + 1));
                series.getData().add((Object)new XYChart.Data((Object)i, (Object)this.scores.get(h).get(i)));
            }
            linechart.getData().addAll(new Object[]{series});
            series.getNode().setOnMouseClicked(event -> {});
            this.setSeriesColor(h, (XYChart.Series<Number, Number>)series, symbolStyles);
        }
        Platform.runLater(() -> {
            block2: for (Node node : linechart.lookupAll(".chart-legend-item-symbol")) {
                for (String styleClass : node.getStyleClass()) {
                    if (!styleClass.startsWith("series")) continue;
                    int i = Integer.parseInt(styleClass.substring(6));
                    node.setStyle(symbolStyles[i]);
                    continue block2;
                }
            }
            for (int i = 0; i < this.numPlayers; ++i) {
                Legend l = (Legend)linechart.lookupAll(".chart-legend").iterator().next();
                Legend.LegendItem li = (Legend.LegendItem)l.getItems().get(i);
                int player = i;
                try {
                    Field f = Legend.LegendItem.class.getDeclaredField("label");
                    f.setAccessible(true);
                    Label legendLabel = (Label)f.get(li);
                    legendLabel.setOnMouseClicked(event -> {
                        if (!legendLabel.getStyleClass().contains((Object)"strikethrough")) {
                            legendLabel.getStyleClass().add((Object)"strikethrough");
                            this.toggleSeriesVisibility(linechart, player, false);
                        } else {
                            legendLabel.getStyleClass().remove((Object)"strikethrough");
                            this.toggleSeriesVisibility(linechart, player, true);
                        }
                    });
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(":(");
                }
            }
        });
        AnchorPane anchor = new AnchorPane();
        AnchorPane.setTopAnchor((Node)linechart, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)linechart, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)linechart, (Double)0.0);
        AnchorPane.setRightAnchor((Node)linechart, (Double)0.0);
        anchor.getChildren().add((Object)linechart);
        Scene scene = new Scene((Parent)anchor, 1280.0, 1024.0);
        primaryStage.setScene(scene);
        primaryStage.setTitle(this.label + " Histograph");
        primaryStage.show();
    }

    private void toggleSeriesVisibility(LineChart linechart, int player, boolean visible) {
        this.visible.set(player, visible);
        XYChart.Series s = (XYChart.Series)linechart.getData().get(player);
        s.getNode().setVisible(visible);
        for (Object o : s.getData()) {
            XYChart.Data data = (XYChart.Data)o;
            data.getNode().setVisible(visible);
        }
        ((NumberAxis)linechart.getYAxis()).setUpperBound((double)this.getScoresUpperBound(this.scores));
    }

    private void setSeriesColor(int h, XYChart.Series<Number, Number> series, String[] symbolStyles) {
        String symbolStyle;
        Color civColor = this.colors.get(h);
        String color = String.format("rgba(%d, %d, %d, 1.0)", civColor.getRed(), civColor.getGreen(), civColor.getBlue());
        String lineStyle = String.format("-fx-stroke: %s;", color);
        series.getNode().lookup(".chart-series-line").setStyle(lineStyle);
        symbolStyles[h] = symbolStyle = String.format("-fx-background-color: %s, whitesmoke;", color);
        for (XYChart.Data data : series.getData()) {
            data.getNode().lookup(".chart-line-symbol").setStyle(symbolStyle);
        }
    }

    int getScoresUpperBound(List<List<Integer>> scores) {
        int max = -1;
        int i = 0;
        for (List<Integer> scoreList : scores) {
            int maxPlayerScore;
            if (this.visible.get(i).booleanValue() && (maxPlayerScore = scoreList.stream().collect(Collectors.maxBy(VALUE)).orElse(-1).intValue()) > max) {
                max = maxPlayerScore;
            }
            ++i;
        }
        return 2000 * (max / 2000) + 2000;
    }
}

