/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.specialty;

import com.civfanatics.civ3.biqFile.BLDG;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.TECH;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.specialty.CSVWriter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class CSVPanel
extends JFrame {
    Logger logger = Logger.getLogger(this.getClass());
    static final int NUM_UNIT_ATTRIBUTES = 11;
    static final int NUM_BLDG_ATTRIBUTES = 20;
    static final int NUM_TECH_ATTRIBUTES = 7;
    static final int NUM_RESOURCE_ATTRIBUTES = 6;
    static final int SPNR_WIDTH = 16;
    static final String NONE = "None";
    int[] unitSpinnerValues;
    JSpinner[] unitSpinners;
    String[] unitAttributes;
    JCheckBox[] unitChecks;
    int[] buildingSpinnerValues;
    String[] buildingAttributes;
    JCheckBox[] buildingChecks;
    JSpinner[] buildingSpinners;
    int[] techSpinnerValues;
    String[] techAttributes;
    JSpinner[] techSpinners;
    JCheckBox[] techChecks;
    int[] resourceSpinnerValues;
    String[] resourceAttributes;
    JSpinner[] resourceSpinners;
    JCheckBox[] resourceChecks;
    JFrame thisFrame = this;
    IO biqFile;
    private JCheckBox chkUnit0;
    private JCheckBox chkUnit1;
    private JCheckBox chkUnit10;
    private JCheckBox chkUnit2;
    private JCheckBox chkUnit3;
    private JCheckBox chkUnit4;
    private JCheckBox chkUnit5;
    private JCheckBox chkUnit6;
    private JCheckBox chkUnit7;
    private JCheckBox chkUnit8;
    private JCheckBox chkUnit9;
    private JButton btnExport;
    private JButton btnCancel;
    private JCheckBox chkIncludeUnits;
    private JCheckBox chkIncludeBuildings;
    private JCheckBox chkIncludeTechnologies;
    private JCheckBox chkIncludeResources;
    private JPanel pnlUnits;
    private JPanel pnlBuildings;
    private JPanel pnlTechnologies;
    private JPanel pnlResources;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextArea jTextArea3;
    private JTextArea txtDescription;
    private JSpinner spnrUnit0;
    private JSpinner spnrUnit1;
    private JSpinner spnrUnit10;
    private JSpinner spnrUnit2;
    private JSpinner spnrUnit3;
    private JSpinner spnrUnit4;
    private JSpinner spnrUnit5;
    private JSpinner spnrUnit6;
    private JSpinner spnrUnit7;
    private JSpinner spnrUnit8;
    private JSpinner spnrUnit9;

    public CSVPanel(IO biqFile) {
        this();
        this.biqFile = biqFile;
    }

    public CSVPanel() {
        int i;
        this.initComponents();
        this.unitSpinnerValues = new int[11];
        for (i = 0; i < 11; ++i) {
            this.unitSpinnerValues[i] = 0;
        }
        this.unitSpinners = new JSpinner[11];
        this.unitSpinners[0] = this.spnrUnit0;
        this.unitSpinners[1] = this.spnrUnit1;
        this.unitSpinners[2] = this.spnrUnit2;
        this.unitSpinners[3] = this.spnrUnit3;
        this.unitSpinners[4] = this.spnrUnit4;
        this.unitSpinners[5] = this.spnrUnit5;
        this.unitSpinners[6] = this.spnrUnit6;
        this.unitSpinners[7] = this.spnrUnit7;
        this.unitSpinners[8] = this.spnrUnit8;
        this.unitSpinners[9] = this.spnrUnit9;
        this.unitSpinners[10] = this.spnrUnit10;
        this.unitAttributes = new String[11];
        this.unitAttributes[0] = "Unit Name";
        this.unitAttributes[1] = "Attack";
        this.unitAttributes[2] = "Defence";
        this.unitAttributes[3] = "Movement";
        this.unitAttributes[4] = "Hitpoint Bonus";
        this.unitAttributes[5] = "Bombard Strength";
        this.unitAttributes[6] = "Range";
        this.unitAttributes[7] = "Rate of Fire";
        this.unitAttributes[8] = "Cost";
        this.unitAttributes[9] = "Zone of Control";
        this.unitAttributes[10] = "Prerequisites";
        this.unitChecks = new JCheckBox[11];
        this.unitChecks[0] = this.chkUnit0;
        this.unitChecks[1] = this.chkUnit1;
        this.unitChecks[2] = this.chkUnit2;
        this.unitChecks[3] = this.chkUnit3;
        this.unitChecks[4] = this.chkUnit4;
        this.unitChecks[5] = this.chkUnit5;
        this.unitChecks[6] = this.chkUnit6;
        this.unitChecks[7] = this.chkUnit7;
        this.unitChecks[8] = this.chkUnit8;
        this.unitChecks[9] = this.chkUnit9;
        this.unitChecks[10] = this.chkUnit10;
        for (i = 0; i < 11; ++i) {
            this.unitChecks[i].setSelected(true);
            this.unitChecks[i].setText(this.unitAttributes[i]);
        }
        this.buildingAttributes = new String[20];
        this.buildingChecks = new JCheckBox[20];
        this.buildingSpinners = new JSpinner[20];
        this.buildingSpinnerValues = new int[20];
        this.buildingAttributes[0] = "Building Name";
        this.buildingAttributes[1] = "Type of Building";
        this.buildingAttributes[2] = "Cost";
        this.buildingAttributes[3] = "Maintenance";
        this.buildingAttributes[4] = "Pollution";
        this.buildingAttributes[5] = "Culture";
        this.buildingAttributes[6] = "Production Bonus";
        this.buildingAttributes[7] = "Autoproduces";
        this.buildingAttributes[8] = "Era";
        this.buildingAttributes[9] = "Required Technology";
        this.buildingAttributes[10] = "Required Resources";
        this.buildingAttributes[11] = "Required Government";
        this.buildingAttributes[12] = "Required Building";
        this.buildingAttributes[13] = "Happiness Bonus (city)";
        this.buildingAttributes[14] = "Happiness Bonus (empire)";
        this.buildingAttributes[15] = "Unhappiness (city)";
        this.buildingAttributes[16] = "Unhappiness (empire)";
        this.buildingAttributes[17] = "Air Attack";
        this.buildingAttributes[18] = "Defence Bonus";
        this.buildingAttributes[19] = "Available To";
        for (i = 0; i < 20; ++i) {
            this.buildingChecks[i] = new JCheckBox();
            this.buildingSpinners[i] = new JSpinner();
            this.buildingChecks[i].setSelected(true);
            this.buildingChecks[i].setText(this.buildingAttributes[i]);
        }
        this.techAttributes = new String[7];
        this.techSpinners = new JSpinner[7];
        this.techSpinnerValues = new int[7];
        this.techChecks = new JCheckBox[7];
        this.techAttributes[0] = "Tech Name";
        this.techAttributes[1] = "Era";
        this.techAttributes[2] = "Prerequisites";
        this.techAttributes[3] = "Cost";
        this.techAttributes[4] = "X position";
        this.techAttributes[5] = "Y position";
        this.techAttributes[6] = "Available To";
        for (i = 0; i < 7; ++i) {
            this.techChecks[i] = new JCheckBox();
            this.techChecks[i].setSelected(true);
            this.techChecks[i].setText(this.techAttributes[i]);
            this.techSpinners[i] = new JSpinner();
            this.techSpinnerValues[i] = 0;
        }
        this.resourceAttributes = new String[6];
        this.resourceSpinners = new JSpinner[6];
        this.resourceSpinnerValues = new int[6];
        this.resourceChecks = new JCheckBox[6];
        this.resourceAttributes[0] = "Resource Name";
        this.resourceAttributes[1] = "Type of resource";
        this.resourceAttributes[2] = "Food bonus";
        this.resourceAttributes[3] = "Shield bonus";
        this.resourceAttributes[4] = "Commerce bonus";
        this.resourceAttributes[5] = "Prerequisites";
        for (i = 0; i < 6; ++i) {
            this.resourceChecks[i] = new JCheckBox();
            this.resourceChecks[i].setSelected(true);
            this.resourceChecks[i].setText(this.resourceAttributes[i]);
            this.resourceSpinners[i] = new JSpinner();
            this.resourceSpinnerValues[i] = 0;
        }
        this.setItUp();
    }

    private void initComponents() {
        this.pnlUnits = new JPanel();
        this.chkUnit1 = new JCheckBox();
        this.chkUnit0 = new JCheckBox();
        this.chkUnit4 = new JCheckBox();
        this.chkUnit5 = new JCheckBox();
        this.chkUnit6 = new JCheckBox();
        this.chkUnit7 = new JCheckBox();
        this.chkUnit8 = new JCheckBox();
        this.chkUnit9 = new JCheckBox();
        this.chkUnit10 = new JCheckBox();
        this.spnrUnit10 = new JSpinner();
        this.spnrUnit0 = new JSpinner();
        this.spnrUnit1 = new JSpinner();
        this.spnrUnit4 = new JSpinner();
        this.spnrUnit5 = new JSpinner();
        this.spnrUnit6 = new JSpinner();
        this.spnrUnit7 = new JSpinner();
        this.spnrUnit8 = new JSpinner();
        this.spnrUnit9 = new JSpinner();
        this.chkUnit2 = new JCheckBox();
        this.spnrUnit2 = new JSpinner();
        this.chkUnit3 = new JCheckBox();
        this.spnrUnit3 = new JSpinner();
        this.pnlBuildings = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.pnlTechnologies = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.pnlResources = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane4 = new JScrollPane();
        this.txtDescription = new JTextArea();
        this.btnExport = new JButton();
        this.btnCancel = new JButton();
        this.chkIncludeUnits = new JCheckBox();
        this.chkIncludeBuildings = new JCheckBox();
        this.chkIncludeTechnologies = new JCheckBox();
        this.chkIncludeResources = new JCheckBox();
    }

    private void setItUp() {
        int i;
        int i2;
        int i3;
        int i4;
        this.getContentPane().setPreferredSize(new Dimension(900, 732));
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.gridheight = 2;
        c.fill = 1;
        c.weightx = 0.5;
        c.weighty = 0.25;
        this.txtDescription.setColumns(20);
        this.txtDescription.setRows(5);
        this.txtDescription.setText("This utility allows you to export summaries of unit, building, technology, and resource attributes to one or more\nComma Separated Value (.CSV) file, which can be opened as a spreadsheet in Microsoft Excel and most other\nspreadsheet programs.  You can then sort the attributes as you please, print off hard copies of the spreadsheets,\nand perform whatever calculations you may please on the values as your spreadsheet software allows.\n\nSelect the attributes you want exported, use the up/down arrows to change the order they will appear in the\nspreadsheet, and then click \"Export\" to choose the file(s) you wish to write to and create the .csv file(s).\n(note: it is not possible to create a multi-sheet CSV document, thus the multiple CSV files)");
        this.jScrollPane4.setViewportView(this.txtDescription);
        this.getContentPane().add((Component)this.jScrollPane4, c);
        this.setTitle("Comma Separated Value Export Tool");
        this.pnlUnits.setBorder(BorderFactory.createTitledBorder("Units"));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(c.weightx);
        }
        this.chkUnit1.setText("Attack");
        this.chkUnit0.setText("Unit Name");
        this.chkUnit4.setText("Hitpoint Bonus");
        this.chkUnit5.setText("Bombard Stength");
        this.chkUnit6.setText("Range");
        this.chkUnit7.setText("Rate of Fire");
        this.chkUnit8.setText("Cost");
        this.chkUnit9.setText("Zone of Control");
        this.chkUnit10.setText("Prerequisites");
        for (i4 = 0; i4 < 11; ++i4) {
            this.unitSpinners[i4].setPreferredSize(new Dimension(16, 20));
            this.unitSpinners[i4].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    CSVPanel.this.handleSpinnerEvent(evt, 11, CSVPanel.this.unitSpinners, CSVPanel.this.unitChecks, CSVPanel.this.unitSpinnerValues, CSVPanel.this.unitAttributes);
                }
            });
        }
        this.pnlUnits.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 21;
        c.weightx = 0.0;
        c.weighty = 0.04;
        c.insets = new Insets(2, 0, 2, 0);
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit0, c);
        ++c.gridx;
        c.weightx = 0.5;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit0, c);
        --c.gridx;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit1, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit1, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit2, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit2, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit3, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit3, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit4, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit4, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit5, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit5, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit6, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit6, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit7, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit7, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit8, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit8, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit9, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit9, c);
        --c.gridx;
        ++c.gridy;
        c.fill = 3;
        this.pnlUnits.add((Component)this.spnrUnit10, c);
        ++c.gridx;
        c.fill = 1;
        this.pnlUnits.add((Component)this.chkUnit10, c);
        for (i4 = 11; i4 < 20; ++i4) {
            JLabel dummyPanel = new JLabel("");
            dummyPanel.setPreferredSize(new Dimension(1, 20));
            c.gridx = 0;
            ++c.gridy;
            this.pnlUnits.add((Component)dummyPanel, c);
        }
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 0.5;
        c.weighty = 0.1;
        c.fill = 1;
        this.getContentPane().add((Component)this.pnlUnits, c);
        for (i4 = 0; i4 < 20; ++i4) {
            this.buildingSpinners[i4].setPreferredSize(new Dimension(16, 20));
            this.buildingSpinners[i4].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    CSVPanel.this.handleSpinnerEvent(evt, 20, CSVPanel.this.buildingSpinners, CSVPanel.this.buildingChecks, CSVPanel.this.buildingSpinnerValues, CSVPanel.this.buildingAttributes);
                }
            });
        }
        this.pnlBuildings.setLayout(new GridBagLayout());
        GridBagConstraints b = new GridBagConstraints();
        b.gridx = 0;
        b.gridy = 0;
        b.gridheight = 1;
        b.gridwidth = 1;
        b.weighty = 0.04;
        b.anchor = 21;
        b.fill = 3;
        b.insets = new Insets(0, 0, 0, 0);
        this.pnlBuildings.add((Component)this.buildingSpinners[0], b);
        ++b.gridx;
        b.fill = 1;
        b.weightx = 0.5;
        this.pnlBuildings.add((Component)this.buildingChecks[0], b);
        b.weightx = 0.0;
        for (i3 = 1; i3 < 20; ++i3) {
            --b.gridx;
            ++b.gridy;
            b.fill = 3;
            this.pnlBuildings.add((Component)this.buildingSpinners[i3], b);
            ++b.gridx;
            b.fill = 1;
            this.pnlBuildings.add((Component)this.buildingChecks[i3], b);
        }
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.fill = 1;
        this.pnlBuildings.setBorder(BorderFactory.createTitledBorder("Buildings"));
        this.getContentPane().add((Component)this.pnlBuildings, c);
        for (i3 = 0; i3 < 7; ++i3) {
            this.techSpinners[i3].setPreferredSize(new Dimension(16, 20));
            this.techSpinners[i3].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    CSVPanel.this.handleSpinnerEvent(evt, 7, CSVPanel.this.techSpinners, CSVPanel.this.techChecks, CSVPanel.this.techSpinnerValues, CSVPanel.this.techAttributes);
                }
            });
        }
        this.pnlTechnologies.setLayout(new GridBagLayout());
        GridBagConstraints t = new GridBagConstraints();
        t.gridx = 0;
        t.gridy = 0;
        t.gridheight = 1;
        t.gridwidth = 1;
        t.weighty = 0.04;
        t.anchor = 23;
        t.fill = 3;
        t.insets = new Insets(2, 0, 2, 0);
        this.pnlTechnologies.add((Component)this.techSpinners[0], t);
        ++t.gridx;
        t.fill = 1;
        t.weightx = 0.5;
        this.pnlTechnologies.add((Component)this.techChecks[0], t);
        t.weightx = 0.0;
        for (i2 = 1; i2 < 7; ++i2) {
            --t.gridx;
            ++t.gridy;
            t.fill = 3;
            this.pnlTechnologies.add((Component)this.techSpinners[i2], t);
            ++t.gridx;
            t.fill = 1;
            this.pnlTechnologies.add((Component)this.techChecks[i2], t);
        }
        for (i2 = 7; i2 < 20; ++i2) {
            JLabel dummyPanel = new JLabel("");
            dummyPanel.setPreferredSize(new Dimension(1, 20));
            t.gridx = 0;
            ++t.gridy;
            this.pnlTechnologies.add((Component)dummyPanel, t);
        }
        c.gridx = 2;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.fill = 1;
        this.pnlTechnologies.setBorder(BorderFactory.createTitledBorder("Technologies"));
        this.getContentPane().add((Component)this.pnlTechnologies, c);
        for (i2 = 0; i2 < 6; ++i2) {
            this.resourceSpinners[i2].setPreferredSize(new Dimension(16, 20));
            this.resourceSpinners[i2].addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent evt) {
                    CSVPanel.this.handleSpinnerEvent(evt, 6, CSVPanel.this.resourceSpinners, CSVPanel.this.resourceChecks, CSVPanel.this.resourceSpinnerValues, CSVPanel.this.resourceAttributes);
                }
            });
        }
        this.pnlResources.setLayout(new GridBagLayout());
        GridBagConstraints r = new GridBagConstraints();
        r.gridx = 0;
        r.gridy = 0;
        r.gridheight = 1;
        r.gridwidth = 1;
        r.weighty = 0.04;
        r.anchor = 23;
        r.fill = 3;
        r.insets = new Insets(2, 0, 2, 0);
        this.pnlResources.add((Component)this.resourceSpinners[0], r);
        ++r.gridx;
        r.fill = 1;
        r.weightx = 0.5;
        this.pnlResources.add((Component)this.resourceChecks[0], r);
        r.weightx = 0.0;
        for (i = 1; i < 6; ++i) {
            --r.gridx;
            ++r.gridy;
            r.fill = 3;
            this.pnlResources.add((Component)this.resourceSpinners[i], r);
            ++r.gridx;
            r.fill = 1;
            this.pnlResources.add((Component)this.resourceChecks[i], r);
        }
        for (i = 6; i < 20; ++i) {
            JLabel dummyPanel = new JLabel("");
            dummyPanel.setPreferredSize(new Dimension(1, 20));
            r.gridx = 0;
            ++r.gridy;
            this.pnlResources.add((Component)dummyPanel, r);
        }
        c.gridx = 3;
        c.gridy = 3;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.fill = 1;
        this.pnlResources.setBorder(BorderFactory.createTitledBorder("(Possible) Resources"));
        this.getContentPane().add((Component)this.pnlResources, c);
        this.btnExport.setText("Export");
        this.btnExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i;
                CSVWriter writer;
                File file;
                int rtrnVal;
                int errorOnStage = 0;
                JFileChooser chooser = Main.jfcCSVChooser;
                if (CSVPanel.this.chkIncludeUnits.isSelected()) {
                    int response;
                    chooser.setDialogTitle("Select the output file for the unit spreadsheet");
                    rtrnVal = chooser.showSaveDialog(null);
                    if (rtrnVal != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (!file.getPath().endsWith(".csv")) {
                        file = new File(file.getPath() + ".csv");
                    }
                    if (file.exists() && (response = JOptionPane.showOptionDialog(null, "File already exists.  Overwrite?", "Existing File", 0, 3, null, null, null)) != 0) {
                        return;
                    }
                    try {
                        writer = new CSVWriter(new BufferedOutputStream(new FileOutputStream(file)));
                        for (int i2 = 0; i2 < 11; ++i2) {
                            if (CSVPanel.this.unitAttributes[i2].equals("Unit Name") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Unit Name");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Attack") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Attack");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Defence") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Defence");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Movement") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Movement");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Hitpoint Bonus") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Hitpoint Bonus");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Bombard Strength") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Bombard Strength");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Range") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Range");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Rate of Fire") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Rate of Fire");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Cost") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Cost");
                                continue;
                            }
                            if (CSVPanel.this.unitAttributes[i2].equals("Zone of Control") && CSVPanel.this.unitChecks[i2].isSelected()) {
                                writer.write("Zone of Control");
                                continue;
                            }
                            if (!CSVPanel.this.unitAttributes[i2].equals("Prerequisites") || !CSVPanel.this.unitChecks[i2].isSelected()) continue;
                            writer.write("Prerequisites");
                        }
                        writer.endRecord();
                        for (int n = 0; n < CSVPanel.this.biqFile.unit.size(); ++n) {
                            for (i = 0; i < 11; ++i) {
                                PRTO unit = CSVPanel.this.biqFile.unit.get(n);
                                if (CSVPanel.this.unitAttributes[i].equals("Unit Name") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.write(unit.getName());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Attack") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getAttack());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Defence") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getDefence());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Movement") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getMovement());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Hitpoint Bonus") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getHitPointBonus());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Bombard Strength") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getBombardStrength());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Range") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getBombardRange());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Rate of Fire") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getRateOfFire());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Cost") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeInteger(unit.getShieldCost());
                                    continue;
                                }
                                if (CSVPanel.this.unitAttributes[i].equals("Zone of Control") && CSVPanel.this.unitChecks[i].isSelected()) {
                                    writer.writeBool(unit.getZoneOfControl() == 1);
                                    continue;
                                }
                                if (!CSVPanel.this.unitAttributes[i].equals("Prerequisites") || !CSVPanel.this.unitChecks[i].isSelected()) continue;
                                if (unit.getRequiredTech() != -1) {
                                    writer.write(CSVPanel.this.biqFile.technology.get(unit.getRequiredTech()).getName());
                                    continue;
                                }
                                writer.write(CSVPanel.NONE);
                            }
                            writer.endRecord();
                        }
                        try {
                            writer.close();
                        }
                        catch (IOException f) {
                            System.err.println("Unable to close file");
                            errorOnStage = 1;
                            JOptionPane.showMessageDialog(null, "Failed to export file for units");
                        }
                    }
                    catch (FileNotFoundException f) {
                        System.err.println(f);
                        errorOnStage = 1;
                        JOptionPane.showMessageDialog(null, "Failed to export file for units");
                    }
                }
                if (CSVPanel.this.chkIncludeBuildings.isSelected()) {
                    int response;
                    chooser.setDialogTitle("Select the output file for the building spreadsheet");
                    rtrnVal = chooser.showSaveDialog(null);
                    if (rtrnVal != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (!file.getPath().endsWith(".csv")) {
                        file = new File(file.getPath() + ".csv");
                    }
                    if (file.exists() && (response = JOptionPane.showOptionDialog(null, "File already exists.  Overwrite?", "Existing File", 0, 3, null, null, null)) != 0) {
                        return;
                    }
                    try {
                        writer = new CSVWriter(new BufferedOutputStream(new FileOutputStream(file)));
                        for (int i3 = 0; i3 < 20; ++i3) {
                            if (CSVPanel.this.buildingAttributes[i3].equals("Building Name") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Building Name");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Type of Building") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Type of Building");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Cost") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Cost");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Maintenance") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Maintenance");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Pollution") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Pollution");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Culture") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Culture");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Production Bonus") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Production Bonus");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Autoproduces") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Autoproduces");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Era") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Era");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Required Technology") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Required Technology");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Required Resources") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Required Resources");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Required Government") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Required Government");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Required Building") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Required Building");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Happiness Bonus (city)") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Happiness Bonus (city)");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Happiness Bonus (empire)") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Happiness Bonus (empire)");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Unhappiness (city)") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Unhappiness (city)");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Unhappiness (empire)") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Unhappiness (empire)");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Air Attack") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Air Attack");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Defence Bonus") && CSVPanel.this.buildingChecks[i3].isSelected()) {
                                writer.write("Defence Bonus");
                                continue;
                            }
                            if (CSVPanel.this.buildingAttributes[i3].equals("Available To") && !CSVPanel.this.buildingChecks[i3].isSelected()) continue;
                        }
                        writer.endRecord();
                        for (int n = 0; n < CSVPanel.this.biqFile.buildings.size(); ++n) {
                            for (i = 0; i < 20; ++i) {
                                BLDG building = CSVPanel.this.biqFile.buildings.get(n);
                                if (CSVPanel.this.buildingAttributes[i].equals("Building Name") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.write(building.getName());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Type of Building") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    if (building.isWonder()) {
                                        writer.write("Wonder");
                                        continue;
                                    }
                                    if (building.isSmallWonder()) {
                                        writer.write("Small wonder");
                                        continue;
                                    }
                                    writer.write("Improvement");
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Cost") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getCost());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Maintenance") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getMaintenanceCost());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Pollution") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getPollution());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Culture") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getCulture());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Production Bonus") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getProduction() * 25);
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Autoproduces") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    if (building.getUnitProduced() == -1) {
                                        writer.write(CSVPanel.NONE);
                                        continue;
                                    }
                                    writer.write(CSVPanel.this.biqFile.unit.get(building.getUnitProduced()).getName());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Era") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    int era = -1;
                                    era = building.getReqAdvance() == -1 ? 0 : CSVPanel.this.biqFile.technology.get(building.getReqAdvance()).getEra();
                                    if (era == -1) {
                                        era = 0;
                                    }
                                    writer.write(CSVPanel.this.biqFile.eras.get(era).getName());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Required Technology") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    if (building.getReqAdvance() == -1) {
                                        writer.write(CSVPanel.NONE);
                                        continue;
                                    }
                                    writer.write(CSVPanel.this.biqFile.technology.get(building.getReqAdvance()).getName());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Required Resources") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    if (building.getReqResource1() == -1 && building.getReqResource2() == -1) {
                                        writer.write(CSVPanel.NONE);
                                        continue;
                                    }
                                    if (building.getReqResource2() == -1) {
                                        writer.write(CSVPanel.this.biqFile.resource.get(building.getReqResource1()).getName());
                                        continue;
                                    }
                                    if (building.getReqResource1() == -1) {
                                        writer.write(CSVPanel.this.biqFile.resource.get(building.getReqResource2()).getName());
                                        continue;
                                    }
                                    String s = "";
                                    s = CSVPanel.this.biqFile.resource.get(building.getReqResource1()).getName().charAt(0) < CSVPanel.this.biqFile.resource.get(building.getReqResource2()).getName().charAt(0) ? CSVPanel.this.biqFile.resource.get(building.getReqResource1()).getName() + " and " + CSVPanel.this.biqFile.resource.get(building.getReqResource2()).getName() : CSVPanel.this.biqFile.resource.get(building.getReqResource2()).getName() + " and " + CSVPanel.this.biqFile.resource.get(building.getReqResource1()).getName();
                                    writer.write(s);
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Required Government") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    if (building.getReqGovernment() == -1) {
                                        writer.write(CSVPanel.NONE);
                                        continue;
                                    }
                                    writer.write(CSVPanel.this.biqFile.government.get((int)building.getReqGovernment()).name);
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Required Building") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    if (building.getReqImprovement() == -1) {
                                        writer.write(CSVPanel.NONE);
                                        continue;
                                    }
                                    writer.write(CSVPanel.this.biqFile.buildings.get(building.getReqImprovement()).getName());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Happiness Bonus (city)") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getHappy());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Happiness Bonus (empire)") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getHappyAll());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Unhappiness (city)") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getUnhappy());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Unhappiness (empire)") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getUnhappyAll());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Air Attack") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getAirPower());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Defence Bonus") && CSVPanel.this.buildingChecks[i].isSelected()) {
                                    writer.writeInteger(building.getDefenceBonus());
                                    continue;
                                }
                                if (CSVPanel.this.buildingAttributes[i].equals("Available To") && !CSVPanel.this.buildingChecks[i].isSelected()) continue;
                            }
                            writer.endRecord();
                        }
                        try {
                            writer.close();
                        }
                        catch (IOException f) {
                            System.err.println("Unable to close file");
                            errorOnStage = 2;
                            JOptionPane.showMessageDialog(null, "Failed to export file for buildings");
                        }
                    }
                    catch (FileNotFoundException f) {
                        System.err.println(f);
                        errorOnStage = 2;
                        JOptionPane.showMessageDialog(null, "Failed to export file for buildings");
                    }
                    catch (Exception g) {
                        System.err.println(g);
                        g.printStackTrace();
                        errorOnStage = 2;
                        JOptionPane.showMessageDialog(null, "Failed to export file for buildings");
                    }
                }
                if (CSVPanel.this.chkIncludeTechnologies.isSelected()) {
                    int response;
                    chooser.setDialogTitle("Select the output file for the technology spreadsheet");
                    rtrnVal = chooser.showSaveDialog(null);
                    if (rtrnVal != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (!file.getPath().endsWith(".csv")) {
                        file = new File(file.getPath() + ".csv");
                    }
                    if (file.exists() && (response = JOptionPane.showOptionDialog(null, "File already exists.  Overwrite?", "Existing File", 0, 3, null, null, null)) != 0) {
                        return;
                    }
                    try {
                        writer = new CSVWriter(new BufferedOutputStream(new FileOutputStream(file)));
                        for (int i4 = 0; i4 < 7; ++i4) {
                            if (CSVPanel.this.techAttributes[i4].equals("Tech Name") && CSVPanel.this.techChecks[i4].isSelected()) {
                                writer.write(CSVPanel.this.techAttributes[i4]);
                                continue;
                            }
                            if (CSVPanel.this.techAttributes[i4].equals("Era") && CSVPanel.this.techChecks[i4].isSelected()) {
                                writer.write(CSVPanel.this.techAttributes[i4]);
                                continue;
                            }
                            if (CSVPanel.this.techAttributes[i4].equals("Prerequisites") && CSVPanel.this.techChecks[i4].isSelected()) {
                                writer.write(CSVPanel.this.techAttributes[i4]);
                                continue;
                            }
                            if (CSVPanel.this.techAttributes[i4].equals("Cost") && CSVPanel.this.techChecks[i4].isSelected()) {
                                writer.write(CSVPanel.this.techAttributes[i4]);
                                continue;
                            }
                            if (CSVPanel.this.techAttributes[i4].equals("X position") && CSVPanel.this.techChecks[i4].isSelected()) {
                                writer.write(CSVPanel.this.techAttributes[i4]);
                                continue;
                            }
                            if (!CSVPanel.this.techAttributes[i4].equals("Y position") || !CSVPanel.this.techChecks[i4].isSelected()) continue;
                            writer.write(CSVPanel.this.techAttributes[i4]);
                        }
                        writer.endRecord();
                        for (int n = 0; n < CSVPanel.this.biqFile.technology.size(); ++n) {
                            for (i = 0; i < 7; ++i) {
                                TECH tech = CSVPanel.this.biqFile.technology.get(n);
                                if (CSVPanel.this.techAttributes[i].equals("Tech Name") && CSVPanel.this.techChecks[i].isSelected()) {
                                    writer.write(tech.getName());
                                    continue;
                                }
                                if (CSVPanel.this.techAttributes[i].equals("Era") && CSVPanel.this.techChecks[i].isSelected()) {
                                    writer.write(CSVPanel.this.biqFile.eras.get(tech.getEra()).getName());
                                    continue;
                                }
                                if (CSVPanel.this.techAttributes[i].equals("Prerequisites") && CSVPanel.this.techChecks[i].isSelected()) {
                                    String s = "";
                                    if (tech.getPrerequisite1() == -1) {
                                        writer.write(CSVPanel.NONE);
                                        continue;
                                    }
                                    s = s + CSVPanel.this.biqFile.technology.get(tech.getPrerequisite1()).getName();
                                    if (tech.getPrerequisite2() == -1) {
                                        writer.write(s);
                                        continue;
                                    }
                                    s = s + " and " + CSVPanel.this.biqFile.technology.get(tech.getPrerequisite2()).getName();
                                    if (tech.getPrerequisite3() == -1) {
                                        writer.write(s);
                                        continue;
                                    }
                                    s = s + " and " + CSVPanel.this.biqFile.technology.get(tech.getPrerequisite3()).getName();
                                    if (tech.getPrerequisite4() == -1) {
                                        writer.write(s);
                                        continue;
                                    }
                                    s = s + " and " + CSVPanel.this.biqFile.technology.get(tech.getPrerequisite4()).getName();
                                    writer.write(s);
                                    continue;
                                }
                                if (CSVPanel.this.techAttributes[i].equals("Cost") && CSVPanel.this.techChecks[i].isSelected()) {
                                    writer.writeInteger(tech.getCost());
                                    continue;
                                }
                                if (CSVPanel.this.techAttributes[i].equals("X position") && CSVPanel.this.techChecks[i].isSelected()) {
                                    writer.writeInteger(tech.getX());
                                    continue;
                                }
                                if (!CSVPanel.this.techAttributes[i].equals("Y position") || !CSVPanel.this.techChecks[i].isSelected()) continue;
                                writer.writeInteger(tech.getY());
                            }
                            writer.endRecord();
                        }
                        try {
                            writer.close();
                        }
                        catch (IOException f) {
                            System.err.println("Unable to close file");
                            errorOnStage = 3;
                            JOptionPane.showMessageDialog(null, "Failed to export file for technologies");
                        }
                    }
                    catch (FileNotFoundException f) {
                        System.err.println(f);
                        errorOnStage = 3;
                        JOptionPane.showMessageDialog(null, "Failed to export file for technologies");
                    }
                    catch (Exception g) {
                        System.err.println(g);
                        g.printStackTrace();
                        errorOnStage = 3;
                        JOptionPane.showMessageDialog(null, "Failed to export file for technologies");
                    }
                }
                if (CSVPanel.this.chkIncludeResources.isSelected()) {
                    int response;
                    chooser.setDialogTitle("Select the output file for the resource spreadsheet");
                    rtrnVal = chooser.showSaveDialog(null);
                    if (rtrnVal != 0) {
                        return;
                    }
                    file = chooser.getSelectedFile();
                    if (!file.getPath().endsWith(".csv")) {
                        file = new File(file.getPath() + ".csv");
                    }
                    if (file.exists() && (response = JOptionPane.showOptionDialog(null, "File already exists.  Overwrite?", "Existing File", 0, 3, null, null, null)) != 0) {
                        return;
                    }
                    try {
                        CSVWriter writer2 = new CSVWriter(new BufferedOutputStream(new FileOutputStream(file)));
                        for (int i5 = 0; i5 < 6; ++i5) {
                            if (CSVPanel.this.resourceAttributes[i5].equals("Resource Name") && CSVPanel.this.resourceChecks[i5].isSelected()) {
                                writer2.write(CSVPanel.this.resourceAttributes[i5]);
                                continue;
                            }
                            if (CSVPanel.this.resourceAttributes[i5].equals("Type of resource") && CSVPanel.this.resourceChecks[i5].isSelected()) {
                                writer2.write(CSVPanel.this.resourceAttributes[i5]);
                                continue;
                            }
                            if (CSVPanel.this.resourceAttributes[i5].equals("Food bonus") && CSVPanel.this.resourceChecks[i5].isSelected()) {
                                writer2.write(CSVPanel.this.resourceAttributes[i5]);
                                continue;
                            }
                            if (CSVPanel.this.resourceAttributes[i5].equals("Shield bonus") && CSVPanel.this.resourceChecks[i5].isSelected()) {
                                writer2.write(CSVPanel.this.resourceAttributes[i5]);
                                continue;
                            }
                            if (CSVPanel.this.resourceAttributes[i5].equals("Commerce bonus") && CSVPanel.this.resourceChecks[i5].isSelected()) {
                                writer2.write(CSVPanel.this.resourceAttributes[i5]);
                                continue;
                            }
                            if (!CSVPanel.this.resourceAttributes[i5].equals("Prerequisites") || !CSVPanel.this.resourceChecks[i5].isSelected()) continue;
                            writer2.write(CSVPanel.this.resourceAttributes[i5]);
                        }
                        writer2.endRecord();
                        for (int n = 0; n < CSVPanel.this.biqFile.resource.size(); ++n) {
                            for (i = 0; i < 6; ++i) {
                                GOOD good = CSVPanel.this.biqFile.resource.get(n);
                                if (CSVPanel.this.resourceAttributes[i].equals("Resource Name") && CSVPanel.this.resourceChecks[i].isSelected()) {
                                    writer2.write(good.getName());
                                    continue;
                                }
                                if (CSVPanel.this.resourceAttributes[i].equals("Type of resource") && CSVPanel.this.resourceChecks[i].isSelected()) {
                                    if (good.getType() == 2) {
                                        writer2.write("Strategic");
                                        continue;
                                    }
                                    if (good.getType() == 1) {
                                        writer2.write("Luxury");
                                        continue;
                                    }
                                    writer2.write("Bonus");
                                    continue;
                                }
                                if (CSVPanel.this.resourceAttributes[i].equals("Food bonus") && CSVPanel.this.resourceChecks[i].isSelected()) {
                                    writer2.writeInteger(good.getFoodBonus());
                                    continue;
                                }
                                if (CSVPanel.this.resourceAttributes[i].equals("Shield bonus") && CSVPanel.this.resourceChecks[i].isSelected()) {
                                    writer2.writeInteger(good.getShieldsBonus());
                                    continue;
                                }
                                if (CSVPanel.this.resourceAttributes[i].equals("Commerce bonus") && CSVPanel.this.resourceChecks[i].isSelected()) {
                                    writer2.writeInteger(good.getCommerceBonus());
                                    continue;
                                }
                                if (!CSVPanel.this.resourceAttributes[i].equals("Prerequisites") || !CSVPanel.this.resourceChecks[i].isSelected()) continue;
                                if (good.getPrerequisite() == -1) {
                                    writer2.write(CSVPanel.NONE);
                                    continue;
                                }
                                writer2.write(CSVPanel.this.biqFile.technology.get(good.getPrerequisite()).getName());
                            }
                            writer2.endRecord();
                        }
                        try {
                            writer2.close();
                        }
                        catch (IOException f) {
                            CSVPanel.this.logger.error("Unable to close file", f);
                            errorOnStage = 4;
                            JOptionPane.showMessageDialog(null, "Failed to export file for resources");
                        }
                    }
                    catch (FileNotFoundException f) {
                        CSVPanel.this.logger.error("File not found exception", f);
                        errorOnStage = 4;
                        JOptionPane.showMessageDialog(null, "Failed to export file for resources");
                    }
                    catch (Exception g) {
                        CSVPanel.this.logger.error("Failed to expert file for resources", g);
                        errorOnStage = 4;
                        JOptionPane.showMessageDialog(null, "Failed to export file for resources");
                    }
                }
                if (errorOnStage == 0) {
                    JOptionPane.showMessageDialog(null, "Successfully exported all CSV files");
                }
            }
        });
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        this.getContentPane().add((Component)this.btnExport, c);
        ++c.gridy;
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVPanel.this.thisFrame.setVisible(false);
            }
        });
        this.getContentPane().add((Component)this.btnCancel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        this.chkIncludeUnits.setText("Include Units");
        this.chkIncludeUnits.setSelected(true);
        this.getContentPane().add((Component)this.chkIncludeUnits, c);
        ++c.gridx;
        this.chkIncludeBuildings.setText("Include Buildings");
        this.chkIncludeBuildings.setSelected(true);
        this.getContentPane().add((Component)this.chkIncludeBuildings, c);
        ++c.gridx;
        this.chkIncludeTechnologies.setText("Include Technologies");
        this.chkIncludeTechnologies.setSelected(true);
        this.getContentPane().add((Component)this.chkIncludeTechnologies, c);
        ++c.gridx;
        this.chkIncludeResources.setText("Include Resources");
        this.chkIncludeResources.setSelected(true);
        this.getContentPane().add((Component)this.chkIncludeResources, c);
        this.pack();
    }

    private void handleSpinnerEvent(ChangeEvent evt, int MAX, JSpinner[] spinners, JCheckBox[] checkBoxes, int[] spinnerValues, String[] attributes) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got spinner event");
        }
        JSpinner source = (JSpinner)evt.getSource();
        int sourceSpinnerID = -1;
        for (int i = 0; i < MAX; ++i) {
            if (spinners[i] != source) continue;
            sourceSpinnerID = i;
            break;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Source spinner ID: " + sourceSpinnerID);
        }
        if ((Integer)spinners[sourceSpinnerID].getValue() > spinnerValues[sourceSpinnerID]) {
            spinnerValues[sourceSpinnerID] = (Integer)spinners[sourceSpinnerID].getValue();
            if (sourceSpinnerID > 0) {
                String temp = attributes[sourceSpinnerID - 1];
                boolean checked = checkBoxes[sourceSpinnerID - 1].isSelected();
                checkBoxes[sourceSpinnerID - 1].setSelected(checkBoxes[sourceSpinnerID].isSelected());
                checkBoxes[sourceSpinnerID].setSelected(checked);
                attributes[sourceSpinnerID - 1] = attributes[sourceSpinnerID];
                attributes[sourceSpinnerID] = temp;
                checkBoxes[sourceSpinnerID - 1].setText(attributes[sourceSpinnerID - 1]);
                checkBoxes[sourceSpinnerID].setText(attributes[sourceSpinnerID]);
            }
        } else {
            spinnerValues[sourceSpinnerID] = (Integer)spinners[sourceSpinnerID].getValue();
            if (sourceSpinnerID < MAX - 1) {
                String temp = attributes[sourceSpinnerID + 1];
                boolean checked = checkBoxes[sourceSpinnerID + 1].isSelected();
                checkBoxes[sourceSpinnerID + 1].setSelected(checkBoxes[sourceSpinnerID].isSelected());
                checkBoxes[sourceSpinnerID].setSelected(checked);
                attributes[sourceSpinnerID + 1] = attributes[sourceSpinnerID];
                attributes[sourceSpinnerID] = temp;
                checkBoxes[sourceSpinnerID + 1].setText(attributes[sourceSpinnerID + 1]);
                checkBoxes[sourceSpinnerID].setText(attributes[sourceSpinnerID]);
            }
        }
        int newVal = (Integer)((JSpinner)evt.getSource()).getValue();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CSVPanel().setVisible(true);
            }
        });
    }
}

