/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.specialty;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CSVWriter
extends DataOutputStream {
    boolean atBeginningOfLine = true;

    public CSVWriter(OutputStream out) {
        super(out);
    }

    public void write(String string) {
        try {
            if (!this.atBeginningOfLine) {
                this.writeBytes(",");
            }
            this.writeBytes(string);
            this.atBeginningOfLine = false;
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public void writeInteger(Integer number) {
        this.write(Integer.toString(number));
    }

    public void writeShort(Short number) {
        this.write(Short.toString(number));
    }

    public void writeByte(Byte number) {
        this.write(Byte.toString(number));
    }

    public void writeLong(Long number) {
        this.write(Long.toString(number));
    }

    public void writeBool(Boolean number) {
        this.write(Boolean.toString(number));
    }

    public void write(Object o) {
        if (o instanceof String) {
            this.write((String)o);
        } else if (o instanceof Integer) {
            this.write((Integer)o);
        } else if (o instanceof Short) {
            this.write((Short)o);
        } else if (o instanceof Byte) {
            this.write((Byte)o);
        } else if (o instanceof Boolean) {
            this.write((Boolean)o);
        } else {
            throw new UnsupportedOperationException("Cannot write that type");
        }
    }

    public void endRecord() {
        try {
            this.writeBytes("\r\n");
            this.atBeginningOfLine = true;
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }
}

