/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.specialty;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.xplatformeditor.specialty.PredicateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;

public class PredicateCommonFunctions {
    public static List<String> tokenize(String filterText) {
        ArrayList<String> completedTokens = new ArrayList<String>();
        String[] quoteTokens = filterText.split("\"| ");
        String tokenBeingConstructed = "";
        boolean appendLoopToken = false;
        for (String loopToken : quoteTokens) {
            if (PredicateFactory.logger.isTraceEnabled()) {
                PredicateFactory.logger.trace("Loop Token: " + loopToken);
            }
            if (appendLoopToken) {
                if (loopToken.length() > 0) {
                    tokenBeingConstructed = tokenBeingConstructed + loopToken + " ";
                    continue;
                }
                completedTokens.add(tokenBeingConstructed.trim());
                tokenBeingConstructed = "";
                appendLoopToken = false;
                continue;
            }
            if (loopToken.endsWith(">") || loopToken.endsWith("<") || loopToken.endsWith("=")) {
                appendLoopToken = true;
                tokenBeingConstructed = loopToken;
                continue;
            }
            completedTokens.add(loopToken);
        }
        if (!tokenBeingConstructed.equals("")) {
            completedTokens.add(tokenBeingConstructed.trim());
        }
        LinkedList<String> parenTokens = new LinkedList<String>();
        for (String token : completedTokens) {
            while (token.startsWith("(")) {
                parenTokens.add("(");
                token = token.substring(1);
            }
            if (token.endsWith(")")) {
                parenTokens.add(token.substring(0, token.indexOf(")")));
            } else {
                parenTokens.add(token);
            }
            while (token.endsWith(")")) {
                parenTokens.add(")");
                token = token.substring(0, token.length() - 1);
            }
        }
        completedTokens = parenTokens;
        if (PredicateFactory.logger.isTraceEnabled()) {
            PredicateFactory.logger.trace("Completed Tokens: " + completedTokens.size());
            for (String s : completedTokens) {
                PredicateFactory.logger.trace(s);
            }
        }
        return completedTokens;
    }

    static boolean evaluatePredicates(BIQSection tech, List<BiPredicate> thePredicates, List<String> validatedTokens) {
        Iterator<String> tokenIterator = validatedTokens.iterator();
        int tokenIndex = 0;
        LinkedList<BiPredicate> predicatesAfterParens = new LinkedList<BiPredicate>();
        LinkedList<String> tokensAfterParens = new LinkedList<String>();
        int indexOfOpeningParen = -1;
        int predicateIndexOfOpeningParen = -1;
        int parenCount = 0;
        int predicateIndex = 0;
        List<String> tokensThatDontHavePredicates = Arrays.asList("(", ")", "or");
        while (tokenIterator.hasNext()) {
            String nextToken = tokenIterator.next();
            if (tokensThatDontHavePredicates.contains(nextToken)) {
                --predicateIndex;
            }
            if (nextToken.equals("(")) {
                if (indexOfOpeningParen == -1) {
                    indexOfOpeningParen = tokenIndex;
                    predicateIndexOfOpeningParen = predicateIndex;
                }
                ++parenCount;
            } else if (nextToken.equals(")")) {
                if (indexOfOpeningParen == -1) {
                    return false;
                }
                if (--parenCount == 0) {
                    boolean isParenExpressionTrue = PredicateCommonFunctions.evaluatePredicates(tech, thePredicates.subList(predicateIndexOfOpeningParen + 1, predicateIndex + 1), validatedTokens.subList(indexOfOpeningParen + 1, tokenIndex));
                    predicatesAfterParens.add((t, s) -> isParenExpressionTrue);
                    tokensAfterParens.add("alreadyEvaluated");
                    indexOfOpeningParen = -1;
                }
            } else if (indexOfOpeningParen == -1) {
                if (!nextToken.equals("or")) {
                    predicatesAfterParens.add(thePredicates.get(predicateIndex));
                }
                tokensAfterParens.add(nextToken);
            }
            ++tokenIndex;
            ++predicateIndex;
        }
        thePredicates = null;
        validatedTokens = null;
        tokenIterator = tokensAfterParens.iterator();
        tokenIndex = 0;
        while (tokenIterator.hasNext()) {
            if (tokenIterator.next().equals("or")) {
                List<String> tokensA = tokensAfterParens.subList(0, tokenIndex);
                List<String> tokensB = tokensAfterParens.subList(tokenIndex + 1, tokensAfterParens.size());
                List<BiPredicate> predicatesA = predicatesAfterParens.subList(0, tokenIndex);
                List<BiPredicate> predicatesB = predicatesAfterParens.subList(tokenIndex, predicatesAfterParens.size());
                boolean resultA = PredicateCommonFunctions.evaluatePredicates(tech, predicatesA, tokensA);
                boolean resultB = PredicateCommonFunctions.evaluatePredicates(tech, predicatesB, tokensB);
                return resultA || resultB;
            }
            ++tokenIndex;
        }
        tokenIterator = tokensAfterParens.iterator();
        if (!tokenIterator.hasNext()) {
            return true;
        }
        for (BiPredicate listPredicate : predicatesAfterParens) {
            String predicateQuery;
            if (listPredicate.test(tech, predicateQuery = tokenIterator.next())) continue;
            return false;
        }
        return true;
    }
}

