/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.specialty;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.BLDG;
import com.civfanatics.civ3.biqFile.ERAS;
import com.civfanatics.civ3.biqFile.FLAV;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.GOVT;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.RACE;
import com.civfanatics.civ3.biqFile.TECH;
import com.civfanatics.civ3.biqFile.TERR;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.specialty.PredicateCommonFunctions;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import org.apache.log4j.Logger;

public class PredicateFactory {
    static Logger logger = Logger.getLogger(PredicateFactory.class);
    static List<String> eqLtGt = Arrays.asList("=", ">", "<");
    static BiPredicate<BLDG, String> reqBuilding = (bldg, buildingName) -> {
        buildingName = buildingName.substring(1);
        if (bldg.getReqImprovement() == -1) {
            return buildingName.equalsIgnoreCase("None");
        }
        BLDG theBuilding = Main.getCurrentBIQ().buildings.get(bldg.getReqImprovement());
        return theBuilding.getName().equalsIgnoreCase((String)buildingName);
    };
    @Deprecated
    static BiPredicate<BLDG, String> reqBuildingInefficient = (bldg, buildingName) -> {
        if ((buildingName = buildingName.substring(1)).equalsIgnoreCase("None")) {
            return bldg.getReqImprovement() == -1;
        }
        int b = 0;
        for (BLDG building : Main.getCurrentBIQ().buildings) {
            if (building.getName().equalsIgnoreCase((String)buildingName)) {
                return bldg.getGainInEveryCity() == b;
            }
            ++b;
        }
        return false;
    };

    public static BiPredicate<BLDG, String> createBLDGFilter() {
        BiPredicate<BLDG, String> nameContainsQuery = (bldg, query) -> bldg.getName().toLowerCase().contains(query.toLowerCase());
        BiPredicate<BLDG, String> cost = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getCost(), query);
        BiPredicate<BLDG, String> maintenance = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getMaintenanceCost(), query);
        BiPredicate<BLDG, String> culture = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getCulture(), query);
        BiPredicate<BLDG, String> productionBonus = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getProduction(), query);
        BiPredicate<BLDG, String> pollution = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getPollution(), query);
        BiPredicate<BLDG, String> bldgType = (bldg, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            if ((query = query.substring(1)).equalsIgnoreCase("Wonder")) {
                return bldg.isWonder();
            }
            if (query.equalsIgnoreCase("Small Wonder")) {
                return bldg.isSmallWonder();
            }
            if (query.equalsIgnoreCase("Improvement")) {
                return !bldg.isWonder() && !bldg.isSmallWonder();
            }
            return false;
        };
        BiPredicate<BLDG, String> landBombard = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getBombardDefence(), query);
        BiPredicate<BLDG, String> navalBombard = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getNavalBombardDefence(), query);
        BiPredicate<BLDG, String> airAttack = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getAirPower(), query);
        BiPredicate<BLDG, String> seaAttack = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getNavalPower(), query);
        BiPredicate<BLDG, String> defenceBonus = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getDefenceBonus(), query);
        BiPredicate<BLDG, String> navalDefence = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getNavalDefenceBonus(), query);
        BiPredicate<BLDG, String> veteranLand = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getVeteranUnits(), query);
        BiPredicate<BLDG, String> veteranSea = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getVeteranSeaUnits(), query);
        BiPredicate<BLDG, String> veteranAir = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getVeteranAirUnits(), query);
        BiPredicate<BLDG, String> stealthBarrier = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getStealthAttackBarrier(), query);
        BiPredicate<BLDG, String> nukes = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowsNuclearWeapons(), query);
        BiPredicate<BLDG, String> icbmDefence = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getDecreasesSuccessOfMissiles(), query);
        BiPredicate<BLDG, String> doubleVsBarbs = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getDoubleCombatVsBarbarians(), query);
        BiPredicate<BLDG, String> armiesWithoutLeader = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getBuildArmiesWithoutLeader(), query);
        BiPredicate<BLDG, String> largerArmies = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getBuildLargerArmies(), query);
        BiPredicate<BLDG, String> moreLeaders = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasesChanceOfLeaderAppearance(), query);
        BiPredicate<BLDG, String> safeAtSea = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getSafeSeaTravel(), query);
        BiPredicate<BLDG, String> plusOneSea = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasedShipMovement(), query);
        BiPredicate<BLDG, String> plusTwoSea = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getPlusTwoShipMovement(), query);
        BiPredicate<BLDG, String> halfCostUpgrades = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getCheaperUpgrades(), query);
        BiPredicate<BLDG, String> healInEnemyTerritory = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowsHealingInEnemyTerritory(), query);
        BiPredicate<BLDG, String> strongerArmies = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasedArmyValue(), query);
        BiPredicate<BLDG, String> doubleDefences = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getDoubleCityDefences(), query);
        BiPredicate<BLDG, String> extraFoodInWater = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasesFoodInWater(), query);
        BiPredicate<BLDG, String> storeHalfOfFood = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getDoublesCityGrowthRate(), query);
        BiPredicate<BLDG, String> gainTwoPop = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getDoubleCityGrowth(), query);
        BiPredicate<BLDG, String> allowCitySize2 = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowCityLevel2(), query);
        BiPredicate<BLDG, String> allowCitySize3 = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowCityLevel3(), query);
        BiPredicate<BLDG, String> plus50Science = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasedResearch(), query);
        BiPredicate<BLDG, String> plus100Science = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getDoublesResearchOutput(), query);
        BiPredicate<BLDG, String> twoFreeAdvances = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getTwoFreeAdvances(), query);
        BiPredicate<BLDG, String> gainKnownTechs = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getGainAnyTechsKnownByTwoCivs(), query);
        BiPredicate<BLDG, String> gainInEveryCity = (bldg, buildingName) -> {
            if ((buildingName = buildingName.substring(1)).equalsIgnoreCase("None")) {
                return bldg.getGainInEveryCity() == -1;
            }
            int b = 0;
            for (BLDG building : Main.getCurrentBIQ().buildings) {
                if (building.getName().equalsIgnoreCase((String)buildingName)) {
                    return bldg.getGainInEveryCity() == b;
                }
                ++b;
            }
            return false;
        };
        BiPredicate<BLDG, String> gainInContinentCity = (bldg, buildingName) -> {
            if ((buildingName = buildingName.substring(1)).equalsIgnoreCase("None")) {
                return bldg.getGainOnContinent() == -1;
            }
            int b = 0;
            for (BLDG building : Main.getCurrentBIQ().buildings) {
                if (building.getName().equalsIgnoreCase((String)buildingName)) {
                    return bldg.getGainOnContinent() == b;
                }
                ++b;
            }
            return false;
        };
        BiPredicate<BLDG, String> gainUnit = (bldg, unitName) -> {
            if ((unitName = unitName.substring(1)).equalsIgnoreCase("None")) {
                return bldg.getUnitProduced() == -1;
            }
            int u = 0;
            for (PRTO prto : Main.getCurrentBIQ().unit) {
                if (prto.getName().equalsIgnoreCase((String)unitName)) {
                    return bldg.getUnitProduced() == u;
                }
                ++u;
            }
            return false;
        };
        BiPredicate<BLDG, String> gainUnitFrequency = (bldg, frequency) -> PredicateFactory.evaluateIntegerQuery(bldg.getUnitFrequency(), frequency);
        BiPredicate<BLDG, String> madeObsoleteBy = (bldg, techName) -> {
            if ((techName = techName.substring(1)).equalsIgnoreCase("None")) {
                return bldg.getObsoleteBy() == -1;
            }
            int t = 0;
            for (TECH tech : Main.getCurrentBIQ().technology) {
                if (tech.getName().equalsIgnoreCase((String)techName)) {
                    return bldg.getObsoleteBy() == t;
                }
                ++t;
            }
            return false;
        };
        BiPredicate<BLDG, String> reqGovernment = (bldg, govtName) -> {
            govtName = govtName.substring(1);
            if (bldg.getReqGovernment() == -1) {
                return govtName.equalsIgnoreCase("None");
            }
            GOVT theGovt = Main.getCurrentBIQ().government.get(bldg.getReqGovernment());
            return theGovt.getName().equalsIgnoreCase((String)govtName);
        };
        BiPredicate<BLDG, String> reqTech = (bldg, techName) -> {
            techName = techName.substring(1);
            if (bldg.getReqAdvance() == -1) {
                return techName.equalsIgnoreCase("None");
            }
            TECH theTech = Main.getCurrentBIQ().technology.get(bldg.getReqAdvance());
            return theTech.getName().equalsIgnoreCase((String)techName);
        };
        BiPredicate<BLDG, String> reqGood = (bldg, goodName) -> {
            GOOD theGood;
            goodName = goodName.substring(1);
            if (bldg.getReqResource1() == -1 && bldg.getReqResource2() == -1) {
                return goodName.equalsIgnoreCase("None");
            }
            if (bldg.getReqResource1() != -1 && (theGood = Main.getCurrentBIQ().resource.get(bldg.getReqResource1())) != null && theGood.getName().equalsIgnoreCase((String)goodName)) {
                return true;
            }
            return bldg.getReqResource2() != -1 && (theGood = Main.getCurrentBIQ().resource.get(bldg.getReqResource2())) != null && theGood.getName().equalsIgnoreCase((String)goodName);
        };
        BiPredicate<BLDG, String> numReqBuildings = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getNumReqBuildings(), query);
        BiPredicate<BLDG, String> numArmies = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getArmiesRequired(), query);
        BiPredicate<BLDG, String> goodsInCityRadius = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getGoodsMustBeInCityRadius(), query);
        BiPredicate<BLDG, String> nearRiver = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getMustBeNearRiver(), query);
        BiPredicate<BLDG, String> victoriousArmy = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getRequiresVictoriousArmy(), query);
        BiPredicate<BLDG, String> coastal = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getCoastalInstallation(), query);
        BiPredicate<BLDG, String> byWater = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getMustBeNearWater(), query);
        BiPredicate<BLDG, String> eliteShip = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.requiresEliteShip(), query);
        BiPredicate<BLDG, String> airTrade = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowAirTrade(), query);
        BiPredicate<BLDG, String> waterTrade = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowWaterTrade(), query);
        BiPredicate<BLDG, String> capitalization = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getCapitalization(), query);
        BiPredicate<BLDG, String> plusFiftyTax = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasedTaxes(), query);
        BiPredicate<BLDG, String> increasedWaterTrade = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasesTradeInWater(), query);
        BiPredicate<BLDG, String> increasedTrade = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasedTrade(), query);
        BiPredicate<BLDG, String> paysTradeMaintenance = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getPaysTradeMaintenance(), query);
        BiPredicate<BLDG, String> earnsInterest = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getTreasuryEarnsInterest(), query);
        BiPredicate<BLDG, String> reducesCityCorruption = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getReducesCorruption(), query);
        BiPredicate<BLDG, String> reducesEmpireCorruption = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getForbiddenPalace(), query);
        BiPredicate<BLDG, String> continentalHappiness = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getContinentalMoodEffects(), query);
        BiPredicate<BLDG, String> happyCity = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getHappy(), query);
        BiPredicate<BLDG, String> happyGlobal = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getHappyAll(), query);
        BiPredicate<BLDG, String> unhappyCity = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getUnhappy(), query);
        BiPredicate<BLDG, String> unhappyGlobal = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getUnhappyAll(), query);
        BiPredicate<BLDG, String> plusFiftyLuxury = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasedLuxuries(), query);
        BiPredicate<BLDG, String> moreLuxTrade = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasesLuxuryTrade(), query);
        BiPredicate<BLDG, String> reducesWarWeariness = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getReducesWarWeariness(), query);
        BiPredicate<BLDG, String> reducesWarWearinessEmpire = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getReducesWarWearinessEmpire(), query);
        BiPredicate<BLDG, String> doublesHappiness = (bldg, bldgName) -> {
            bldgName = bldgName.substring(1);
            if (bldg.getDoublesHappiness() == -1) {
                return bldgName.equalsIgnoreCase("None");
            }
            BLDG theBLDG = Main.getCurrentBIQ().buildings.get(bldg.getDoublesHappiness());
            return theBLDG.getName().equalsIgnoreCase((String)bldgName);
        };
        BiPredicate<BLDG, String> centerOfEmpire = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getCenterOfEmpire(), query);
        BiPredicate<BLDG, String> noPopulationPollution = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getRemovePopPollution(), query);
        BiPredicate<BLDG, String> canMeltdown = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getMayExplodeOrMeltdown(), query);
        BiPredicate<BLDG, String> moreShieldsInWater = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getIncreasesShieldsInWater(), query);
        BiPredicate<BLDG, String> spaceshipPart = (bldg, query) -> PredicateFactory.evaluateIntegerQuery(bldg.getSpaceshipPart(), query);
        BiPredicate<BLDG, String> touristAttraction = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getTouristAttraction(), query);
        BiPredicate<BLDG, String> allowsDiplomaticVictory = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowDiplomaticVictory(), query);
        BiPredicate<BLDG, String> replacesOthersWithFlag = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getReplacesOtherWithThisTag(), query);
        BiPredicate<BLDG, String> doublesSacrifice = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getDoublesSacrifice(), query);
        BiPredicate<BLDG, String> propagandaResistance = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getResistantToBribery(), query);
        BiPredicate<BLDG, String> canBuildSpaceship = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getBuildSpaceshipParts(), query);
        BiPredicate<BLDG, String> allowsSpies = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAllowSpyMissions(), query);
        BiPredicate<BLDG, String> militaristic = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getMilitaryInstallation(), query);
        BiPredicate<BLDG, String> religious = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getPlaceOfWorship(), query);
        BiPredicate<BLDG, String> commercial = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getTradeInstallation(), query);
        BiPredicate<BLDG, String> industrial = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getConstructionInstallation(), query);
        BiPredicate<BLDG, String> expansionist = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getExplorationInstallation(), query);
        BiPredicate<BLDG, String> scientific = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getResearchInstallation(), query);
        BiPredicate<BLDG, String> agricultural = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getAgriculturalInstallation(), query);
        BiPredicate<BLDG, String> seafaring = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getSeafaringInstallation(), query);
        BiPredicate<BLDG, String> charmBarrier = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getCharmBarrier(), query);
        BiPredicate<BLDG, String> generalTelepad = (bldg, query) -> PredicateFactory.evaluateBooleanQuery(bldg.getActsAsGeneralTelepad(), query);
        BiPredicate<BLDG, String> flavor = (bldg, flavName) -> {
            if ((flavName = flavName.substring(1)).equalsIgnoreCase("None")) {
                for (int i = 0; i < bldg.getNumFlavors(); ++i) {
                    boolean flavPresent = bldg.getFlavour(i);
                    if (!flavPresent) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < bldg.getNumFlavors(); ++i) {
                String flavour;
                boolean flavPresent = bldg.getFlavour(i);
                if (!flavPresent || !(flavour = utils.cTrim(Main.getCurrentBIQ().flavor.get(i).getName())).equalsIgnoreCase((String)flavName)) continue;
                return true;
            }
            return false;
        };
        HashMap<String, BiPredicate<BLDG, String>> keyToPredicateMap = new HashMap<String, BiPredicate<BLDG, String>>();
        keyToPredicateMap.put("cost".toLowerCase(), cost);
        keyToPredicateMap.put("maintenance".toLowerCase(), maintenance);
        keyToPredicateMap.put("culture".toLowerCase(), culture);
        keyToPredicateMap.put("productionBonus".toLowerCase(), productionBonus);
        keyToPredicateMap.put("pollution".toLowerCase(), pollution);
        keyToPredicateMap.put("type".toLowerCase(), bldgType);
        keyToPredicateMap.put("landBombard".toLowerCase(), landBombard);
        keyToPredicateMap.put("seaBombard".toLowerCase(), navalBombard);
        keyToPredicateMap.put("airAttack".toLowerCase(), airAttack);
        keyToPredicateMap.put("seaAttack".toLowerCase(), seaAttack);
        keyToPredicateMap.put("defenceBonus".toLowerCase(), defenceBonus);
        keyToPredicateMap.put("navalDefence".toLowerCase(), navalDefence);
        keyToPredicateMap.put("defenseBonus".toLowerCase(), defenceBonus);
        keyToPredicateMap.put("navalDefense".toLowerCase(), navalDefence);
        keyToPredicateMap.put("veteranLand".toLowerCase(), veteranLand);
        keyToPredicateMap.put("veteranSea".toLowerCase(), veteranSea);
        keyToPredicateMap.put("veteranAir".toLowerCase(), veteranAir);
        keyToPredicateMap.put("stealthBarrier".toLowerCase(), stealthBarrier);
        keyToPredicateMap.put("allowsNukes".toLowerCase(), nukes);
        keyToPredicateMap.put("nukes".toLowerCase(), nukes);
        keyToPredicateMap.put("icbmDefence".toLowerCase(), icbmDefence);
        keyToPredicateMap.put("icbmDefense".toLowerCase(), icbmDefence);
        keyToPredicateMap.put("doubleVsBarbs".toLowerCase(), doubleVsBarbs);
        keyToPredicateMap.put("armiesWithoutLeader".toLowerCase(), armiesWithoutLeader);
        keyToPredicateMap.put("largerArmies".toLowerCase(), largerArmies);
        keyToPredicateMap.put("moreLeaders".toLowerCase(), moreLeaders);
        keyToPredicateMap.put("safeAtSea".toLowerCase(), safeAtSea);
        keyToPredicateMap.put("plusOneSea".toLowerCase(), plusOneSea);
        keyToPredicateMap.put("plusTwoSea".toLowerCase(), plusTwoSea);
        keyToPredicateMap.put("halfCostUpgrades".toLowerCase(), halfCostUpgrades);
        keyToPredicateMap.put("healInEnemyTerritory".toLowerCase(), healInEnemyTerritory);
        keyToPredicateMap.put("strongerArmies".toLowerCase(), strongerArmies);
        keyToPredicateMap.put("doubleDefences".toLowerCase(), doubleDefences);
        keyToPredicateMap.put("doubleDefenses".toLowerCase(), doubleDefences);
        keyToPredicateMap.put("extraFoodInWater".toLowerCase(), extraFoodInWater);
        keyToPredicateMap.put("storeHalfOfFood".toLowerCase(), storeHalfOfFood);
        keyToPredicateMap.put("gainTwoPop".toLowerCase(), gainTwoPop);
        keyToPredicateMap.put("allowCitySize2".toLowerCase(), allowCitySize2);
        keyToPredicateMap.put("allowCitySize3".toLowerCase(), allowCitySize3);
        keyToPredicateMap.put("plus50Science".toLowerCase(), plus50Science);
        keyToPredicateMap.put("plus100Science".toLowerCase(), plus100Science);
        keyToPredicateMap.put("twoFreeAdvances".toLowerCase(), twoFreeAdvances);
        keyToPredicateMap.put("gainKnownTechs".toLowerCase(), gainKnownTechs);
        keyToPredicateMap.put("gainInEveryCity".toLowerCase(), gainInEveryCity);
        keyToPredicateMap.put("gainInContinentCity".toLowerCase(), gainInContinentCity);
        keyToPredicateMap.put("gainUnit".toLowerCase(), gainUnit);
        keyToPredicateMap.put("gainUnitFrequency".toLowerCase(), gainUnitFrequency);
        keyToPredicateMap.put("madeObsoleteBy".toLowerCase(), madeObsoleteBy);
        keyToPredicateMap.put("reqBuilding".toLowerCase(), reqBuilding);
        keyToPredicateMap.put("reqTech".toLowerCase(), reqTech);
        keyToPredicateMap.put("reqGovernment".toLowerCase(), reqGovernment);
        keyToPredicateMap.put("reqGood".toLowerCase(), reqGood);
        keyToPredicateMap.put("numReqBuildings".toLowerCase(), numReqBuildings);
        keyToPredicateMap.put("numArmies".toLowerCase(), numArmies);
        keyToPredicateMap.put("goodsInCityRadius".toLowerCase(), goodsInCityRadius);
        keyToPredicateMap.put("nearRiver".toLowerCase(), nearRiver);
        keyToPredicateMap.put("victoriousArmy".toLowerCase(), victoriousArmy);
        keyToPredicateMap.put("coastal".toLowerCase(), coastal);
        keyToPredicateMap.put("byWater".toLowerCase(), byWater);
        keyToPredicateMap.put("eliteShip".toLowerCase(), eliteShip);
        keyToPredicateMap.put("airTrade".toLowerCase(), airTrade);
        keyToPredicateMap.put("waterTrade".toLowerCase(), waterTrade);
        keyToPredicateMap.put("capitalization".toLowerCase(), capitalization);
        keyToPredicateMap.put("plusFiftyTax".toLowerCase(), plusFiftyTax);
        keyToPredicateMap.put("increasedWaterTrade".toLowerCase(), increasedWaterTrade);
        keyToPredicateMap.put("increasedTrade".toLowerCase(), increasedTrade);
        keyToPredicateMap.put("paysTradeMaintenance".toLowerCase(), paysTradeMaintenance);
        keyToPredicateMap.put("earnsInterest".toLowerCase(), earnsInterest);
        keyToPredicateMap.put("reducesCityCorruption".toLowerCase(), reducesCityCorruption);
        keyToPredicateMap.put("reducesEmpireCorruption".toLowerCase(), reducesEmpireCorruption);
        keyToPredicateMap.put("continentalHappiness".toLowerCase(), continentalHappiness);
        keyToPredicateMap.put("happyCity".toLowerCase(), happyCity);
        keyToPredicateMap.put("happyGlobal".toLowerCase(), happyGlobal);
        keyToPredicateMap.put("unhappyCity".toLowerCase(), unhappyCity);
        keyToPredicateMap.put("unhappyGlobal".toLowerCase(), unhappyGlobal);
        keyToPredicateMap.put("plusFiftyLuxury".toLowerCase(), plusFiftyLuxury);
        keyToPredicateMap.put("moreLuxTrade".toLowerCase(), moreLuxTrade);
        keyToPredicateMap.put("reducesWarWeariness".toLowerCase(), reducesWarWeariness);
        keyToPredicateMap.put("reducesWarWearinessEmpire".toLowerCase(), reducesWarWearinessEmpire);
        keyToPredicateMap.put("doublesHappiness".toLowerCase(), doublesHappiness);
        keyToPredicateMap.put("centerOfEmpire".toLowerCase(), centerOfEmpire);
        keyToPredicateMap.put("noPopulationPollution".toLowerCase(), noPopulationPollution);
        keyToPredicateMap.put("canMeltdown".toLowerCase(), canMeltdown);
        keyToPredicateMap.put("moreShieldsInWater".toLowerCase(), moreShieldsInWater);
        keyToPredicateMap.put("spaceshipPart".toLowerCase(), spaceshipPart);
        keyToPredicateMap.put("touristAttraction".toLowerCase(), touristAttraction);
        keyToPredicateMap.put("allowsDiplomaticVictory".toLowerCase(), allowsDiplomaticVictory);
        keyToPredicateMap.put("replacesOthersWithFlag".toLowerCase(), replacesOthersWithFlag);
        keyToPredicateMap.put("doublesSacrifice".toLowerCase(), doublesSacrifice);
        keyToPredicateMap.put("propagandaResistance".toLowerCase(), propagandaResistance);
        keyToPredicateMap.put("canBuildSpaceship".toLowerCase(), canBuildSpaceship);
        keyToPredicateMap.put("allowsSpies".toLowerCase(), allowsSpies);
        keyToPredicateMap.put("militaristic".toLowerCase(), militaristic);
        keyToPredicateMap.put("religious".toLowerCase(), religious);
        keyToPredicateMap.put("commercial".toLowerCase(), commercial);
        keyToPredicateMap.put("industrial".toLowerCase(), industrial);
        keyToPredicateMap.put("expansionist".toLowerCase(), expansionist);
        keyToPredicateMap.put("scientific".toLowerCase(), scientific);
        keyToPredicateMap.put("agricultural".toLowerCase(), agricultural);
        keyToPredicateMap.put("seafaring".toLowerCase(), seafaring);
        keyToPredicateMap.put("charmBarrier".toLowerCase(), charmBarrier);
        keyToPredicateMap.put("generalTelepad".toLowerCase(), generalTelepad);
        keyToPredicateMap.put("flavor".toLowerCase(), flavor);
        keyToPredicateMap.put("flavour".toLowerCase(), flavor);
        HashMap<String, BiPredicate> genericPredicateMap = new HashMap<String, BiPredicate>();
        for (Map.Entry e : keyToPredicateMap.entrySet()) {
            genericPredicateMap.put((String)e.getKey(), (BiPredicate)e.getValue());
        }
        return PredicateFactory.constructSectionBiPredicate(genericPredicateMap, nameContainsQuery);
    }

    public static BiPredicate<PRTO, String> createPRTOFilter() {
        BiPredicate<PRTO, String> nameContainsQuery = (prto, query) -> prto.getName().toLowerCase().contains(query.toLowerCase());
        BiPredicate<PRTO, String> attack = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getAttack(), query);
        BiPredicate<PRTO, String> defence = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getDefence(), query);
        BiPredicate<PRTO, String> movement = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getMovement(), query);
        BiPredicate<PRTO, String> cost = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getShieldCost(), query);
        BiPredicate<PRTO, String> popCost = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getPopulationCost(), query);
        BiPredicate<PRTO, String> bombardStrength = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getBombardStrength(), query);
        BiPredicate<PRTO, String> bombardRange = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getBombardRange(), query);
        BiPredicate<PRTO, String> bombardRate = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getRateOfFire(), query);
        BiPredicate<PRTO, String> hpBonus = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getHitPointBonus(), query);
        BiPredicate<PRTO, String> airDefence = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getAirDefence(), query);
        BiPredicate<PRTO, String> operatingRange = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getOperationalRange(), query);
        BiPredicate<PRTO, String> transportCapacity = (prto, query) -> PredicateFactory.evaluateIntegerQuery(prto.getCapacity(), query);
        BiPredicate<PRTO, String> era = (prto, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            List<TECH> technology = Main.getCurrentBIQ().technology;
            List<ERAS> eras = Main.getCurrentBIQ().eras;
            try {
                Integer value = Integer.parseInt(query.substring(1));
                if (value == 0) {
                    return prto.getRequiredTech() == -1;
                }
                if (prto.getRequiredTech() == -1) {
                    return false;
                }
                TECH reqTech = technology.get(prto.getRequiredTech());
                return reqTech.getEra() + 1 == value;
            }
            catch (NumberFormatException ex) {
                String eraName = query.substring(1);
                if (eraName.equalsIgnoreCase("None")) {
                    return prto.getRequiredTech() == -1;
                }
                for (int i = 0; i < eras.size(); ++i) {
                    ERAS age = eras.get(i);
                    if (!age.getName().equalsIgnoreCase(eraName)) continue;
                    if (prto.getRequiredTech() == -1) {
                        return false;
                    }
                    TECH reqTech = technology.get(prto.getRequiredTech());
                    return reqTech.getEra() == i;
                }
                return false;
            }
        };
        BiPredicate<PRTO, String> reqTech = (prto, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            String techName = query.substring(1);
            if (techName.equalsIgnoreCase("None")) {
                return prto.getRequiredTech() == -1;
            }
            List<TECH> technology = Main.getCurrentBIQ().technology;
            for (int t = 0; t < technology.size(); ++t) {
                TECH tech = technology.get(t);
                if (!tech.getName().toLowerCase().equals(techName.toLowerCase())) continue;
                return prto.getRequiredTech() == t;
            }
            return false;
        };
        BiPredicate<PRTO, String> reqGood = (prto, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            String goodName = query.substring(1);
            if (goodName.equalsIgnoreCase("None")) {
                return prto.getRequiredResource1() == -1 && prto.getRequiredResource2() == -1 && prto.getRequiredResource3() == -1;
            }
            List<GOOD> goods = Main.getCurrentBIQ().resource;
            for (int g = 0; g < goods.size(); ++g) {
                GOOD good = goods.get(g);
                if (!good.getName().toLowerCase().equals(goodName.toLowerCase())) continue;
                return prto.getRequiredResource1() == g || prto.getRequiredResource2() == g || prto.getRequiredResource3() == g;
            }
            return false;
        };
        BiPredicate<PRTO, String> classPredicate = (prto, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            switch (query.substring(1).toLowerCase()) {
                case "land": {
                    return prto.getUnitClass() == PRTO.CLASS_LAND;
                }
                case "sea": {
                    return prto.getUnitClass() == PRTO.CLASS_SEA;
                }
                case "air": {
                    return prto.getUnitClass() == PRTO.CLASS_AIR;
                }
            }
            return false;
        };
        BiPredicate<PRTO, String> availableTo = (prto, query) -> {
            List<RACE> civilization = Main.getCurrentBIQ().civilization;
            int numCivsAvailableTo = 0;
            Integer value = null;
            try {
                value = Integer.parseInt(query.substring(1));
                for (int c = 0; c < civilization.size(); ++c) {
                    if (!prto.isAvailableTo(c)) continue;
                    ++numCivsAvailableTo;
                }
            }
            catch (NumberFormatException ex) {
                String civName = query.substring(1);
                for (int c = 0; c < civilization.size(); ++c) {
                    RACE civ = civilization.get(c);
                    if (!civ.getName().toLowerCase().equals(civName.toLowerCase())) continue;
                    return prto.isAvailableTo(c);
                }
            }
            if (query.startsWith(">")) {
                return numCivsAvailableTo > value;
            }
            if (query.startsWith("<")) {
                return numCivsAvailableTo < value;
            }
            if (query.startsWith("=")) {
                return numCivsAvailableTo == value;
            }
            return false;
        };
        BiPredicate<PRTO, String> uniqueTo = (prto, query) -> {
            if (!prto.isUniqueUnit()) {
                return false;
            }
            List<RACE> civilization = Main.getCurrentBIQ().civilization;
            String civName = query.substring(1);
            for (int c = 0; c < civilization.size(); ++c) {
                RACE civ = civilization.get(c);
                if (!civ.getName().toLowerCase().equals(civName.toLowerCase())) continue;
                return prto.isAvailableTo(c);
            }
            return false;
        };
        BiPredicate<PRTO, String> ignoreMovementCost = (prto, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            List<TERR> terrains = Main.getCurrentBIQ().terrain;
            String terrName = query.substring(1);
            for (int c = 0; c < terrains.size(); ++c) {
                TERR terr = terrains.get(c);
                if (!terr.getName().toLowerCase().equals(terrName.toLowerCase())) continue;
                return prto.ignoresTerrain(c);
            }
            return false;
        };
        BiPredicate<PRTO, String> allRoads = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.treatsAllTerrainAsRoads(), query);
        BiPredicate<PRTO, String> amphibious = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isAmphibious(), query);
        BiPredicate<PRTO, String> army = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isArmy(), query);
        BiPredicate<PRTO, String> blitz = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isBlitz(), query);
        BiPredicate<PRTO, String> cruiseMissile = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isCruiseMissile(), query);
        BiPredicate<PRTO, String> detectInvisible = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.detectsInvisible(), query);
        BiPredicate<PRTO, String> draft = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isDraftable(), query);
        BiPredicate<PRTO, String> flagUnit = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isFlagUnit(), query);
        BiPredicate<PRTO, String> footUnit = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isFootSoldier(), query);
        BiPredicate<PRTO, String> hiddenNationality = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.hasHiddenNationality(), query);
        BiPredicate<PRTO, String> immobile = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isImmobile(), query);
        BiPredicate<PRTO, String> infiniteBombard = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.hasInfiniteBombardRange(), query);
        BiPredicate<PRTO, String> invisible = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isInvisible(), query);
        BiPredicate<PRTO, String> king = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isKing(), query);
        BiPredicate<PRTO, String> leader = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isLeader(), query);
        BiPredicate<PRTO, String> lethalLand = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.hasLethalLandBombardment(), query);
        BiPredicate<PRTO, String> lethalSea = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.hasLethalSeaBombardment(), query);
        BiPredicate<PRTO, String> nuclearWeapon = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isNuclearWeapon(), query);
        BiPredicate<PRTO, String> radar = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.hasRadar(), query);
        BiPredicate<PRTO, String> rangedAttack = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.hasRangedAttackAnimation(), query);
        BiPredicate<PRTO, String> requiresEscort = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.requiresEscort(), query);
        BiPredicate<PRTO, String> rotateBeforeAttack = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.rotatesBeforeAttack(), query);
        BiPredicate<PRTO, String> sinksInOcean = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.sinksInOcean(), query);
        BiPredicate<PRTO, String> sinksInSea = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.sinksInSea(), query);
        BiPredicate<PRTO, String> goldenAge = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.startsGoldenAge(), query);
        BiPredicate<PRTO, String> stealth = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isStealth(), query);
        BiPredicate<PRTO, String> tacticalMissile = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.isTacticalMissile(), query);
        BiPredicate<PRTO, String> transportsAircraft = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.transportsOnlyAirUnits(), query);
        BiPredicate<PRTO, String> transportsFoot = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.transportsOnlyFootUnits(), query);
        BiPredicate<PRTO, String> transportsMissiles = (prto, query) -> PredicateFactory.evaluateBooleanQuery(prto.transportsOnlyTacticalMissiles(), query);
        HashMap<String, BiPredicate<PRTO, String>> keyToPredicateMap = new HashMap<String, BiPredicate<PRTO, String>>();
        keyToPredicateMap.put("attack".toLowerCase(), attack);
        keyToPredicateMap.put("defence".toLowerCase(), defence);
        keyToPredicateMap.put("defense".toLowerCase(), defence);
        keyToPredicateMap.put("movement".toLowerCase(), movement);
        keyToPredicateMap.put("cost".toLowerCase(), cost);
        keyToPredicateMap.put("popCost".toLowerCase(), popCost);
        keyToPredicateMap.put("availableTo".toLowerCase(), availableTo);
        keyToPredicateMap.put("bombardStrength".toLowerCase(), bombardStrength);
        keyToPredicateMap.put("bombardRange".toLowerCase(), bombardRange);
        keyToPredicateMap.put("bombardRate".toLowerCase(), bombardRate);
        keyToPredicateMap.put("hpBonus".toLowerCase(), hpBonus);
        keyToPredicateMap.put("airDefence".toLowerCase(), airDefence);
        keyToPredicateMap.put("airDefense".toLowerCase(), airDefence);
        keyToPredicateMap.put("opRange".toLowerCase(), operatingRange);
        keyToPredicateMap.put("transportCapacity".toLowerCase(), transportCapacity);
        keyToPredicateMap.put("class".toLowerCase(), classPredicate);
        keyToPredicateMap.put("era".toLowerCase(), era);
        keyToPredicateMap.put("uniqueTo".toLowerCase(), uniqueTo);
        keyToPredicateMap.put("reqTech".toLowerCase(), reqTech);
        keyToPredicateMap.put("reqGood".toLowerCase(), reqGood);
        keyToPredicateMap.put("allRoads".toLowerCase(), allRoads);
        keyToPredicateMap.put("amphibious".toLowerCase(), amphibious);
        keyToPredicateMap.put("army".toLowerCase(), army);
        keyToPredicateMap.put("blitz".toLowerCase(), blitz);
        keyToPredicateMap.put("cruiseMissile".toLowerCase(), cruiseMissile);
        keyToPredicateMap.put("detectInvisible".toLowerCase(), detectInvisible);
        keyToPredicateMap.put("draft".toLowerCase(), draft);
        keyToPredicateMap.put("flagUnit".toLowerCase(), flagUnit);
        keyToPredicateMap.put("footUnit".toLowerCase(), footUnit);
        keyToPredicateMap.put("hiddenNationality".toLowerCase(), hiddenNationality);
        keyToPredicateMap.put("immobile".toLowerCase(), immobile);
        keyToPredicateMap.put("infiniteBombard".toLowerCase(), infiniteBombard);
        keyToPredicateMap.put("invisible".toLowerCase(), invisible);
        keyToPredicateMap.put("king".toLowerCase(), king);
        keyToPredicateMap.put("leader".toLowerCase(), leader);
        keyToPredicateMap.put("lethalLand".toLowerCase(), lethalLand);
        keyToPredicateMap.put("lethalSea".toLowerCase(), lethalSea);
        keyToPredicateMap.put("nuclearWeapon".toLowerCase(), nuclearWeapon);
        keyToPredicateMap.put("radar".toLowerCase(), radar);
        keyToPredicateMap.put("rangedAttack".toLowerCase(), rangedAttack);
        keyToPredicateMap.put("requiresEscort".toLowerCase(), requiresEscort);
        keyToPredicateMap.put("rotateBeforeAttack".toLowerCase(), rotateBeforeAttack);
        keyToPredicateMap.put("sinksInOcean".toLowerCase(), sinksInOcean);
        keyToPredicateMap.put("sinksInSea".toLowerCase(), sinksInSea);
        keyToPredicateMap.put("goldenAge".toLowerCase(), goldenAge);
        keyToPredicateMap.put("stealth".toLowerCase(), stealth);
        keyToPredicateMap.put("tacticalMissile".toLowerCase(), tacticalMissile);
        keyToPredicateMap.put("transportsAircraft".toLowerCase(), transportsAircraft);
        keyToPredicateMap.put("transportsFoot".toLowerCase(), transportsFoot);
        keyToPredicateMap.put("transportsMissiles".toLowerCase(), transportsMissiles);
        keyToPredicateMap.put("wheeled".toLowerCase(), PredicateFactory.createPRTOBoolean(PRTO::isWheeled));
        keyToPredicateMap.put("ignoreMovementCost".toLowerCase(), ignoreMovementCost);
        HashMap<String, BiPredicate> genericPredicateMap = new HashMap<String, BiPredicate>();
        for (Map.Entry e : keyToPredicateMap.entrySet()) {
            genericPredicateMap.put((String)e.getKey(), (BiPredicate)e.getValue());
        }
        return PredicateFactory.constructSectionBiPredicate(genericPredicateMap, nameContainsQuery);
    }

    public static BiPredicate<GOOD, String> createGOODFilter() {
        BiPredicate<GOOD, String> nameContainsQuery = (good, query) -> good.getName().toLowerCase().contains(query.toLowerCase());
        BiPredicate<GOOD, String> food = (good, query) -> PredicateFactory.evaluateIntegerQuery(good.getFoodBonus(), query);
        BiPredicate<GOOD, String> shields = (good, query) -> PredicateFactory.evaluateIntegerQuery(good.getShieldsBonus(), query);
        BiPredicate<GOOD, String> commerce = (good, query) -> PredicateFactory.evaluateIntegerQuery(good.getCommerceBonus(), query);
        BiPredicate<GOOD, String> appearanceRatio = (good, query) -> PredicateFactory.evaluateIntegerQuery(good.getAppearanceRatio(), query);
        BiPredicate<GOOD, String> disappearanceRatio = (good, query) -> PredicateFactory.evaluateIntegerQuery(good.getDisapperanceProbability(), query);
        BiPredicate<GOOD, String> icon = (good, query) -> PredicateFactory.evaluateIntegerQuery(good.getIcon(), query);
        BiPredicate<GOOD, String> typePredicate = (good, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            switch (query.substring(1).toLowerCase()) {
                case "strategic": {
                    return good.getType() == 2;
                }
                case "luxury": {
                    return good.getType() == 1;
                }
                case "bonus": {
                    return good.getType() == 0;
                }
            }
            return false;
        };
        BiPredicate<GOOD, String> prerequisite = (good, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            String techName = query.substring(1);
            if (techName.equalsIgnoreCase("None")) {
                return good.getPrerequisite() == -1;
            }
            TECH prereq = Main.getCurrentBIQ().technology.get(good.getPrerequisite());
            return prereq.getName().equalsIgnoreCase(techName);
        };
        BiPredicate<GOOD, String> era = (good, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            List<TECH> technology = Main.getCurrentBIQ().technology;
            List<ERAS> eras = Main.getCurrentBIQ().eras;
            try {
                Integer value = Integer.parseInt(query.substring(1));
                if (value == 0) {
                    return good.getPrerequisite() == -1;
                }
                if (good.getPrerequisite() == -1) {
                    return false;
                }
                TECH reqTech = technology.get(good.getPrerequisite());
                return reqTech.getEra() + 1 == value;
            }
            catch (NumberFormatException ex) {
                String eraName = query.substring(1);
                if (eraName.equalsIgnoreCase("None")) {
                    return good.getPrerequisite() == -1;
                }
                for (int i = 0; i < eras.size(); ++i) {
                    ERAS age = eras.get(i);
                    if (!age.getName().equalsIgnoreCase(eraName)) continue;
                    if (good.getPrerequisite() == -1) {
                        return false;
                    }
                    TECH reqTech = technology.get(good.getPrerequisite());
                    return reqTech.getEra() == i;
                }
                return false;
            }
        };
        HashMap<String, BiPredicate> genericPredicateMap = new HashMap<String, BiPredicate>();
        HashMap<String, BiPredicate<GOOD, String>> keyToPredicateMap = new HashMap<String, BiPredicate<GOOD, String>>();
        keyToPredicateMap.put("type".toLowerCase(), typePredicate);
        keyToPredicateMap.put("food".toLowerCase(), food);
        keyToPredicateMap.put("shields".toLowerCase(), shields);
        keyToPredicateMap.put("production".toLowerCase(), shields);
        keyToPredicateMap.put("commerce".toLowerCase(), commerce);
        keyToPredicateMap.put("appearance".toLowerCase(), appearanceRatio);
        keyToPredicateMap.put("appearanceRatio".toLowerCase(), appearanceRatio);
        keyToPredicateMap.put("disappearance".toLowerCase(), disappearanceRatio);
        keyToPredicateMap.put("disappearanceRatio".toLowerCase(), disappearanceRatio);
        keyToPredicateMap.put("icon".toLowerCase(), icon);
        keyToPredicateMap.put("prerequisite".toLowerCase(), prerequisite);
        keyToPredicateMap.put("era".toLowerCase(), era);
        for (Map.Entry e : keyToPredicateMap.entrySet()) {
            genericPredicateMap.put((String)e.getKey(), (BiPredicate)e.getValue());
        }
        return PredicateFactory.constructSectionBiPredicate(genericPredicateMap, nameContainsQuery);
    }

    public static BiPredicate createTECHFilter() {
        BiPredicate<TECH, String> nameContainsQuery = (tech, query) -> tech.getName().toLowerCase().contains(query.toLowerCase());
        BiPredicate<TECH, String> enablesRecycling = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesRecycling(), query);
        BiPredicate<TECH, String> notReqForAdvancement = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getNotRequiredForAdvancement(), query);
        BiPredicate<TECH, String> bonusTechAwarded = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getBonusTech(), query);
        BiPredicate<TECH, String> permitsSacrifice = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getPermitsSacrifice(), query);
        BiPredicate<TECH, String> revealsWorldMap = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getRevealMap(), query);
        BiPredicate<TECH, String> diplomats = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesDiplomats(), query);
        BiPredicate<TECH, String> alliances = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesAlliances(), query);
        BiPredicate<TECH, String> rightOfPassage = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesROP(), query);
        BiPredicate<TECH, String> enablesMPP = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesMPP(), query);
        BiPredicate<TECH, String> tradeEmbargoes = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesTradeEmbargoes(), query);
        BiPredicate<TECH, String> mapTrading = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesMapTrading(), query);
        BiPredicate<TECH, String> communicationTrading = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesCommunicationTrading(), query);
        BiPredicate<TECH, String> irrigationWithoutWater = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesIrrigationWithoutFreshWater(), query);
        BiPredicate<TECH, String> stopsDisease = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getDisablesFloodPlainDisease(), query);
        BiPredicate<TECH, String> doublesWorkRate = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getDoublesWorkRate(), query);
        BiPredicate<TECH, String> notTradeable = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getCannotBeTraded(), query);
        BiPredicate<TECH, String> doublesWealth = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getDoublesWealth(), query);
        BiPredicate<TECH, String> tradeBySea = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesSeaTrade(), query);
        BiPredicate<TECH, String> tradeByOcean = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesOceanTrade(), query);
        BiPredicate<TECH, String> bridges = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesBridges(), query);
        BiPredicate<TECH, String> conscription = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesConscription(), query);
        BiPredicate<TECH, String> mobilizationLevels = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesMobilizationLevels(), query);
        BiPredicate<TECH, String> precisionBombing = (tech, query) -> PredicateFactory.evaluateBooleanQuery(tech.getEnablesPrecisionBombing(), query);
        BiPredicate<TECH, String> era = (tech, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            query = query.substring(1);
            try {
                Integer value = Integer.parseInt(query);
                if (value == 0 ? tech.getEra() != -1 : tech.getEra() + 1 != value) {
                    return false;
                }
            }
            catch (NumberFormatException ex) {
                if (query.equalsIgnoreCase("None") && tech.getEra() != -1) {
                    return false;
                }
                List<ERAS> eras = Main.getCurrentBIQ().eras;
                for (int i = 0; i < eras.size(); ++i) {
                    ERAS age = eras.get(i);
                    if (!age.getName().equalsIgnoreCase((String)query) || tech.getEra() == i) continue;
                    return false;
                }
            }
            return true;
        };
        BiPredicate<TECH, String> costPredicate = (tech, query) -> {
            Integer value = null;
            try {
                value = Integer.parseInt(query.substring(1));
            }
            catch (NumberFormatException ex) {
                return false;
            }
            if (query.startsWith(">")) {
                return tech.getCost() > value;
            }
            if (query.startsWith("<")) {
                return tech.getCost() < value;
            }
            if (query.startsWith("=")) {
                return tech.getCost() == value.intValue();
            }
            return false;
        };
        BiPredicate<TECH, String> reqTech = (tech, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            String techName = query.substring(1);
            if (techName.equalsIgnoreCase("None")) {
                if (tech.getPrerequisite1() != -1 || tech.getPrerequisite2() != -1 || tech.getPrerequisite3() != -1 || tech.getPrerequisite4() != -1) {
                    return false;
                }
            } else {
                List<TECH> technologies = Main.getCurrentBIQ().technology;
                for (int t = 0; t < technologies.size(); ++t) {
                    TECH iterTech = technologies.get(t);
                    if (!iterTech.getName().toLowerCase().equals(techName.toLowerCase()) || tech.getPrerequisite1() == t || tech.getPrerequisite2() == t || tech.getPrerequisite3() == t || tech.getPrerequisite4() == t) continue;
                    return false;
                }
            }
            return true;
        };
        BiPredicate<TECH, String> flavor = (tech, query) -> {
            if (!query.startsWith("=")) {
                return false;
            }
            List<FLAV> flavors = Main.getCurrentBIQ().flavor;
            for (int i = 0; i < tech.getFlavours().size(); ++i) {
                if (tech.getFlavour(i)) continue;
                FLAV flavour = flavors.get(i);
                if (!utils.cTrim(flavour.name).equalsIgnoreCase(query.substring(1))) continue;
                return false;
            }
            return true;
        };
        HashMap<String, BiPredicate<TECH, String>> keyToPredicateMap = new HashMap<String, BiPredicate<TECH, String>>();
        keyToPredicateMap.put("enablesRecycling".toLowerCase(), enablesRecycling);
        keyToPredicateMap.put("notReqForAdvancement".toLowerCase(), notReqForAdvancement);
        keyToPredicateMap.put("bonusTechAwarded".toLowerCase(), bonusTechAwarded);
        keyToPredicateMap.put("permitsSacrifice".toLowerCase(), permitsSacrifice);
        keyToPredicateMap.put("revealsWorldMap".toLowerCase(), revealsWorldMap);
        keyToPredicateMap.put("diplomats".toLowerCase(), diplomats);
        keyToPredicateMap.put("alliances".toLowerCase(), alliances);
        keyToPredicateMap.put("rightOfPassage".toLowerCase(), rightOfPassage);
        keyToPredicateMap.put("enablesMPP".toLowerCase(), enablesMPP);
        keyToPredicateMap.put("tradeEmbargoes".toLowerCase(), tradeEmbargoes);
        keyToPredicateMap.put("mapTrading".toLowerCase(), mapTrading);
        keyToPredicateMap.put("communicationTrading".toLowerCase(), communicationTrading);
        keyToPredicateMap.put("irrigationWithoutWater".toLowerCase(), irrigationWithoutWater);
        keyToPredicateMap.put("stopsDisease".toLowerCase(), stopsDisease);
        keyToPredicateMap.put("doublesWorkRate".toLowerCase(), doublesWorkRate);
        keyToPredicateMap.put("notTradeable".toLowerCase(), notTradeable);
        keyToPredicateMap.put("doublesWealth".toLowerCase(), doublesWealth);
        keyToPredicateMap.put("tradeBySea".toLowerCase(), tradeBySea);
        keyToPredicateMap.put("tradeByOcean".toLowerCase(), tradeByOcean);
        keyToPredicateMap.put("bridges".toLowerCase(), bridges);
        keyToPredicateMap.put("conscription".toLowerCase(), conscription);
        keyToPredicateMap.put("mobilizationLevels".toLowerCase(), mobilizationLevels);
        keyToPredicateMap.put("precisionBombing".toLowerCase(), precisionBombing);
        keyToPredicateMap.put("era".toLowerCase(), era);
        keyToPredicateMap.put("cost".toLowerCase(), costPredicate);
        keyToPredicateMap.put("reqTech".toLowerCase(), reqTech);
        keyToPredicateMap.put("flavor".toLowerCase(), flavor);
        keyToPredicateMap.put("flavour".toLowerCase(), flavor);
        HashMap<String, BiPredicate> genericPredicateMap = new HashMap<String, BiPredicate>();
        for (Map.Entry e : keyToPredicateMap.entrySet()) {
            genericPredicateMap.put((String)e.getKey(), (BiPredicate)e.getValue());
        }
        return PredicateFactory.constructSectionBiPredicate(genericPredicateMap, nameContainsQuery);
    }

    private static BiPredicate constructSectionBiPredicate(Map<String, BiPredicate> keyToPredicateMap, BiPredicate nameContainsQuery) {
        BiPredicate<Object, Object> predicate = (itemBeingEvaluated, userQuery) -> {
            BIQSection tech = (BIQSection)itemBeingEvaluated;
            String query = (String)userQuery;
            LinkedList<BiPredicate> thePredicates = new LinkedList<BiPredicate>();
            List<String> tokens = PredicateCommonFunctions.tokenize(query);
            LinkedList<String> validatedTokens = new LinkedList<String>();
            for (String token : tokens) {
                String key;
                if (token.isEmpty()) continue;
                if (token.equals("(") || token.equals(")") || token.equals("or")) {
                    validatedTokens.add(token);
                    continue;
                }
                if (!(token.contains("=") || token.contains("<") || token.contains(">"))) {
                    thePredicates.add(nameContainsQuery);
                    validatedTokens.add(token);
                    continue;
                }
                String splitter = token.contains("!=") ? "!=" : (token.contains("=") ? "=" : (token.contains("<") ? "<" : ">"));
                String[] split = token.split(splitter);
                if (split.length < 2 || !keyToPredicateMap.containsKey((key = split[0]).toLowerCase())) continue;
                if (splitter.equals("!=")) {
                    thePredicates.add(((BiPredicate)keyToPredicateMap.get(key.toLowerCase())).negate());
                } else {
                    thePredicates.add((BiPredicate)keyToPredicateMap.get(key.toLowerCase()));
                }
                if (splitter.equals("!=")) {
                    validatedTokens.add(splitter.substring(1) + split[1]);
                    continue;
                }
                validatedTokens.add(splitter + split[1]);
            }
            return PredicateCommonFunctions.evaluatePredicates(tech, thePredicates, validatedTokens);
        };
        return predicate;
    }

    private static boolean evaluateIntegerQuery(int comparisonValue, String query) {
        Integer value = null;
        try {
            value = Integer.parseInt(query.substring(1));
        }
        catch (NumberFormatException ex) {
            return false;
        }
        if (query.startsWith(">")) {
            return comparisonValue > value;
        }
        if (query.startsWith("<")) {
            return comparisonValue < value;
        }
        if (query.startsWith("=")) {
            return comparisonValue == value;
        }
        return false;
    }

    private static boolean evaluateBooleanQuery(boolean comparisonValue, String query) {
        if (!query.startsWith("=")) {
            return false;
        }
        if ((query = query.substring(1)).equalsIgnoreCase("true")) {
            return comparisonValue;
        }
        if (query.equalsIgnoreCase("false")) {
            return !comparisonValue;
        }
        return false;
    }

    static BiPredicate<PRTO, String> createPRTOBoolean(Function<PRTO, Boolean> propertyFunction) {
        return (biqItem, query) -> PredicateFactory.evaluateBooleanQuery((Boolean)propertyFunction.apply((PRTO)biqItem), query);
    }
}

