/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.specialty;

import com.civfanatics.civ3.xplatformeditor.FileIO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.Settings;
import com.civfanatics.civ3.xplatformeditor.specialty.JavaVersion;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.apache.log4j.Logger;

public class StartupWidgets {
    static Logger logger = Logger.getLogger(StartupWidgets.class);

    public static JPanel setupStartWidgets(Container pane, GridBagConstraints gc, JPanel pnlTemporary, final Consumer<String> fileOpener) {
        gc.gridx = 0;
        ++gc.gridy;
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        gc.gridwidth = 12;
        gc.fill = 1;
        pnlTemporary = new JPanel();
        GridLayout gl = new GridLayout(1, 2, 5, 0);
        pnlTemporary.setLayout(gl);
        JPanel pnlStartLeft = new JPanel();
        JPanel pnlStartRight = new JPanel();
        GridBagConstraints startConstraints = new GridBagConstraints();
        startConstraints.weightx = 1.0;
        startConstraints.weighty = 1.0;
        startConstraints.fill = 1;
        startConstraints.anchor = 11;
        pnlTemporary.add((Component)pnlStartLeft, startConstraints);
        startConstraints.gridx = 1;
        pnlTemporary.add((Component)pnlStartRight, startConstraints);
        pnlTemporary.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Quick Links"));
        GridBagLayout leftLayout = new GridBagLayout();
        GridBagConstraints leftConstraints = new GridBagConstraints();
        pnlStartLeft.setLayout(leftLayout);
        leftConstraints.weightx = 1.0;
        leftConstraints.weighty = 0.0;
        leftConstraints.gridy = 0;
        leftConstraints.fill = 2;
        leftConstraints.anchor = 11;
        leftConstraints.ipadx = 10;
        leftConstraints.ipady = 10;
        final JPanel pnlMostRecentFile = new JPanel();
        pnlMostRecentFile.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Resume Editing"));
        pnlMostRecentFile.setLayout(new GridBagLayout());
        GridBagConstraints mrfConstraints = new GridBagConstraints();
        mrfConstraints.fill = 0;
        mrfConstraints.weightx = 0.0;
        mrfConstraints.weighty = 1.0;
        mrfConstraints.gridy = 0;
        mrfConstraints.anchor = 11;
        JButton openMostRecent = new JButton("Open Most Recent File");
        openMostRecent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileOpener.accept(Settings.recentFiles[0]);
            }
        });
        final JLabel mostRecentFileName = new JLabel("File: " + Settings.recentFiles[0]);
        pnlMostRecentFile.add((Component)openMostRecent, mrfConstraints);
        mrfConstraints.gridy = 1;
        pnlMostRecentFile.add((Component)mostRecentFileName, mrfConstraints);
        if (Settings.recentFiles[0] == null) {
            pnlMostRecentFile.setVisible(false);
        }
        pnlStartLeft.add((Component)pnlMostRecentFile, leftConstraints);
        JPanel pnlCopySettings = new JPanel();
        pnlCopySettings.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Copy Settings"));
        pnlCopySettings.setLayout(new GridBagLayout());
        GridBagConstraints csConstraints = new GridBagConstraints();
        csConstraints.fill = 0;
        csConstraints.weightx = 0.0;
        csConstraints.weighty = 1.0;
        csConstraints.gridy = 0;
        final JButton copySettings = new JButton("Copy Settings");
        final JLabel copySettingsInfo = new JLabel("<html>Copy your settings from a previous editor installation.  This includes everything within Options --> Editor Settings, additional cached preferences, such as BMP import colors, and any bundled JRE for Windows XP.</html>");
        copySettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    File folder = FileIO.getFile(0, true, null, "Choose Old Install Folder");
                    File[] oldInstallFiles = folder.listFiles();
                    boolean hasBmpColors = false;
                    boolean hasXPJRE = false;
                    for (File oldFile : oldInstallFiles) {
                        File[] binFiles;
                        if (oldFile.getName().equals("civ3editor.ini")) {
                            Files.copy(oldFile.toPath(), Paths.get("civ3editor.ini", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            continue;
                        }
                        if (oldFile.getName().equals("bmpcolors.txt")) {
                            Files.copy(oldFile.toPath(), Paths.get("bmpcolors.txt", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            hasBmpColors = true;
                            continue;
                        }
                        if (oldFile.getName().equals("XP_launcher.vbs")) {
                            Files.copy(oldFile.toPath(), Paths.get("XP_launcher.vbs", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            hasXPJRE = true;
                            continue;
                        }
                        if (oldFile.getName().equals("Editor_XP.bat")) {
                            Files.copy(oldFile.toPath(), Paths.get("Editor_XP.bat", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                            hasXPJRE = true;
                            continue;
                        }
                        if (oldFile.getName().equals("jre1.8_111")) {
                            utils.copy(oldFile.getCanonicalPath(), "jre1.8_111", false);
                            hasXPJRE = true;
                            continue;
                        }
                        if (!oldFile.getName().equals("bin")) continue;
                        for (File binFile : binFiles = oldFile.listFiles()) {
                            if (!binFile.getName().equals("7z")) continue;
                            utils.copy(binFile.getCanonicalPath(), "bin/7z", false);
                        }
                    }
                    Main.processConfigFile("");
                    copySettings.setEnabled(false);
                    String bmpText = "";
                    String xpText = "";
                    if (hasBmpColors) {
                        bmpText = "<br />Your BMP colors settings have also been successfully imported.";
                    }
                    if (hasXPJRE) {
                        xpText = "<br />Your bundled JRE for Windows XP compatibility has also been successfully imported.  A restart will be required for it to take effect.";
                    }
                    copySettingsInfo.setText("<html>Your settings have been successfully imported from " + folder.getName() + " and are now in effect (except those which require a restart to switch).  You may view them in Options -> Editor Settings (Ctrl+P)." + bmpText + xpText + "</html>");
                    if (Settings.recentFiles[0] != null) {
                        mostRecentFileName.setText("File: " + Settings.recentFiles[0]);
                        pnlMostRecentFile.setVisible(true);
                    }
                }
                catch (IOException ex) {
                    logger.error("Error while copying old settings", ex);
                    JOptionPane.showMessageDialog(null, "An error occurred while copying the old install's settings.  See the log for details", "Error", 0);
                }
            }
        });
        pnlCopySettings.add((Component)copySettings, csConstraints);
        csConstraints.gridy = 1;
        csConstraints.weightx = 1.0;
        csConstraints.fill = 2;
        pnlCopySettings.add((Component)copySettingsInfo, csConstraints);
        leftConstraints.anchor = 11;
        leftConstraints.gridy = 1;
        if (!Main.settings.noConfigFileAtStart) {
            pnlCopySettings.setVisible(false);
        }
        pnlStartLeft.add((Component)pnlCopySettings, leftConstraints);
        JPanel pnlSpaceDummy = new JPanel();
        leftConstraints.weighty = 1.0;
        leftConstraints.gridy = 2;
        pnlStartLeft.add((Component)pnlSpaceDummy, leftConstraints);
        GridBagLayout rightLayout = new GridBagLayout();
        GridBagConstraints rightConstraints = new GridBagConstraints();
        pnlStartRight.setLayout(rightLayout);
        rightConstraints.weightx = 1.0;
        rightConstraints.weighty = 0.0;
        rightConstraints.gridy = 0;
        rightConstraints.fill = 2;
        rightConstraints.anchor = 11;
        rightConstraints.ipadx = 10;
        rightConstraints.ipady = 10;
        JPanel pnlTipOfTheDay = new JPanel();
        pnlTipOfTheDay.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Editor Feature Spotlight"));
        pnlTipOfTheDay.setLayout(new GridBagLayout());
        GridBagConstraints tipConstraints = new GridBagConstraints();
        tipConstraints.fill = 1;
        tipConstraints.weightx = 1.0;
        tipConstraints.weighty = 1.0;
        tipConstraints.gridy = 0;
        tipConstraints.anchor = 11;
        String tip0 = "<html><h4>Welcome to the Editor!</h4>To get started, go to File -> Open, and select a BIQ to open.  The editor will automatically load all required graphics, and you will then be able to edit any scenario properties, or the map.<p>When the editor starts in the future, tips pointing out features of the editor that differ from the Firaxis editor, or more efficient ways of using the editor, will appear here.</p><p>For now, you can choose File -> Open to open a scenario.  Once you've opened a scenario, all the various rule section tabs will appear, including the map.</p><p>Nearly all features of the Firaxis editor are supported.  Most are fairly easy to find, but a few may be in different places.  Of particular note is that you right-click on a list of units/technologies/etc. to add/delete/rename, rather than having buttons for these.  Screen space was at a premium on some tabs back in the day!</p></html>";
        String tip1 = "<html><h4>Custom Civ Colors</h4>From the CIV tab, you can create custom civ colors by pressing the Edit Civ Colors button.  This allows you to go beyond the default 32 colors that ship with Civ3, and create civ-specific colors limited only by your imagination and a choice of 16.7 million colors.</p><p>And if that's not enough?  There are 35 palette choices per civ, affecting items ranging from the circle around the leader on the diplo screen to the city border colors, for 587 million possible colors per civ!</p></html>";
        String tip2 = "<html><h4>Deepwater Harbours</h4>When painting Sea tiles on the map, you may optionally add Deepwater Harbors.  These should be placed over coast tiles, and replace the coast with sea, but do not change the graphics.  As the graphics do not change, it is recommended to also add a resource to the tile to give a visual indicator.<p>When combined with adding ships with the Wheeled attribute, and making Coast impassable to Wheeled units, this lets you create ships that will only pass along certain sea lanes.</p></html>";
        String tip3 = "<html><h4>Downloading Units</h4>The Download Units button, on the right side of the Units Tab, allows you to download units from CivFanatics directly into your scenario.  Decompression of the units, renaming the .ini file to match your desired name, and placing it in the proper location are all taken care of for you.<p>This works for single unit downloads (as opposed to unit packs), and uses 7-Zip on Windows to perform the decompression (which can be automatically downloaded for you).  It should work with any unit in the Downloads Database.</p><p>In theory this could be extended to other Downloads Database items as well.  If you'd like to be able to download more types of items (leaderheads, terrain packs, etc.), express interest in the thread!</p></html>";
        String tip4 = "<html><h4>Item Filtering</h4>The Tech, Unit, Building, and Good tabs support filtering the items in the list by typing into the box above the list of items.  This goes far beyond simply filtering by name, and fairly complex queries, such as \"ships with attack of at least 6 that are available to Persia\" are possible.<p>To see the list of possible filters, and how to enter them, view the Help sections for these tabs.</p></html>";
        String tip5 = "<html><h4>Item Re-Ordering</h4>The Tech, Unit, and Good tabs support re-ordering the items in the list.  To re-order items, click and drag the one you wish to move.  As you move the mouse over another item, that iteem will be highlighted in a lighter blue than the one you are dragging.  Releasing will move the dragged item below the one with lighter blue highlighting, as indicated by the black line below that item.</html>";
        String tip6 = "<html><h4>No More Arbitrary Limits</h4>Some of the limits in the Firaxis editor are necessary due to the BIQ format, but others are arbitrary.  This editor allows you to experiment with going beyond those limits.  By default, a few items where it's known to be safe to go beyond these limits are enabled.  However, you can enable this for more areas by going to Options -> Adjust Safety Level, and setting the limits to Exploratory or Minimal.<p>This allows possibilities such as negative-maintenance buildings, super-costly units or buildings... and possibly other aspects that no one has tried before.</p></html>";
        String tip7 = "<html><h4>Importing Maps from Images</h4>The Map -> Import Map from BMP option allows you to import a map from a bitmap image.  This is designed to work with sateillite imagery, although it should work with other raw sources of color-coded maps as well.  It will ask you to map colors to Civ3 terrain types, and then automatically analyze the map and create a Civ3 map based on it, while observing Civ3 limitations such as no desert bordering tundra.<p>It does require that the BMP have specific dimensions, but these are relative to the Civ3 map size - you can import a map into any size of Civ3 map.  The Map -> BMP Size Calculator option will help you with resizing your BMP file to a size the editor can work with.  It likely will be rather large, but you won't need to keep the resized image after the import.</p><p>If the map doesn't look quite right on the first import, you can try again, and the editor will remember which colors you chose to map to which terrains, so you only have to enter those you wish to change on the second try.</p><p>Some manual editing of the map after import is to be expected (adding rivers and resources if nothing else, but likely some tweaking as well), but this is a great way to speed up the initial creation of a map if you have relevant imagery.</p></html>";
        String tip8 = "<html><h4>City and Leader Editing</h4>You can paste newline-separated lists of cities or leaders into the city, scientific leader, or military leader lists on the CIV tab.  After copying, click in the entry area, type Ctrl+V, and the copied entries will be added.<p>You can also rename cities or leaders by double-clicking them in the list.</p></html>";
        String tip9 = "<html><h4>Detecting Invalid Settings</h4>The editor will notify you when you save if it detects settings that can cause problems in-game.<p>Currently, it checks for loops in unit upgrade paths, and the Phantom Resource Bug.  These checks can be disabled in the Settings, but are recommended as they have deletrious effects in-game and are difficult to manually detect.</p></html>";
        String tip10 = "<html><h4>Wonderful Buildings</h4>In the Firaxis editor, many building attributes are only available to wonders.  In this editor, however, a regular building can have \"wonder\" attributes.<p>The effect of these when applied to buildings have not all been verified, and some may make more sense when applied to wonders.  But if you want a regular building to require a victorious army?  Go right ahead!</p></html>";
        String tip11 = "<html><h4>Autosave</h4>Power went out and you hadn't saved for awhile?  Good news - the editor keeps auto-saves of your work, by default up to 10 auto saves, saved every 4 minutes.  They are located in the editor's folder.  This can be modified under Settings -> Autosave.  They're also a nice fallback if you realize you really didn't want to make that most recent change you made, but already saved.</html>";
        String tip12 = "<html><h4>Map Settings</h4>You can tweak a variety of map settings under Settings -> Map.  This includes what layers are visible (montains, forest, etc.), whether the grid is displayed, and how sensitive the map is when drawing rivers.</html>";
        String tip13 = "<html><h4>Keyboard Shortcuts</h4>A number of actions have keyboard shortcuts.  Menus and submenus can be accessed via the Alt key, plus the letter of the menu which is underlined.  For example, Alt+M followed by Alt+G will bring up the \"Redistribute Bonus Grassland\" option under the Map menu.  Some menu actions have Ctrl-based shortcuts as well.<p>In addition, the map supports pressing \"T\" to select terrain type, \"O\" to select overlay type, and the 1, 3, 5, and 7 keys to select terrain radius, similar to the Firaxis editor.</p><p>Another useful shortcut is that after starting the editor, hitting the spacebar will open your most-recently-opened file.</p></html>";
        String tip14 = "<html><h4>More Intuitive Unit Icon Selection</h4>Although you can still select unit icons by entering an index on the Unit tab if you wish, it's no longer necessary to do it that way.<p>Instead, you can click the \"Select Icon\" button above the icon, and select it visually from your units32.pcx file (including if you have a custom units32.pcx).</p></html>";
        String tip15 = "<html><h4>Low-End Modding</h4>Does your cabin in the forest only have a computer with 64 MB of memory and Windows ME?  That doesn't mean you can't mod Civ3!<p>The first post of the forum thread has a link to the most recent version of the editor that will run on old operating systems.  And while editing the map is fairly memory-intensive due to the graphics, if need be you can open the Settings, uncheck \"Map Enabled\", and restart to enable graphics-less rule editing, allowing the editor to run with very low amounts of memory.</p></html>";
        String tip16 = "<html><h4>Reducing Tedium in City Building</h4>Tired of manually adding a building to every city, or ensuring all size 13+ cities have hospitals?  There's a better way now.  For buildings that should appear in most cities, you can go to Options -> Change Special Actions -> Set Buildings in Many Cities at Once.<p>This does what it suggests.  You can easily add buildings to all cities matching certain criteria - size, being coastal, and being owned by a particular player or civ.  You can always customize more from the Map tab, but this can speed up the initial build-out of buildings.</p></html>";
        String tip17 = "<html><h4>Moving a Whole City</h4>Did you realize you should have placed that city one tile to the northeast, but already spent a bunch of time customize it and its units?  Now moving a city is easier than moving your car!<p>Go to the Map Tab, click on the city that needs to be moved, and choose the \"Relocate city\" or \"Relocate city with units\" option below its list of buildings.  Then click on its new location on the map, and it will automatically be moved there.</p></html>";
        String tip18 = "<html><h4>Comparing BIQ Files</h4>The BIC tab allows you to compare two different BIQ files, with the results being put in a text file.  This can allow you to spot differences between BIQs more quickly than manually comparing various BIQ tabs.<p>To use it in this manner, open two files in the editor at once, check the \"Compare Mode\" option on that tab, and select which sections you'd like to compare.  The select an output file, and click the Export! button.</p></html>";
        String tip19 = "<html><h4>Found a Bug?</h4>Although undesirable, occasionally a bug may occur.  In these situations, you can report the bug to the forum thread.  Particularly useful in debugging it are the steps to reproduce it.  Uploading the BIQ-in-progress can be very useful in debugging it, as many bugs only occur when a particular combinations of rules and actions are put together.<p>The editor also keeps a file called log.txt in its folder, which may contain additional information about any errors that occur.  If you encounter a bug and wish to report it, it's worth checking the log.txt file for any errors near the end of that file, and uploading them to the forum.  These can be very useful in pinpointing the cause of the bug.</p></html>";
        String tip20 = "<html><h4>Import Map from BIQ</h4>The Menu --> Import Map option allows you to import the map from another BIQ into your BIQ.  It will automatically match resources based on name, when resources in the map BIQ are present are your BIQ, and will leave out other resources, saving you time.<p>If the map BIQ already has cities or units, but you'd prefer a base terrain map, you can clear them with Map -> Clear -> (Cities or Units).</p><p>This allows you to more easily play your custom rule set with a variety of high-quality maps made by the community.</p></html>";
        String tip21 = "<html><h4>Opportunities to Improve the Editor</h4>The editor has been evolving for the better part of a decade, and has a lot more features today than it did five years ago.  There are a number of ways that you can help make it better.<p>One of those is testing the boundary conditions that have been unlocked in the editor.  What happens if a unit has negative defence?  Can you have a resource that provides food, but also provides negative shields?  Many of these areas have not been fully explored, and a comprehensive study would be useful, and could be incorporated into the editor, setting useful but not artificially restrictive limits.  I'd recommend focusing on one area at a time if you choose to explore this.</p><p>Other opportunities include writing code for the editor (likely the quickest way to implement your most-desired feature, if you have programming experience), and translating the editor so it's more usable across the world.</p><p>Finally, simply using the editor and providing feedback (both on what's useful, and what could use improvement) helps make it better.  Many of the new ideas and features over the years have come from those making mods with it.</p></html>";
        String tip22 = "<html><h4>Advanced Filter Queries</h4>Tech, unit, building, and resource filter queries allow the use of \"or\" and parentheses to form much more complex queries, such as \"(class=sea or class=air) cost>50\"  This functionality will also extend to all future section filters..<p>To view documentation for this functionality, view the Help system and then \"List Filters\" under \"Editor Functionality\".</p></html>";
        String tip23 = "<html><h4>Editing Tech Civilopedia Icons</h4>The Tech Tab now displays the large civilopedia icon for a tech.  If you click on the icon, it will open in your system's default PCX editor, if you have one specified, and you can edit it there.  The editor will have to be restarted to see the new icon in-editor.</html>";
        String tipJava11 = "<html><h4>Java 11 Compatibility</h4>The editor is currently running on Java 11, which removed some components that the editor depends on.  Unfortunately, this means many parts of the editor will not work.  An update is being prepared to fix this, but is not yet available.<p>In the meantime, the recommended course of action is to run the 1.24 XP version, which includes a bundled version of Java 8.  This will work on all versions of Windows from XP through 10.</p><p>You can also safely use the 1.19 Legacy version on Java 11, on any operating system, as it does not use any of the components that were removed in Java 11.</p><p>For full information and updates, you may copy this link to your browser to view the latest updates on the Java 11 support status: https://forums.civfanatics.com/threads/cross-platform-editor-for-conquests-now-available.377188/page-52#post-15224365 </p>";
        String[] tips = new String[]{tip1, tip2, tip3, tip4, tip5, tip6, tip7, tip8, tip9, tip10, tip11, tip12, tip13, tip14, tip15, tip16, tip17, tip18, tip19, tip20, tip21, tip22};
        JTextPane tipTextPane = new JTextPane();
        tipTextPane.setContentType("text/html");
        tipTextPane.setEditable(false);
        tipTextPane.setBackground(null);
        tipTextPane.setBorder(null);
        int tip = ThreadLocalRandom.current().nextInt(0, tips.length);
        tipTextPane.setText(tips[tip]);
        if (Main.settings.noConfigFileAtStart) {
            tipTextPane.setText(tip0);
        }
        if (JavaVersion.hasJava11(System.getProperty("java.version"))) {
            tipTextPane.setText(tipJava11);
        }
        pnlTipOfTheDay.add((Component)tipTextPane, tipConstraints);
        pnlStartRight.add((Component)pnlTipOfTheDay, rightConstraints);
        JPanel pnlSpaceDummy2 = new JPanel();
        rightConstraints.weighty = 1.0;
        rightConstraints.gridy = 1;
        pnlStartRight.add((Component)pnlSpaceDummy2, rightConstraints);
        pnlTemporary.setOpaque(true);
        pane.add((Component)pnlTemporary, gc);
        return pnlTemporary;
    }
}

