/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.specialty;

import com.civfanatics.civ3.xplatformeditor.Main;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class VersionChecker
extends Thread {
    Logger logger = Logger.getLogger(this.getClass());
    Main main;
    String version;

    public VersionChecker(Main main, String version) {
        this.main = main;
        this.version = version;
    }

    @Override
    public void run() {
        try {
            URL url = new URL("http://quintillus.warpmail.net/civ3editor/latestVersion.txt");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setConnectTimeout(1000);
            conn.setReadTimeout(1000);
            int responseCode = conn.getResponseCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Response code: " + responseCode);
            }
            StringBuilder sb = new StringBuilder();
            int available = conn.getInputStream().available();
            while (available > 0) {
                byte[] b = new byte[available];
                conn.getInputStream().read(b);
                String inputString = new String(b, "Windows-1252");
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("version input string: " + inputString);
                }
                sb.append(inputString);
                available = conn.getInputStream().available();
                if (!this.logger.isTraceEnabled()) continue;
                this.logger.trace("available bytes: " + available);
            }
            if (!sb.toString().equals(Main.settings.suppressedUpdateVersion)) {
                int i;
                String[] majorMinorVersion = sb.toString().split("\\.");
                String[] currentMajorMinorVersion = this.version.toString().split("\\.");
                Integer[] majorMinorInt = new Integer[majorMinorVersion.length];
                Integer[] currentInt = new Integer[currentMajorMinorVersion.length];
                for (i = 0; i < majorMinorVersion.length; ++i) {
                    majorMinorInt[i] = Integer.parseInt(majorMinorVersion[i]);
                }
                for (i = 0; i < currentMajorMinorVersion.length; ++i) {
                    currentInt[i] = Integer.parseInt(currentMajorMinorVersion[i]);
                }
                if (majorMinorInt[0] > currentInt[0] || majorMinorInt[1] > currentInt[1]) {
                    this.logger.warn("New version available: " + sb.toString() + "; current is " + this.version);
                    Object[] options = new String[]{"Remind me again later", "Don't remind me until the next version", "Stop checking for updates"};
                    int option = JOptionPane.showOptionDialog(null, "Version " + sb.toString() + " is now available; you are running " + this.version + ".", "New version available", 1, 1, null, options, "Remind me again later");
                    if (option == 1) {
                        Main.settings.suppressedUpdateVersion = sb.toString();
                    } else if (option == 2) {
                        Main.settings.checkForUpdates = false;
                    }
                }
            }
        }
        catch (MalformedURLException ex) {
            System.out.println("Could not check version");
        }
        catch (SocketTimeoutException ex) {
            System.out.println("Could not check version");
        }
        catch (IOException ex) {
            System.out.println("Could not check version");
        }
    }
}

