/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.civilization;

import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.civilopedia.CivilopediaIcon;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.log4j.Logger;

public class CivilizationUnitsController
implements Initializable {
    Logger logger = Logger.getLogger(this.getClass());
    @FXML
    private ListView lstAvailable;
    @FXML
    private ListView lstUnavailable;
    @FXML
    private Button btnApply;
    @FXML
    private Button btnCancel;
    private int civId;
    Callback<ListView<PRTO>, ListCell<PRTO>> cellFactory = new Callback<ListView<PRTO>, ListCell<PRTO>>(){

        public ListCell<PRTO> call(ListView<PRTO> param) {
            ListCell<PRTO> cell = new ListCell<PRTO>(){

                protected void updateItem(PRTO unit, boolean empty) {
                    super.updateItem((Object)unit, empty);
                    if (empty || unit == null) {
                        this.setText(null);
                        this.setGraphic(null);
                    } else {
                        this.setText(unit.getName());
                        if (Main.GRAPHICS_ENABLED) {
                            try {
                                BufferedImage icon = CivilopediaIcon.getSmallCivilopediaIcon(unit);
                                if (icon != null) {
                                    WritableImage fxImg = SwingFXUtils.toFXImage((BufferedImage)icon, null);
                                    this.setGraphic((Node)new ImageView((Image)fxImg));
                                }
                            }
                            catch (Exception ex) {
                                System.err.println(ex.getMessage());
                            }
                        }
                    }
                }
            };
            return cell;
        }
    };

    public void sendCivIdAndUnits(int civId, List<PRTO> available, List<PRTO> unavailable) {
        this.civId = civId;
        this.lstAvailable.setCellFactory(this.cellFactory);
        this.lstUnavailable.setCellFactory(this.cellFactory);
        this.lstAvailable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.lstUnavailable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        ObservableList observableAvailable = FXCollections.observableArrayList();
        observableAvailable.addAll(available);
        this.lstAvailable.setItems(observableAvailable);
        ObservableList observableUnavailable = FXCollections.observableArrayList();
        observableUnavailable.addAll(unavailable);
        this.lstUnavailable.setItems(observableUnavailable);
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    @FXML
    private void moveUnitsToAvailable() {
        ObservableList selectedItems = this.lstUnavailable.getSelectionModel().getSelectedItems();
        this.lstAvailable.getItems().addAll((Collection)selectedItems);
        this.lstUnavailable.getItems().removeAll((Collection)selectedItems);
    }

    @FXML
    private void moveUnitsToUnavailable() {
        ObservableList selectedItems = this.lstAvailable.getSelectionModel().getSelectedItems();
        this.lstUnavailable.getItems().addAll((Collection)selectedItems);
        this.lstAvailable.getItems().removeAll((Collection)selectedItems);
    }

    @FXML
    private void applyUnitsAvailable() {
        ObservableList availableUnits = this.lstAvailable.getItems();
        for (PRTO availableUnit : availableUnits) {
            availableUnit.setAvailableTo(this.civId);
        }
        ObservableList unavailableUnits = this.lstUnavailable.getItems();
        for (PRTO unavailableUnit : unavailableUnits) {
            unavailableUnit.setUnavailableTo(this.civId);
        }
        ((Stage)this.btnApply.getScene().getWindow()).close();
    }

    @FXML
    private void cancelUnitsAvailable() {
        ((Stage)this.btnApply.getScene().getWindow()).close();
    }
}

