/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.civilization;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.OldPCXFilter;
import com.civfanatics.civ3.xplatformeditor.tabs.civilization.BalanceAdjuster;
import com.civfanatics.civ3.xplatformeditor.tabs.civilization.HueAdjuster;
import com.civfanatics.civ3.xplatformeditor.tabs.civilization.SaturationAdjuster;
import com.civfanatics.civ3.xplatformeditor.tabs.map.ColourChooser;
import com.civfanatics.civ3.xplatformeditor.utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;

public class ColorPanel
extends JFrame {
    static final String fileSlash = System.getProperty("file.separator");
    GridBagConstraints gbc = new GridBagConstraints();
    JScrollPane scrollPane = new JScrollPane();
    JPanel scrollable = new JPanel();
    JPanel pnlThingsThatScroll = new JPanel();
    static ColourChooser cc = new ColourChooser(null, true);
    final String strShouldRemainSame = "Should remain the same for all colors - do not change";
    final String strShadeOfGray = "Shade of gray - changing not recommended";
    final String strColor = "Color ";
    boolean existingCopy = false;
    String pcxName = "";
    OldPCXFilter pcx;
    private int MAX_WIDTH = 6;
    JCheckBox chkRhye = new JCheckBox("Rhye's Recommendations");
    JCheckBox chkShadesOfGray = new JCheckBox("Shades of Gray");
    JCheckBox chkShouldntChange = new JCheckBox("Shouldn't Change");
    JCheckBox chkMainColor = new JCheckBox("Shades of main color");
    JCheckBox chkOtherUsefulColors = new JCheckBox("Other useful colors");
    JCheckBox chkAllOthers = new JCheckBox("All others");
    Integer[] mainColors = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    Integer[] otherColors = new Integer[]{64, 65, 66, 67, 68, 69};
    Integer[] rhyes = new Integer[]{10, 11, 12, 13, 14, 15, 20, 24, 26, 30, 32, 38, 44, 48, 50, 56, 60, 62};
    Integer[] grays = new Integer[]{17, 19, 21, 23, 25, 27, 29, 31};
    Integer[] shouldnt = new Integer[]{31, 33, 35, 37, 39, 41, 43, 45, 47, 49, 51, 53, 55, 57, 59, 61, 63};
    Integer[] allOthers = new Integer[]{16, 18, 22, 28, 34, 36, 40, 42, 46, 52, 54, 58};
    String[] pcxNames = new String[]{"ntp00", "ntp01", "ntp02", "ntp03", "ntp04", "ntp05", "ntp06", "ntp07", "ntp08", "ntp09", "ntp10", "ntp11", "ntp12", "ntp13", "ntp14", "ntp15", "ntp16", "ntp17", "ntp18", "ntp19", "ntp20", "ntp21", "ntp22", "ntp23", "ntp24", "ntp25", "ntp26", "ntp27", "ntp28", "ntp29", "ntp30", "ntp31"};
    int[][] rgb = new int[70][3];
    JLabel[] lblLabels = new JLabel[70];
    JTextField[][] txtFields = new JTextField[70][3];
    JLabel[] lblColors = new JLabel[70];
    Color[] palette;
    String pcxLocation;
    static IO biq;

    public ColorPanel() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ColorPanel.this.savePCX();
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
        this.setPreferredSize(new Dimension(812, 740));
        GridBagLayout gbl = new GridBagLayout();
        JViewport jv = new JViewport();
        this.scrollPane.setViewport(jv);
        this.scrollPane.setViewportView(this.scrollable);
        this.scrollable.setLayout(gbl);
        this.pack();
        this.setTitle("Color Palette Editor");
        this.initComponents();
        Main.mainMain.currentHelp = Main.mainMain.help_ColorPalette;
    }

    public static void setBIQ(IO bic) {
        biq = bic;
    }

    public ColorPanel(int color) {
        String suffix = Integer.valueOf(color).toString();
        if (suffix.length() == 0) {
            suffix = "0" + suffix + ".pcx";
        }
        try {
            this.pcxName = utils.findFile(suffix, "Art" + fileSlash + "units" + fileSlash + "palettes" + fileSlash, biq);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        JOptionPane.showMessageDialog(null, this.pcxName, "Title", 1);
    }

    public static void main(String[] args) {
        new ColorPanel();
    }

    private void savePCX() {
        for (int i = 0; i < 70; ++i) {
            this.palette[i] = new Color(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2]);
        }
        this.pcx.palette.palette = this.palette;
        this.pcx.exportPCX(this.pcxLocation);
    }

    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.gbc.gridheight = 1;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 1;
        this.gbc.weightx = 0.1;
        this.detectExistingCopy();
        JTextArea txtInstructions = new JTextArea("Change colours here!  Click a color to change it, or use Adjust Hue/Saturation/Balance to change all colors at once.\nSee http://forums.civfanatics.com/showpost.php?p=1756301&postcount=14 for more info!");
        txtInstructions.setEditable(false);
        txtInstructions.setRows(2);
        txtInstructions.setWrapStyleWord(true);
        this.gbc.gridwidth = this.MAX_WIDTH;
        this.add((Component)txtInstructions, this.gbc);
        JLabel lblSelectColor = new JLabel("Select color: ");
        final JComboBox cmbColors = new JComboBox();
        JButton cmdHue = new JButton("Adjust Hue");
        JButton cmdSaturation = new JButton("Adjust Saturation");
        JButton cmdBalance = new JButton("Adjust Balance");
        cmbColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("loading color");
                ColorPanel.this.savePCX();
                ColorPanel.this.loadColor(cmbColors.getSelectedIndex());
            }
        });
        cmdHue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.cmdHueAction();
            }
        });
        cmdSaturation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.cmdSaturationAction();
            }
        });
        cmdBalance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.cmdBalanceAction();
            }
        });
        DefaultComboBoxModel<Integer> cmbChooseColor = new DefaultComboBoxModel<Integer>();
        for (int i = 0; i < 32; ++i) {
            cmbChooseColor.addElement(i);
        }
        cmbColors.setModel(cmbChooseColor);
        this.gbc.gridwidth = 1;
        this.gbc.gridy += 2;
        this.gbc.gridx = 1;
        this.add((Component)lblSelectColor, this.gbc);
        ++this.gbc.gridx;
        this.add(cmbColors, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)cmdHue, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)cmdSaturation, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)cmdBalance, this.gbc);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.weightx = 1.0;
        this.add((Component)this.chkRhye, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.chkMainColor, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.chkOtherUsefulColors, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.chkShadesOfGray, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.chkShouldntChange, this.gbc);
        ++this.gbc.gridx;
        this.add((Component)this.chkAllOthers, this.gbc);
        this.chkMainColor.setSelected(true);
        this.chkOtherUsefulColors.setSelected(true);
        this.chkRhye.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateVisibles();
            }
        });
        this.chkMainColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateVisibles();
            }
        });
        this.chkOtherUsefulColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateVisibles();
            }
        });
        this.chkShadesOfGray.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateVisibles();
            }
        });
        this.chkShouldntChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateVisibles();
            }
        });
        this.chkAllOthers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.updateVisibles();
            }
        });
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.weighty = 0.9;
        this.gbc.weightx = 0.1;
        this.gbc.gridwidth = this.MAX_WIDTH;
        this.add((Component)this.scrollPane, this.gbc);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.addColours();
        this.loadColor(0);
        this.updateVisibles();
        this.pack();
    }

    private void loadColor(int index) {
        String pcxString = null;
        try {
            pcxString = utils.findFile(this.pcxNames[index] + ".pcx", "Art" + fileSlash + "units" + fileSlash + "palettes" + fileSlash, biq);
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "Couldn't find it " + e.getMessage());
        }
        this.pcxLocation = pcxString;
        this.pcx = new OldPCXFilter(pcxString);
        this.pcx.readFile();
        this.pcx.parse();
        System.out.println("loaded");
        this.palette = this.pcx.palette.palette;
        for (int i = 0; i < 70; ++i) {
            System.out.println("RGB: " + this.palette[i].getRed() + ", " + this.palette[i].getGreen() + ", " + this.palette[i].getBlue());
            this.rgb[i][0] = this.palette[i].getRed();
            this.rgb[i][1] = this.palette[i].getGreen();
            this.rgb[i][2] = this.palette[i].getBlue();
            this.txtFields[i][0].setText(this.rgb[i][0] + "");
            this.txtFields[i][1].setText(this.rgb[i][1] + "");
            this.txtFields[i][2].setText(this.rgb[i][2] + "");
            this.lblColors[i].setBackground(new Color(this.palette[i].getRGB()));
        }
    }

    private void updateVisibles() {
        HashSet<Integer> makeVisible = new HashSet<Integer>();
        if (this.chkMainColor.isSelected()) {
            makeVisible.addAll(Arrays.asList(this.mainColors));
        }
        if (this.chkOtherUsefulColors.isSelected()) {
            makeVisible.addAll(Arrays.asList(this.otherColors));
        }
        if (this.chkRhye.isSelected()) {
            makeVisible.addAll(Arrays.asList(this.rhyes));
        }
        if (this.chkShadesOfGray.isSelected()) {
            makeVisible.addAll(Arrays.asList(this.grays));
        }
        if (this.chkShouldntChange.isSelected()) {
            makeVisible.addAll(Arrays.asList(this.shouldnt));
        }
        if (this.chkAllOthers.isSelected()) {
            makeVisible.addAll(Arrays.asList(this.allOthers));
        }
        for (int i = 0; i < 70; ++i) {
            if (makeVisible.contains(i)) {
                this.lblLabels[i].setVisible(true);
                this.lblColors[i].setVisible(true);
                this.txtFields[i][0].setVisible(true);
                this.txtFields[i][1].setVisible(true);
                this.txtFields[i][2].setVisible(true);
                continue;
            }
            this.lblLabels[i].setVisible(false);
            this.lblColors[i].setVisible(false);
            this.txtFields[i][0].setVisible(false);
            this.txtFields[i][1].setVisible(false);
            this.txtFields[i][2].setVisible(false);
        }
    }

    private void detectExistingCopy() {
    }

    private void addColours() {
        this.gbc = new GridBagConstraints();
        int id = 0;
        ++this.gbc.gridy;
        this.addRow(id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": Color of starting location/civ color in editor", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": Color of pixel in PCX file", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": Color of circle around leaderhead on Diplomacy screen", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Shade of gray - changing not recommended", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color ", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Should remain the same for all colors - do not change", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": Inner pixels of city borders (in-game)", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": Outer pixel of city borders (in-game)", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": City for unit discs, histographs, and mini-map", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": " + "Color " + " - unknown", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": City color", id);
        ++this.gbc.gridy;
        this.addRow(++id + ": Civ name in histograph", id);
    }

    private void addRow(String title, final int id) {
        JLabel txtColor;
        JLabel label;
        this.lblLabels[id] = label = new JLabel(title);
        final JTextField txtRed = new JTextField(Integer.valueOf(this.rgb[id][0]).toString());
        final JTextField txtGreen = new JTextField(Integer.valueOf(this.rgb[id][1]).toString());
        final JTextField txtBlue = new JTextField(Integer.valueOf(this.rgb[id][2]).toString());
        txtRed.setEditable(false);
        txtGreen.setEditable(false);
        txtBlue.setEditable(false);
        this.txtFields[id][0] = txtRed;
        this.txtFields[id][1] = txtGreen;
        this.txtFields[id][2] = txtBlue;
        this.lblColors[id] = txtColor = new JLabel("");
        int red = Integer.parseInt(txtRed.getText());
        int green = Integer.parseInt(txtGreen.getText());
        int blue = Integer.parseInt(txtBlue.getText());
        txtColor.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                cc.setTitle("Color Chooser - Color " + id);
                int red = Integer.parseInt(txtRed.getText());
                int green = Integer.parseInt(txtGreen.getText());
                int blue = Integer.parseInt(txtBlue.getText());
                cc.setColor(new Color(red, green, blue));
                cc.setVisible(true);
                Color newColor = cc.getColor();
                txtRed.setText(Integer.valueOf(newColor.getRed()).toString());
                txtGreen.setText(Integer.valueOf(newColor.getGreen()).toString());
                txtBlue.setText(Integer.valueOf(newColor.getBlue()).toString());
                txtColor.setBackground(newColor);
                ColorPanel.this.rgb[id][0] = newColor.getRed();
                ColorPanel.this.rgb[id][1] = newColor.getGreen();
                ColorPanel.this.rgb[id][2] = newColor.getBlue();
            }
        });
        txtColor.setBackground(new Color(red, green, blue));
        txtColor.setOpaque(true);
        this.gbc.gridx = 0;
        this.gbc.weightx = 0.2;
        this.gbc.weighty = 0.01;
        this.gbc.gridwidth = 1;
        this.gbc.fill = 1;
        label.setBorder(new LineBorder(Color.black));
        this.scrollable.add((Component)label, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.fill = 1;
        this.scrollable.add((Component)txtRed, this.gbc);
        ++this.gbc.gridx;
        this.scrollable.add((Component)txtGreen, this.gbc);
        ++this.gbc.gridx;
        this.scrollable.add((Component)txtBlue, this.gbc);
        ++this.gbc.gridx;
        this.scrollable.add((Component)txtColor, this.gbc);
    }

    public void cmdHueAction() {
        float[] hsb = Color.RGBtoHSB(this.rgb[0][0], this.rgb[0][1], this.rgb[0][2], null);
        HueAdjuster adjuster = new HueAdjuster((int)((double)(hsb[0] * 360.0f) + 0.5), (int)((double)(hsb[1] * 100.0f) + 0.5), (int)((double)(hsb[2] * 100.0f) + 0.5), this);
        adjuster.setLocationRelativeTo(this);
        adjuster.setVisible(true);
    }

    public void cmdSaturationAction() {
        float[] hsb = Color.RGBtoHSB(this.rgb[0][0], this.rgb[0][1], this.rgb[0][2], null);
        SaturationAdjuster adjuster = new SaturationAdjuster((int)((double)(hsb[0] * 360.0f) + 0.5), (int)((double)(hsb[1] * 100.0f) + 0.5), (int)((double)(hsb[2] * 100.0f) + 0.5), this);
        adjuster.setLocationRelativeTo(this);
        adjuster.setVisible(true);
    }

    public void cmdBalanceAction() {
        float[] hsb = Color.RGBtoHSB(this.rgb[0][0], this.rgb[0][1], this.rgb[0][2], null);
        BalanceAdjuster adjuster = new BalanceAdjuster((int)((double)(hsb[0] * 360.0f) + 0.5), (int)((double)(hsb[1] * 100.0f) + 0.5), (int)((double)(hsb[2] * 100.0f) + 0.5), this);
        adjuster.setLocationRelativeTo(this);
        adjuster.setVisible(true);
    }

    public void keepGoingHue(boolean save, int newHue) {
        float[] hsb = Color.RGBtoHSB(this.rgb[0][0], this.rgb[0][1], this.rgb[0][2], null);
        int hue = (int)((double)(hsb[0] * 360.0f) + 0.5);
        if (save) {
            System.out.println("Old hue: " + hue + ", new hue: " + newHue);
            int diff = newHue - hue;
            HashSet<Integer> applyHue = new HashSet<Integer>();
            applyHue.addAll(Arrays.asList(this.rhyes));
            applyHue.addAll(Arrays.asList(this.mainColors));
            applyHue.addAll(Arrays.asList(this.otherColors));
            applyHue.addAll(Arrays.asList(this.allOthers));
            for (int i = 0; i < this.rgb.length; ++i) {
                if (!applyHue.contains(i)) continue;
                float[] oldHSB = Color.RGBtoHSB(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2], null);
                int oldHue = (int)((double)(hsb[0] * 360.0f) + 0.5);
                float newFloat = ((float)(oldHue += diff) - 0.5f) / 360.0f;
                if (newFloat < 0.0f) {
                    newFloat = 0.0f;
                } else if (newFloat > 1.0f) {
                    newFloat = 1.0f;
                }
                oldHSB[0] = newFloat;
                int newColor = Color.HSBtoRGB(oldHSB[0], oldHSB[1], oldHSB[2]);
                Color c = new Color(newColor);
                this.rgb[i][0] = c.getRed();
                this.rgb[i][1] = c.getGreen();
                this.rgb[i][2] = c.getBlue();
                this.txtFields[i][0].setText(Integer.valueOf(c.getRed()).toString());
                this.txtFields[i][1].setText(Integer.valueOf(c.getGreen()).toString());
                this.txtFields[i][2].setText(Integer.valueOf(c.getBlue()).toString());
                this.lblColors[i].setBackground(c);
            }
        } else {
            System.out.println("Keeping old hue");
        }
    }

    public void keepGoingSaturation(boolean save, int newSaturation) {
        float[] hsb = Color.RGBtoHSB(this.rgb[0][0], this.rgb[0][1], this.rgb[0][2], null);
        int saturation = (int)((double)(hsb[1] * 100.0f) + 0.5);
        if (save) {
            System.out.println("Old hue: " + saturation + ", new hue: " + newSaturation);
            int diff = newSaturation - saturation;
            HashSet<Integer> applyHue = new HashSet<Integer>();
            applyHue.addAll(Arrays.asList(this.rhyes));
            applyHue.addAll(Arrays.asList(this.mainColors));
            applyHue.addAll(Arrays.asList(this.otherColors));
            applyHue.addAll(Arrays.asList(this.allOthers));
            for (int i = 0; i < this.rgb.length; ++i) {
                if (!applyHue.contains(i)) continue;
                float[] oldHSB = Color.RGBtoHSB(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2], null);
                int oldSaturation = (int)((double)(hsb[1] * 100.0f) + 0.5);
                float newFloat = ((float)(oldSaturation += diff) - 0.5f) / 100.0f;
                if (newFloat < 0.0f) {
                    newFloat = 0.0f;
                } else if (newFloat > 1.0f) {
                    newFloat = 1.0f;
                }
                oldHSB[1] = newFloat;
                int newColor = Color.HSBtoRGB(oldHSB[0], oldHSB[1], oldHSB[2]);
                Color c = new Color(newColor);
                this.rgb[i][0] = c.getRed();
                this.rgb[i][1] = c.getGreen();
                this.rgb[i][2] = c.getBlue();
                this.txtFields[i][0].setText(Integer.valueOf(c.getRed()).toString());
                this.txtFields[i][1].setText(Integer.valueOf(c.getGreen()).toString());
                this.txtFields[i][2].setText(Integer.valueOf(c.getBlue()).toString());
                this.lblColors[i].setBackground(c);
            }
        } else {
            System.out.println("Keeping old saturation");
        }
    }

    public void keepGoingBalance(boolean save, int newBalance) {
        float[] hsb = Color.RGBtoHSB(this.rgb[0][0], this.rgb[0][1], this.rgb[0][2], null);
        int balance = (int)((double)(hsb[2] * 100.0f) + 0.5);
        if (save) {
            System.out.println("Old balance: " + balance + ", new balance: " + newBalance);
            int diff = newBalance - balance;
            HashSet<Integer> applyBalance = new HashSet<Integer>();
            applyBalance.addAll(Arrays.asList(this.rhyes));
            applyBalance.addAll(Arrays.asList(this.mainColors));
            applyBalance.addAll(Arrays.asList(this.otherColors));
            applyBalance.addAll(Arrays.asList(this.allOthers));
            for (int i = 0; i < this.rgb.length; ++i) {
                if (!applyBalance.contains(i)) continue;
                float[] oldHSB = Color.RGBtoHSB(this.rgb[i][0], this.rgb[i][1], this.rgb[i][2], null);
                int oldBalance = (int)((double)(hsb[2] * 100.0f) + 0.5);
                float newFloat = ((float)(oldBalance += diff) - 0.5f) / 100.0f;
                if (newFloat < 0.0f) {
                    newFloat = 0.0f;
                } else if (newFloat > 1.0f) {
                    newFloat = 1.0f;
                }
                oldHSB[2] = newFloat;
                int newColor = Color.HSBtoRGB(oldHSB[0], oldHSB[1], oldHSB[2]);
                Color c = new Color(newColor);
                this.rgb[i][0] = c.getRed();
                this.rgb[i][1] = c.getGreen();
                this.rgb[i][2] = c.getBlue();
                this.txtFields[i][0].setText(Integer.valueOf(c.getRed()).toString());
                this.txtFields[i][1].setText(Integer.valueOf(c.getGreen()).toString());
                this.txtFields[i][2].setText(Integer.valueOf(c.getBlue()).toString());
                this.lblColors[i].setBackground(c);
            }
        } else {
            System.out.println("Keeping old saturation");
        }
    }
}

