/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.civilization;

import com.civfanatics.civ3.xplatformeditor.imageSupport.PCXFilter;
import com.civfanatics.civ3.xplatformeditor.tabs.civilization.ColorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HueAdjuster
extends JDialog {
    JLabel lblDescription = new JLabel("<html>You can adjust many colors of a palette at once by adjusting the hue.<br>Changing the hue for the first color will change it for all<br>civ-specific colors by the same amount, thus making it easy to change<br>the civ's color from, for example, red-focused to yellow-focused.</html>");
    JLabel lblColor = new JLabel();
    JSlider sldColor = new JSlider(0, 359);
    JLabel lblHues = new JLabel();
    JLabel lblCurrent = new JLabel("Color: ");
    JLabel lblAdjust = new JLabel("Adjust: ");
    JLabel lblSpectrum = new JLabel("Spectrum:");
    PCXFilter pcx = new PCXFilter("imgs/spectrum.pcx");
    JButton cmdAccept = new JButton("Accept");
    JButton cmdCancel = new JButton("Cancel");
    int hue;
    int saturation;
    int balance;
    boolean okay = false;
    boolean closed = false;
    ColorPanel parent = null;

    public HueAdjuster(int hue, int saturation, int balance, ColorPanel c) {
        this.parent = c;
        this.setTitle("Civ Color Hue Adjuster");
        this.lblHues.setOpaque(true);
        this.pcx.processFile();
        this.hue = hue;
        this.saturation = saturation;
        this.balance = balance;
        this.lblColor.setOpaque(true);
        this.updateColor();
        this.sldColor.setValue(hue);
        this.setDefaultCloseOperation(1);
        this.sldColor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                HueAdjuster.this.sliderChangedAction();
            }
        });
        this.cmdAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HueAdjuster.this.close(true);
            }
        });
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HueAdjuster.this.close(false);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridwidth = 4;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.fill = 1;
        this.add((Component)this.lblDescription, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        this.add((Component)this.lblCurrent, gbc);
        ++gbc.gridy;
        this.add((Component)this.lblAdjust, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)this.lblSpectrum, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 3;
        ++gbc.gridy;
        gbc.weightx = 0.9;
        gbc.gridy = 1;
        this.add((Component)this.lblColor, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.sldColor.setPaintTrack(false);
        this.add((Component)this.sldColor, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.lblHues, gbc);
        ++gbc.gridy;
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        this.add((Component)this.cmdAccept, gbc);
        ++gbc.gridx;
        this.add((Component)this.cmdCancel, gbc);
        this.pack();
        this.lblHues.setBackground(Color.GREEN);
        int width = this.lblHues.getWidth();
        int height = this.lblHues.getHeight();
        Image scaled = this.pcx.getBufferedImage().getScaledInstance(Math.max(width, 320), height, 4);
        this.lblHues.setIcon(new ImageIcon(scaled));
    }

    private void sliderChangedAction() {
        this.hue = this.sldColor.getValue();
        this.updateColor();
    }

    private void updateColor() {
        int rgb = Color.HSBtoRGB((float)this.hue / 360.0f, (float)this.saturation / 100.0f, (float)this.balance / 100.0f);
        Color hsb = new Color(rgb);
        this.lblColor.setBackground(hsb);
    }

    private void close(boolean save) {
        this.okay = save;
        this.setVisible(false);
        this.closed = true;
        this.parent.keepGoingHue(save, this.hue);
    }
}

