/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.civilization;

import com.civfanatics.civ3.xplatformeditor.tabs.civilization.ColorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SaturationAdjuster
extends JDialog {
    JLabel lblDescription = new JLabel("<html>You can adjust many colors of a palette at once by adjusting the saturation.<br>Changing the hue for the first color will change it for all<br>civ-specific colors by the same amount, thus making it easy to change<br>the civ's color from, for example, red-focused to yellow-focused.<br>A high saturation is colorful, like a red tomato, while a low one is washed-out (whiter).</html>");
    JLabel lblColor = new JLabel();
    JSlider sldColor = new JSlider(0, 99);
    JLabel lblCurrent = new JLabel("Color: ");
    JLabel lblAdjust = new JLabel("Adjust: ");
    JButton cmdAccept = new JButton("Accept");
    JButton cmdCancel = new JButton("Cancel");
    int hue;
    int saturation;
    int balance;
    boolean okay = false;
    boolean closed = false;
    ColorPanel parent = null;

    public SaturationAdjuster(int hue, int saturation, int balance, ColorPanel c) {
        this.parent = c;
        this.setTitle("Civ Color Hue Adjuster");
        this.hue = hue;
        this.saturation = saturation;
        this.balance = balance;
        this.lblColor.setOpaque(true);
        this.updateColor();
        this.sldColor.setValue(saturation);
        this.setDefaultCloseOperation(1);
        this.sldColor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SaturationAdjuster.this.sliderChangedAction();
            }
        });
        this.cmdAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaturationAdjuster.this.close(true);
            }
        });
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaturationAdjuster.this.close(false);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridwidth = 4;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 0.1;
        gbc.fill = 1;
        this.add((Component)this.lblDescription, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        this.add((Component)this.lblCurrent, gbc);
        ++gbc.gridy;
        this.add((Component)this.lblAdjust, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 3;
        ++gbc.gridy;
        gbc.weightx = 0.9;
        gbc.gridy = 1;
        this.add((Component)this.lblColor, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.sldColor.setPaintTrack(false);
        this.add((Component)this.sldColor, gbc);
        ++gbc.gridy;
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        this.add((Component)this.cmdAccept, gbc);
        ++gbc.gridx;
        this.add((Component)this.cmdCancel, gbc);
        this.pack();
    }

    private void sliderChangedAction() {
        this.saturation = this.sldColor.getValue();
        this.updateColor();
    }

    private void updateColor() {
        int rgb = Color.HSBtoRGB((float)this.hue / 360.0f, (float)this.saturation / 100.0f, (float)this.balance / 100.0f);
        Color hsb = new Color(rgb);
        this.lblColor.setBackground(hsb);
    }

    private void close(boolean save) {
        this.okay = save;
        this.setVisible(false);
        this.closed = true;
        this.parent.keepGoingSaturation(save, this.saturation);
    }
}

