/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class BMPSizeCalculator
extends JFrame {
    private JButton cmdCalculate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JTextField txtHeight;
    private JTextField txtWidth;

    public BMPSizeCalculator() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtHeight = new JTextField();
        this.txtWidth = new JTextField();
        this.cmdCalculate = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("BMP Calc");
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("BMP Size Calculator");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Height:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Width:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.txtHeight, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 25;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.txtWidth, gridBagConstraints);
        this.cmdCalculate.setText("Calculate");
        this.cmdCalculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BMPSizeCalculator.this.cmdCalculateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cmdCalculate, gridBagConstraints);
        this.pack();
    }

    private void cmdCalculateActionPerformed(ActionEvent evt) {
        int width = 0;
        int height = 0;
        try {
            width = Integer.parseInt(this.txtWidth.getText());
            height = Integer.parseInt(this.txtHeight.getText());
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "Both the width and height must be integers.");
            return;
        }
        if (width * height / 2 > 65536) {
            JOptionPane.showMessageDialog(null, "<html>Sorry, Civ3 only supports maps up to 65,536 tiles in size and these dimensions<br>would result in " + width * height / 2 + " tiles.");
            return;
        }
        int bmpWidth = 32 * width + 32;
        int bmpHeight = 16 * height + 16;
        JOptionPane.showMessageDialog(null, "<html>You will need a BMP file with a width of " + bmpWidth + " pixels, and<br>a height of " + bmpHeight + " pixels.</html>");
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BMPSizeCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BMPSizeCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BMPSizeCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BMPSizeCalculator.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BMPSizeCalculator dialog = new BMPSizeCalculator();
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

