/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperJTextField;
import com.civfanatics.civ3.xplatformeditor.Listeners.FireTriggerDocumentListener;
import com.civfanatics.civ3.xplatformeditor.Main;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CustomMapSetupForm
extends JFrame {
    JLabel lblMapWidth;
    JLabel lblMapHeight;
    static SuperJTextField txtMapWidth;
    static SuperJTextField txtMapHeight;
    String totalTiles = "Total Tiles: ";
    JLabel lblTotalTiles;
    static JLabel lblTotalTiles2;
    JButton cmdOK;
    JButton cmdCancel;
    FireTriggerDocumentListener ftdl;
    FireTriggerDocumentListener ftdl2;
    static int numTiles;
    static int width;
    static int height;
    JLabel lblTerrain = new JLabel("Base terrain");
    static JComboBox cmbTerrain;
    DefaultComboBoxModel mdlTerrain = new DefaultComboBoxModel();

    public CustomMapSetupForm() {
        this.lblMapWidth = new JLabel("Map width");
        this.lblMapHeight = new JLabel("Map height");
        txtMapWidth = new SuperJTextField("100");
        txtMapHeight = new SuperJTextField("100");
        this.lblTotalTiles = new JLabel(this.totalTiles);
        lblTotalTiles2 = new JLabel("5000");
        this.cmdOK = new JButton("OK");
        this.cmdCancel = new JButton("Cancel");
        this.mdlTerrain.addElement("Desert");
        this.mdlTerrain.addElement("Plains");
        this.mdlTerrain.addElement("Grassland");
        this.mdlTerrain.addElement("Tundra");
        this.mdlTerrain.addElement("Coast");
        this.mdlTerrain.addElement("Sea");
        this.mdlTerrain.addElement("Ocean");
        cmbTerrain.setModel(this.mdlTerrain);
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (width < 16 || height < 16) {
                    JOptionPane.showMessageDialog(null, "Please make sure both the width and height are at least 16.", "Too small a map", 0);
                } else if (numTiles > 65536) {
                    JOptionPane.showMessageDialog(null, "Sorry, you can have at most 65,536 tiles.", "Too big a map", 0);
                } else {
                    CustomMapSetupForm.createMap();
                    CustomMapSetupForm.this.setVisible(false);
                }
            }
        });
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomMapSetupForm.this.setVisible(false);
            }
        });
        try {
            this.ftdl = new FireTriggerDocumentListener(txtMapWidth);
            this.ftdl2 = new FireTriggerDocumentListener(txtMapHeight);
            Class[] argument = new Class[]{};
            this.ftdl.method = CustomMapSetupForm.class.getMethod("updateNumTiles", argument);
            this.ftdl2.method = CustomMapSetupForm.class.getMethod("updateNumTiles", argument);
        }
        catch (NoSuchMethodException e) {
            System.err.println("No such method");
        }
        txtMapWidth.getDocument().addDocumentListener(this.ftdl);
        txtMapHeight.getDocument().addDocumentListener(this.ftdl);
        txtMapHeight.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CustomMapSetupForm.updateNumTiles();
            }

            @Override
            public void focusGained(FocusEvent e) {
                CustomMapSetupForm.updateNumTiles();
            }
        });
        GridLayout gl = new GridLayout(5, 2);
        this.setLayout(gl);
        this.add(this.lblTerrain);
        this.add(cmbTerrain);
        this.add(this.lblMapWidth);
        this.add(txtMapWidth);
        this.add(this.lblMapHeight);
        this.add(txtMapHeight);
        this.add(this.lblTotalTiles);
        this.add(lblTotalTiles2);
        this.add(this.cmdOK);
        this.add(this.cmdCancel);
        this.setTitle("Size");
        this.setResizable(false);
        this.pack();
    }

    public static void main(String[] args) {
        new CustomMapSetupForm().setVisible(true);
    }

    public static void updateNumTiles() {
        int one = 0;
        int two = 0;
        try {
            one = txtMapWidth.getInteger();
            two = txtMapHeight.getInteger();
            if (one % 2 == 1) {
                txtMapWidth.setText(Integer.valueOf(++one).toString());
                return;
            }
            if (two % 2 == 1) {
                txtMapHeight.setText(Integer.valueOf(++two).toString());
                return;
            }
        }
        catch (NumberFormatException e) {
            System.err.println("NFE");
        }
        int three = one * two / 2;
        lblTotalTiles2.setText(Integer.valueOf(three).toString());
        numTiles = three;
        width = one;
        height = two;
    }

    private static void createMap() {
        int terrId = 0;
        terrId = cmbTerrain.getSelectedIndex() <= 3 ? cmbTerrain.getSelectedIndex() : cmbTerrain.getSelectedIndex() + 7;
        Main.biqFile.get(Main.biqIndex).createMap(width, height, terrId);
        Main.enableMapTab();
    }

    static {
        numTiles = 5000;
        width = 100;
        height = 100;
        cmbTerrain = new JComboBox();
    }
}

