/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import com.civfanatics.civ3.biqFile.CITY;
import com.civfanatics.civ3.biqFile.CLNY;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.SLOC;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.UNIT;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MapFlipper {
    static Logger logger = Logger.getLogger(MapFlipper.class);

    public MapFlipper(File in, File out) {
        IO biq = new IO();
        try {
            biq.inputBIQ(in);
        }
        catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null, "The specified file (" + in.getPath() + ") could not be found. \nCheck if it has been moved or deleted.");
            return;
        }
        biq = MapFlipper.flip(biq);
        boolean successfulExport = biq.outputBIQ(out);
    }

    public static IO flip(IO biq) {
        int i;
        LinkedList<TILE> newTileOrder = new LinkedList<TILE>();
        int maxWidth = biq.worldMap.get((int)0).width - 1;
        int maxHeight = biq.worldMap.get((int)0).height - 1;
        for (i = biq.tile.size() - 1; i > -1; --i) {
            TILE tileToFlip = biq.tile.get(i);
            tileToFlip.index = biq.tile.size() - i - 1;
            tileToFlip.tileID = biq.tile.size() - i - 1;
            tileToFlip.xPos = maxWidth - tileToFlip.xPos;
            tileToFlip.yPos = maxHeight - tileToFlip.yPos;
            tileToFlip.citiesWithInfluence.clear();
            tileToFlip.owner = 0;
            tileToFlip.ownerType = 0;
            newTileOrder.add(tileToFlip);
        }
        logger.info("Tile order reversed");
        biq.tile.clear();
        biq.tile.addAll(newTileOrder);
        for (int j = 0; j < biq.worldMap.get((int)0).height; ++j) {
            int i2;
            int n = i2 = j % 2 == 0 ? 0 : 1;
            while (i2 < biq.worldMap.get((int)0).width) {
                MapFlipper.recalculateFileAndIndex(i2, j, biq);
                i2 += 2;
            }
        }
        logger.info("Tile file and index recalculated");
        for (i = 0; i < biq.startingLocation.size(); ++i) {
            SLOC sloc = biq.startingLocation.get(i);
            sloc.setX(biq.worldMap.get((int)0).width - 1 - sloc.getX());
            sloc.setY(biq.worldMap.get((int)0).height - 1 - sloc.getY());
        }
        logger.info("SLOCs recalculated");
        for (i = 0; i < biq.tile.size(); ++i) {
            byte rci = biq.tile.get(i).getRiverConnectionInfo();
            byte newInfo = (byte)((rci & 0xFF) >>> 4);
            byte otherHalf = (byte)(rci << 4);
            newInfo = (byte)(newInfo | otherHalf);
            biq.tile.get(i).setRiverConnectionInfo(newInfo);
            byte rcd = biq.tile.get(i).getRiverCrossingData();
            newInfo = (byte)((rcd & 0xFF) >>> 4);
            otherHalf = (byte)(rcd << 4);
            newInfo = (byte)(newInfo | otherHalf);
            biq.tile.get(i).setRiverCrossingData(newInfo);
            int c3cbonuses = biq.tile.get((int)i).C3CBonuses;
            byte riverSourceInfo = (byte)(c3cbonuses >>> 8 & 0xF);
            byte otherNibble = (byte)(c3cbonuses >>> 8 & 0xF0);
            byte newRiverSourceInfo = 0;
            if ((byte)(riverSourceInfo & 8) == 8) {
                newRiverSourceInfo = (byte)(newRiverSourceInfo | 1);
            }
            if ((byte)(riverSourceInfo & 1) == 1) {
                newRiverSourceInfo = (byte)(newRiverSourceInfo | 8);
            }
            if ((byte)(riverSourceInfo & 4) == 4) {
                newRiverSourceInfo = (byte)(newRiverSourceInfo | 2);
            }
            if ((byte)(riverSourceInfo & 2) == 2) {
                newRiverSourceInfo = (byte)(newRiverSourceInfo | 4);
            }
            int mask = -65281;
            c3cbonuses &= mask;
            byte newByte = (byte)(otherNibble | newRiverSourceInfo);
            int secondByte = newByte << 8;
            biq.tile.get((int)i).C3CBonuses = c3cbonuses |= secondByte;
        }
        for (i = 0; i < biq.city.size(); ++i) {
            CITY city = biq.city.get(i);
            city.setX(biq.worldMap.get((int)0).width - 1 - city.getX());
            city.setY(biq.worldMap.get((int)0).height - 1 - city.getY());
        }
        for (i = 0; i < biq.colony.size(); ++i) {
            CLNY colony = biq.colony.get(i);
            colony.setX(biq.worldMap.get((int)0).width - 1 - colony.getX());
            colony.setY(biq.worldMap.get((int)0).height - 1 - colony.getY());
        }
        for (i = 0; i < biq.mapUnit.size(); ++i) {
            UNIT unit = biq.mapUnit.get(i);
            unit.setX(biq.worldMap.get((int)0).width - 1 - unit.getX());
            unit.setY(biq.worldMap.get((int)0).height - 1 - unit.getY());
        }
        biq.calculateTileOwners();
        logger.info("Rivers  recalculated");
        return biq;
    }

    public static void flipMap(File in, File out) {
        new MapFlipper(in, out);
    }

    private static void recalculateFileAndIndex(int x, int y, IO biq) {
        List<TILE> tile = biq.tile;
        int southID = biq.calculateTileIndex(x, y);
        TILE south = southID == -1 ? null : tile.get(southID);
        int westID = biq.calculateTileIndex(x - 1, y - 1);
        TILE west = westID == -1 ? null : tile.get(westID);
        int northID = biq.calculateTileIndex(x, y - 2);
        TILE north = northID == -1 ? null : tile.get(northID);
        int eastID = biq.calculateTileIndex(x + 1, y - 1);
        TILE east = eastID == -1 ? null : tile.get(eastID);
        int terr1 = 0;
        byte terr2 = 0;
        byte terr3 = 0;
        boolean needToCalculateImage = true;
        if (south == null) {
            south = new TILE(biq);
            south.setRealTerrain(11);
            south.setBaseTerrain(11);
            south.setUpNibbles();
        }
        if (east == null) {
            east = new TILE(biq);
            east.setRealTerrain(11);
            east.setBaseTerrain(11);
            east.setUpNibbles();
        }
        if (north == null) {
            north = new TILE(biq);
            north.setRealTerrain(11);
            north.setBaseTerrain(11);
            north.setUpNibbles();
        }
        if (west == null) {
            west = new TILE(biq);
            west.setRealTerrain(11);
            west.setBaseTerrain(11);
            west.setUpNibbles();
        }
        if (south.getBaseTerrain() == 13 && east.getBaseTerrain() == 13 && west.getBaseTerrain() == 13 && north.getBaseTerrain() == 13) {
            south.setFile((byte)8);
            south.setImage((byte)0);
            needToCalculateImage = false;
        } else if (south.getBaseTerrain() == 12 && east.getBaseTerrain() == 12 && west.getBaseTerrain() == 12 && north.getBaseTerrain() == 12) {
            south.setFile((byte)7);
            south.setImage((byte)0);
            needToCalculateImage = false;
        } else if (south.getBaseTerrain() == 3 || east.getBaseTerrain() == 3 || west.getBaseTerrain() == 3 || north.getBaseTerrain() == 3) {
            south.setFile((byte)0);
            terr1 = 3;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 12 || east.getBaseTerrain() == 12 || west.getBaseTerrain() == 12 || north.getBaseTerrain() == 12) {
            south.setFile((byte)6);
            terr1 = 11;
            terr2 = 12;
            terr3 = 13;
        } else if (south.getBaseTerrain() != 11 && east.getBaseTerrain() != 11 && west.getBaseTerrain() != 11 && north.getBaseTerrain() != 11) {
            south.setFile((byte)4);
            terr1 = 0;
            terr2 = 2;
            terr3 = 1;
        } else if (south.getBaseTerrain() == 0 || east.getBaseTerrain() == 0 || west.getBaseTerrain() == 0 || north.getBaseTerrain() == 0) {
            if (south.getBaseTerrain() == 1 || east.getBaseTerrain() == 1 || west.getBaseTerrain() == 1 || north.getBaseTerrain() == 1) {
                south.setFile((byte)3);
                terr1 = 0;
                terr2 = 1;
                terr3 = 11;
            } else if (south.getBaseTerrain() == 2 || east.getBaseTerrain() == 2 || west.getBaseTerrain() == 2 || north.getBaseTerrain() == 2) {
                south.setFile((byte)2);
                terr1 = 0;
                terr2 = 2;
                terr3 = 11;
            } else if (south.getBaseTerrain() == 11 || east.getBaseTerrain() == 11 || west.getBaseTerrain() == 11 || north.getBaseTerrain() == 11) {
                south.setFile((byte)2);
                terr1 = 0;
                terr2 = 1;
                terr3 = 11;
            } else {
                System.err.println("XKCD1.  X: " + x + ", Y: " + y + ", North: " + north.getBaseTerrain() + ", East: " + east.getBaseTerrain() + ", South: " + south.getBaseTerrain() + ", West: " + west.getBaseTerrain());
                JOptionPane.showMessageDialog(null, "Error XKCD, type 1 - error calculating terrain image file.  Please report.", "Error XKCD", 0);
            }
        } else if (south.getBaseTerrain() == 1 || east.getBaseTerrain() == 1 || west.getBaseTerrain() == 1 || north.getBaseTerrain() == 1) {
            south.setFile((byte)1);
            terr1 = 1;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 2 || east.getBaseTerrain() == 2 || west.getBaseTerrain() == 2 || north.getBaseTerrain() == 2) {
            south.setFile((byte)5);
            terr1 = 2;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 11 || east.getBaseTerrain() == 11 || west.getBaseTerrain() == 11 || north.getBaseTerrain() == 11) {
            south.setFile((byte)6);
            terr1 = 11;
            terr2 = 12;
            terr3 = 13;
        } else {
            System.err.println("XKCD2  X: " + x + ", Y: " + y + ", North: " + north.getBaseTerrain() + ", East: " + east.getBaseTerrain() + ", South: " + south.getBaseTerrain() + ", West: " + west.getBaseTerrain());
            JOptionPane.showMessageDialog(null, "Error XKCD, type 2 - error calculating terrain image file.  Please report.", "Error XKCD", 0);
        }
        if (needToCalculateImage) {
            byte sum = 0;
            if (north.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 1);
            }
            if (north.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 2);
            }
            if (west.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 3);
            }
            if (west.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 6);
            }
            if (east.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 9);
            }
            if (east.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 18);
            }
            if (south.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 27);
            }
            if (south.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 54);
            }
            south.setImage(sum);
        }
    }
}

