/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.xplatformeditor.FileExtensionFilter;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.imageSupport.WindowsBMPFilter;
import com.civfanatics.civ3.xplatformeditor.tabs.map.Coordinate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class MapFromBMPForm
extends JFrame {
    static Logger logger = Logger.getLogger("Map From BMP");
    JLabel lblValkommen = new JLabel("<HTML>Welcome.  This allows you to import BIQ maps from 16-colour or 256-colour bitmaps.<br>The width BMP should be 32 times the width desired in the BIQ, plus 32,<br>and the height should be 16 times the height desired in the BIQ, plus 16.<br>You can use the calculator from the previous window to calculate these dimensions.<br>Click the button to start.");
    JCheckBox chkAdvanced = new JCheckBox("Advanced Mode");
    JButton cmdSelectFile = new JButton("Select 16 or 256 color BMP File");
    String[] bmpExtension = new String[]{"bmp", "BMP"};
    FileExtensionFilter bmpFilter = new FileExtensionFilter(this.bmpExtension, "BMP files");
    JFileChooser jfc = Main.jfcBMPChooser;
    GridBagConstraints c = new GridBagConstraints();
    WindowsBMPFilter bitmap = null;
    Color[] paletteColors = new Color[1];
    private JTextField[] colorFields;
    private JComboBox[] mapTo;
    DefaultComboBoxModel[] mdlMapToModel;
    public static int WATER_DOMINANT = 0;
    public static int GRASSLAND_DOMINANT = 1;
    public static int PLAINS_DOMINANT = 2;
    public static int DESERT_DOMINANT = 3;
    public static int TUNDRA_DOMINANT = 4;
    public static int FOREST_DOMINANT = 5;
    public static int JUNGLE_DOMINANT = 6;
    public static int HILL_DOMINANT = 7;
    public static int MOUNTAIN_DOMINANT = 8;
    public static int MARSH_DOMINANT = 9;
    public static int VOLCANO_DOMINANT = 10;
    public static int FLOOD_PLAIN_DOMINANT = 11;
    public static int PLAINS_FOREST = 12;
    public static int TUNDRA_FOREST = 13;
    public static int PINE_FOREST = 14;
    public static int TUNDRA_PINE_FOREST = 15;
    public static int PLAINS_PINE_FOREST = 16;
    public static int SNOW_MOUNTAINS = 17;
    public static int PLAINS_JUNGLE = 18;
    public static int TUNDRA_JUNGLE = 19;
    public static int NUM_TERR_CHOICES = 16;
    public static String[] terrainNames = new String[]{"Water", "Grassland", "Plains", "Desert", "Tundra", "Forest", "Jungle", "Hills", "Mountains", "Marsh", "Volcano", "Flood Plain", "Plains Forest", "Tundra Forest", "Pine Forest", "Tundra Pine Forest", "Plains Pine Forest", "Snow-Capped Mountains", "Plains Jungle", "Tundra Jungle"};
    private int paletteSize = 0;
    private int[] mappings;
    JButton cmdShazam = new JButton("Create!");
    private int mapHeight = 0;
    private int mapWidth = 0;
    int[][] dominantTerrain;
    JPanel panel = new JPanel();
    JScrollPane scrollPane = new JScrollPane(this.panel);

    public MapFromBMPForm() {
        this.add(this.scrollPane);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MapFromBMPForm.this.bitmap = null;
                Runtime.getRuntime().gc();
            }
        });
        this.setTitle("Import Map From BMP");
        this.jfc.setFileFilter(this.bmpFilter);
        this.panel.setLayout(new GridBagLayout());
        this.c.gridy = 0;
        this.c.gridx = 0;
        this.c.gridwidth = 2;
        this.c.gridheight = 1;
        this.c.weighty = 0.3;
        this.c.weightx = 0.1;
        this.c.fill = 2;
        this.panel.add((Component)this.lblValkommen, this.c);
        this.cmdSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapFromBMPForm.this.cmdSelectFileActionPerformed();
            }
        });
        this.c.gridy = 1;
        this.c.gridx = 0;
        this.c.gridwidth = 1;
        this.c.weighty = 0.1;
        this.panel.add((Component)this.cmdSelectFile, this.c);
        this.chkAdvanced.setVisible(false);
        ++this.c.gridy;
        this.panel.add((Component)this.chkAdvanced, this.c);
        this.setMaximumSize(new Dimension(1680, 1050));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmdSelectFileActionPerformed() {
        int response = this.jfc.showOpenDialog(null);
        if (response == 0) {
            String fileName = "";
            try {
                fileName = this.jfc.getSelectedFile().getCanonicalPath();
                Main.settings.bmpDir = this.jfc.getSelectedFile().getPath();
            }
            catch (IOException e) {
                logger.error("IOException when getting canonical path", e);
            }
            this.bitmap = new WindowsBMPFilter(fileName);
            try {
                this.setTitle("Importing BMP........");
                this.bitmap.processFile(false);
            }
            catch (OutOfMemoryError e) {
                logger.error("Out of memory", e);
                logger.error("Memory in use: " + Runtime.getRuntime().totalMemory() / 1024L + " KB");
                logger.error("Memory available: " + Runtime.getRuntime().maxMemory() / 1024L + " KB");
                JOptionPane.showMessageDialog(null, "<html>Out of memory.  This happened while importing the bitmap, and is is less than ideal.<br>Maybe the bitmap is too big to handle.<br>Memory in use was " + Runtime.getRuntime().totalMemory() / 1024L + " KB out of " + Runtime.getRuntime().maxMemory() / 1024L + " KB available.</html>", "Out of memory", 0);
                return;
            }
            finally {
                this.setTitle("Import Map From BMP");
                System.out.println("Reached finally after processing file");
            }
            if (this.bitmap.getBitsPerPixel() != 4 && this.bitmap.getBitsPerPixel() != 8) {
                JOptionPane.showMessageDialog(null, "The bitmap chosen must be a 16-colour  or 256-colour bitmap, but this one is a " + (int)Math.pow(2.0, this.bitmap.getBitsPerPixel()) + " colour bitmap.  You can shrink/expand the palette with the GIMP.");
                this.bitmap = null;
                return;
            }
            boolean keepGoing = this.checkWidthAndHeight();
            if (!keepGoing) {
                return;
            }
            this.paletteColors = this.bitmap.getPaletteColors();
            this.paletteSize = this.bitmap.getPaletteSize();
            this.colorFields = new JTextField[this.paletteSize];
            this.mapTo = new JComboBox[this.paletteSize];
            this.mdlMapToModel = new DefaultComboBoxModel[this.paletteSize];
            this.mappings = new int[this.paletteSize];
            for (int i = 0; i < this.paletteSize; ++i) {
                this.colorFields[i] = new JTextField("");
                this.colorFields[i].setBackground(this.paletteColors[i]);
                this.colorFields[i].setForeground(this.paletteColors[i].brighter().brighter());
                this.colorFields[i].setEnabled(false);
                this.colorFields[i].setText("Color: (" + this.paletteColors[i].getRed() + ", " + this.paletteColors[i].getGreen() + ", " + this.paletteColors[i].getBlue() + ")");
                this.mapTo[i] = new JComboBox();
                this.mdlMapToModel[i] = new DefaultComboBoxModel();
                this.mdlMapToModel[i].addElement("Water");
                this.mdlMapToModel[i].addElement("Grassland");
                this.mdlMapToModel[i].addElement("Plains");
                this.mdlMapToModel[i].addElement("Desert");
                this.mdlMapToModel[i].addElement("Tundra");
                this.mdlMapToModel[i].addElement("Forest");
                this.mdlMapToModel[i].addElement("Jungle");
                this.mdlMapToModel[i].addElement("Hills");
                this.mdlMapToModel[i].addElement("Mountains");
                this.mdlMapToModel[i].addElement("Marsh");
                this.mdlMapToModel[i].addElement("Volcano");
                this.mdlMapToModel[i].addElement("Flood Plain");
                this.mdlMapToModel[i].addElement("Plains Forest");
                this.mdlMapToModel[i].addElement("Tundra Forest");
                this.mdlMapToModel[i].addElement("Pine Forest");
                this.mdlMapToModel[i].addElement("Tundra Pine Forest");
                this.mapTo[i].setModel(this.mdlMapToModel[i]);
                ++this.c.gridy;
                this.c.gridwidth = 1;
                this.c.gridx = 0;
                this.panel.add((Component)this.colorFields[i], this.c);
                ++this.c.gridx;
                System.out.println("Adding to Gooey");
                this.panel.add((Component)this.mapTo[i], this.c);
            }
            try {
                Scanner s = new Scanner(new File("bmpcolors.txt"));
                while (s.hasNextLine()) {
                    String str = s.nextLine();
                    if (!str.contains(",")) continue;
                    String[] sections = str.split(",");
                    int red = Integer.parseInt(sections[0]);
                    int green = Integer.parseInt(sections[1]);
                    int blue = Integer.parseInt(sections[2]);
                    int match = Integer.parseInt(sections[3]);
                    for (int i = 0; i < this.paletteSize; ++i) {
                        if (this.paletteColors[i].getRed() != red || this.paletteColors[i].getGreen() != green || this.paletteColors[i].getBlue() != blue || match >= NUM_TERR_CHOICES) continue;
                        this.mapTo[i].setSelectedIndex(match);
                    }
                }
                s.close();
            }
            catch (Exception e) {
                logger.error("Error when inputting color history data");
            }
            this.chkAdvanced.setVisible(true);
            this.chkAdvanced.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MapFromBMPForm.this.chkAdvancedMode();
                }
            });
            ++this.c.gridy;
            this.c.gridx = 0;
            this.panel.add((Component)this.cmdShazam, this.c);
            this.cmdShazam.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Instant startShazam = Instant.now();
                    MapFromBMPForm.this.cmdShazamAction();
                    Duration shazamTime = Duration.between(startShazam, Instant.now());
                    logger.info("Overall map creation time: " + shazamTime.toMillis() + " ms");
                }
            });
            this.cmdSelectFile.setEnabled(false);
            this.cmdSelectFile.setVisible(false);
            this.setPreferredSize(new Dimension(600, 900));
            this.pack();
        }
    }

    public static void main(String[] args) {
        new MapFromBMPForm().setVisible(true);
    }

    private void Shazam() {
        try {
            FileOutputStream fos = new FileOutputStream("bmpcolors.txt");
            String s = "";
            for (int i = 0; i < this.paletteSize; ++i) {
                s = "";
                s = s + this.paletteColors[i].getRed();
                s = s + ",";
                s = s + this.paletteColors[i].getGreen();
                s = s + ",";
                s = s + this.paletteColors[i].getBlue();
                s = s + ",";
                s = s + this.mapTo[i].getSelectedIndex();
                s = s + Main.newline;
                fos.write(s.getBytes());
            }
            fos.close();
        }
        catch (Exception e) {
            logger.error("Error when exporting color mappings", e);
        }
        int xCoordinate = 0;
        int yCoordinate = 0;
        this.dominantTerrain = new int[this.mapWidth][this.mapHeight];
        long start = System.nanoTime();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                Coordinate tile = new Coordinate();
                tile.x = xCoordinate;
                tile.y = yCoordinate;
                coordinates.add(tile);
                xCoordinate += 2;
            }
        }
        List dominantTerrains = coordinates.parallelStream().map(futureTile -> {
            int top = 0;
            int stepsDown = 0;
            int stepsOutwards = 0;
            int stepsDownCount = 0;
            int leftStart = 0;
            int rightStart = 0;
            int y = 0;
            int x1 = 0;
            int x2 = 0;
            if (logger.isDebugEnabled()) {
                logger.debug("X, Y is (" + futureTile.x + ", " + futureTile.y + ").  MapHeight is " + this.mapHeight);
            }
            stepsDown = 31;
            stepsOutwards = 31;
            top = futureTile.y * 16;
            leftStart = futureTile.x * 32 + 31;
            rightStart = leftStart + 1;
            int[] colorCount = new int[this.paletteSize];
            boolean firstAtThisLevel = false;
            while (stepsOutwards >= 0) {
                stepsDownCount = stepsDown;
                if (stepsDownCount == -1) {
                    stepsDownCount = 1;
                    firstAtThisLevel = false;
                }
                while (stepsDownCount >= 0) {
                    int colorAtThisPixel;
                    y = top + (31 - stepsDownCount);
                    x1 = leftStart - (31 - stepsOutwards);
                    x2 = -1;
                    int n = colorAtThisPixel = this.bitmap.getPaletteIndexAt(x1, y);
                    colorCount[n] = colorCount[n] + 1;
                    x2 = rightStart + (31 - stepsOutwards);
                    int n2 = colorAtThisPixel = this.bitmap.getPaletteIndexAt(x2, y);
                    colorCount[n2] = colorCount[n2] + 1;
                    --stepsDownCount;
                }
                if (!firstAtThisLevel) {
                    --stepsOutwards;
                    stepsDown -= 2;
                    firstAtThisLevel = true;
                    continue;
                }
                --stepsOutwards;
                firstAtThisLevel = false;
            }
            int[] dominantTerrainCount = new int[NUM_TERR_CHOICES];
            for (int i = 0; i < this.paletteSize; ++i) {
                int n = this.mappings[i];
                dominantTerrainCount[n] = dominantTerrainCount[n] + colorCount[i];
            }
            int maxCount = 0;
            int maxIndex = -1;
            for (int i = 0; i < dominantTerrainCount.length; ++i) {
                if (dominantTerrainCount[i] <= maxCount) continue;
                maxCount = dominantTerrainCount[i];
                maxIndex = i;
            }
            return maxIndex;
        }).collect(Collectors.toList());
        int i = 0;
        for (yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                this.dominantTerrain[xCoordinate][yCoordinate] = (Integer)dominantTerrains.get(i);
                ++i;
                xCoordinate += 2;
            }
        }
        long end = System.nanoTime();
        logger.info("Dominant terrain determination time: " + (end - start) / 1000000L + " ms");
    }

    private void cmdShazamAction() {
        for (int i = 0; i < this.mappings.length; ++i) {
            this.mappings[i] = this.mapTo[i].getSelectedIndex();
        }
        int bmpWidth = this.bitmap.getWidth();
        int bmpHeight = this.bitmap.getHeight();
        bmpHeight -= 16;
        if ((bmpWidth -= 32) % 32 != 0) {
            logger.error("Bitmap width - 32 is not a multiple of 32");
            JOptionPane.showMessageDialog(null, "The bitmap width of " + this.bitmap.getWidth() + " minus 32, is not a multiple of 32");
        }
        if (bmpHeight % 16 != 0) {
            logger.error("Bitmap height - 16 is not a multiple of 16");
            JOptionPane.showMessageDialog(null, "The bitmap height of " + this.bitmap.getHeight() + " minus 16, is not a multiple of 16");
        }
        this.mapWidth = bmpWidth / 32;
        this.mapHeight = bmpHeight / 16;
        logger.info("Map width calculated as " + this.mapWidth + " based on bitmap width of " + this.bitmap.getWidth());
        logger.info("Map height calculated as " + this.mapHeight + " based on bitmap height of " + this.bitmap.getHeight());
        this.setTitle("Reticulating splines...");
        this.Shazam();
        this.printOutStats();
        this.setTitle("Creating map data...");
        Instant startBIQ = Instant.now();
        this.createBIQMap();
        Instant endBIQ = Instant.now();
        Duration biqTime = Duration.between(startBIQ, endBIQ);
        logger.info("BIQ creation time: " + biqTime.toMillis() + " ms");
        this.setTitle("Map created!");
        Main.enableMapTab();
        Main.pnlTabs.biqcTab.updateCheckBoxes();
        Main.pnlTabs.gameTab.sendMapData(Main.biqFile.get((int)Main.biqIndex).worldCharacteristic);
    }

    private void printOutTerrains() {
        for (int yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int xCoordinate;
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                String terrainName = terrainNames[this.dominantTerrain[xCoordinate][yCoordinate]];
                System.out.println("Dominant terrain at (" + xCoordinate + ", " + yCoordinate + ") is " + terrainName + ".");
                xCoordinate += 2;
            }
        }
    }

    private void printOutStats() {
        int[] count = new int[NUM_TERR_CHOICES];
        for (int yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int xCoordinate;
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                int terr;
                int n2 = terr = this.dominantTerrain[xCoordinate][yCoordinate];
                count[n2] = count[n2] + 1;
                xCoordinate += 2;
            }
        }
        for (int i = 0; i < count.length; ++i) {
            double percent = (double)count[i] * 100.0 / ((double)(this.mapWidth * this.mapHeight) * 0.5);
            String percentFormat = String.format("0.00", percent);
            if (this.chkAdvanced.isSelected()) continue;
            System.out.println("There were " + count[i] + " tiles of type " + terrainNames[i] + " for a percentage of " + percentFormat + "(" + percent + ")");
        }
    }

    private void createBIQMap() {
        int xCoordinate;
        int yCoordinate;
        IO biqFile = Main.biqFile.get(0);
        biqFile.createMap(this.mapWidth, this.mapHeight, 0);
        for (yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                int terrain = this.dominantTerrain[xCoordinate][yCoordinate];
                if (this.chkAdvanced.isSelected()) {
                    terrain %= 18;
                }
                int base = 0;
                int real = 0;
                boolean pine = false;
                boolean snow = false;
                if (terrain == WATER_DOMINANT) {
                    base = 11;
                    real = 11;
                } else if (terrain == GRASSLAND_DOMINANT) {
                    base = 2;
                    real = 2;
                } else if (terrain == PLAINS_DOMINANT) {
                    base = 1;
                    real = 1;
                } else if (terrain == DESERT_DOMINANT) {
                    base = 0;
                    real = 0;
                } else if (terrain == TUNDRA_DOMINANT) {
                    base = 3;
                    real = 3;
                } else if (terrain == FOREST_DOMINANT) {
                    base = 2;
                    real = 7;
                } else if (terrain == JUNGLE_DOMINANT) {
                    base = 2;
                    real = 8;
                } else if (terrain == HILL_DOMINANT) {
                    base = 2;
                    real = 5;
                } else if (terrain == MOUNTAIN_DOMINANT) {
                    base = 2;
                    real = 6;
                } else if (terrain == MARSH_DOMINANT) {
                    base = 2;
                    real = 9;
                } else if (terrain == VOLCANO_DOMINANT) {
                    base = 2;
                    real = 10;
                } else if (terrain == FLOOD_PLAIN_DOMINANT) {
                    base = 0;
                    real = 4;
                } else if (terrain == PLAINS_FOREST) {
                    base = 1;
                    real = 7;
                } else if (terrain == TUNDRA_FOREST) {
                    base = 3;
                    real = 7;
                } else if (terrain == PINE_FOREST) {
                    base = 2;
                    real = 7;
                    pine = true;
                } else if (terrain == TUNDRA_PINE_FOREST) {
                    base = 3;
                    real = 7;
                    pine = true;
                } else if (terrain == PLAINS_PINE_FOREST) {
                    base = 1;
                    real = 7;
                    pine = true;
                } else if (terrain == SNOW_MOUNTAINS) {
                    base = 2;
                    real = 6;
                    snow = true;
                } else if (terrain == PLAINS_JUNGLE) {
                    base = 1;
                    real = 8;
                } else if (terrain == TUNDRA_JUNGLE) {
                    base = 3;
                    real = 8;
                }
                int tileIndex = biqFile.calculateTileIndex(xCoordinate, yCoordinate);
                biqFile.tile.get(tileIndex).setTerrain(base, real);
                biqFile.tile.get(tileIndex).setPine(pine);
                biqFile.tile.get(tileIndex).setSnow(snow);
                if (this.chkAdvanced.isSelected() && this.dominantTerrain[xCoordinate][yCoordinate] >= 18) {
                    biqFile.tile.get(tileIndex).setLandmark(true);
                }
                xCoordinate += 2;
            }
        }
        this.coastToSea();
        this.seaToOcean();
        this.resolveTundra();
        for (yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                this.recalculateFileAndIndex(xCoordinate, yCoordinate);
                xCoordinate += 2;
            }
        }
    }

    private void recalculateFileAndIndex(int x, int y) {
        IO biq = Main.biqFile.get(0);
        List<TILE> tile = biq.tile;
        int southID = biq.calculateTileIndex(x, y);
        TILE south = southID == -1 ? null : tile.get(southID);
        int westID = biq.calculateTileIndex(x - 1, y - 1);
        TILE west = westID == -1 ? null : tile.get(westID);
        int northID = biq.calculateTileIndex(x, y - 2);
        TILE north = northID == -1 ? null : tile.get(northID);
        int eastID = biq.calculateTileIndex(x + 1, y - 1);
        TILE east = eastID == -1 ? null : tile.get(eastID);
        int terr1 = 0;
        byte terr2 = 0;
        byte terr3 = 0;
        boolean needToCalculateImage = true;
        if (south == null) {
            south = new TILE(biq);
            south.setRealTerrain(11);
            south.setBaseTerrain(11);
            south.setUpNibbles();
        }
        if (east == null) {
            east = new TILE(biq);
            east.setRealTerrain(11);
            east.setBaseTerrain(11);
            east.setUpNibbles();
        }
        if (north == null) {
            north = new TILE(biq);
            north.setRealTerrain(11);
            north.setBaseTerrain(11);
            north.setUpNibbles();
        }
        if (west == null) {
            west = new TILE(biq);
            west.setRealTerrain(11);
            west.setBaseTerrain(11);
            west.setUpNibbles();
        }
        if (south.getBaseTerrain() == 13 && east.getBaseTerrain() == 13 && west.getBaseTerrain() == 13 && north.getBaseTerrain() == 13) {
            south.setFile((byte)8);
            south.setImage((byte)0);
            needToCalculateImage = false;
        } else if (south.getBaseTerrain() == 12 && east.getBaseTerrain() == 12 && west.getBaseTerrain() == 12 && north.getBaseTerrain() == 12) {
            south.setFile((byte)7);
            south.setImage((byte)0);
            needToCalculateImage = false;
        } else if (south.getBaseTerrain() == 3 || east.getBaseTerrain() == 3 || west.getBaseTerrain() == 3 || north.getBaseTerrain() == 3) {
            south.setFile((byte)0);
            terr1 = 3;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 12 || east.getBaseTerrain() == 12 || west.getBaseTerrain() == 12 || north.getBaseTerrain() == 12) {
            south.setFile((byte)6);
            terr1 = 11;
            terr2 = 12;
            terr3 = 13;
        } else if (south.getBaseTerrain() != 11 && east.getBaseTerrain() != 11 && west.getBaseTerrain() != 11 && north.getBaseTerrain() != 11) {
            south.setFile((byte)4);
            terr1 = 0;
            terr2 = 2;
            terr3 = 1;
        } else if (south.getBaseTerrain() == 0 || east.getBaseTerrain() == 0 || west.getBaseTerrain() == 0 || north.getBaseTerrain() == 0) {
            if (south.getBaseTerrain() == 1 || east.getBaseTerrain() == 1 || west.getBaseTerrain() == 1 || north.getBaseTerrain() == 1) {
                south.setFile((byte)3);
                terr1 = 0;
                terr2 = 1;
                terr3 = 11;
            } else if (south.getBaseTerrain() == 2 || east.getBaseTerrain() == 2 || west.getBaseTerrain() == 2 || north.getBaseTerrain() == 2) {
                south.setFile((byte)2);
                terr1 = 0;
                terr2 = 2;
                terr3 = 11;
            } else if (south.getBaseTerrain() == 11 || east.getBaseTerrain() == 11 || west.getBaseTerrain() == 11 || north.getBaseTerrain() == 11) {
                south.setFile((byte)2);
                terr1 = 0;
                terr2 = 1;
                terr3 = 11;
            } else {
                System.err.println("XKCD1.  X: " + x + ", Y: " + y + ", North: " + north.getBaseTerrain() + ", East: " + east.getBaseTerrain() + ", South: " + south.getBaseTerrain() + ", West: " + west.getBaseTerrain());
                JOptionPane.showMessageDialog(null, "Error XKCD, type 1 - error calculating terrain image file.  Please report.", "Error XKCD", 0);
            }
        } else if (south.getBaseTerrain() == 1 || east.getBaseTerrain() == 1 || west.getBaseTerrain() == 1 || north.getBaseTerrain() == 1) {
            south.setFile((byte)1);
            terr1 = 1;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 2 || east.getBaseTerrain() == 2 || west.getBaseTerrain() == 2 || north.getBaseTerrain() == 2) {
            south.setFile((byte)5);
            terr1 = 2;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 11 || east.getBaseTerrain() == 11 || west.getBaseTerrain() == 11 || north.getBaseTerrain() == 11) {
            south.setFile((byte)6);
            terr1 = 11;
            terr2 = 12;
            terr3 = 13;
        } else {
            System.err.println("XKCD2  X: " + x + ", Y: " + y + ", North: " + north.getBaseTerrain() + ", East: " + east.getBaseTerrain() + ", South: " + south.getBaseTerrain() + ", West: " + west.getBaseTerrain());
            JOptionPane.showMessageDialog(null, "Error XKCD, type 2 - error calculating terrain image file.  Please report.", "Error XKCD", 0);
        }
        if (needToCalculateImage) {
            byte sum = 0;
            if (north.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 1);
            }
            if (north.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 2);
            }
            if (west.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 3);
            }
            if (west.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 6);
            }
            if (east.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 9);
            }
            if (east.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 18);
            }
            if (south.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 27);
            }
            if (south.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 54);
            }
            south.setImage(sum);
        }
    }

    private void coastToSea() {
        IO biq = Main.biqFile.get(Main.biqIndex);
        for (int yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int xCoordinate;
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                int index = biq.calculateTileIndex(xCoordinate, yCoordinate);
                if (biq.tile.get(index).getBaseTerrain() == 11) {
                    ArrayList<Integer> surroundingTiles = biq.getSurroundingTiles(xCoordinate, yCoordinate);
                    boolean allCoast = true;
                    for (int i = 0; i < surroundingTiles.size(); ++i) {
                        byte terr = biq.tile.get((Integer)surroundingTiles.get(i)).getBaseTerrain();
                        if (terr == 11 || terr == 12) continue;
                        allCoast = false;
                    }
                    if (allCoast) {
                        biq.tile.get(index).setTerrain(12, 12);
                    }
                }
                xCoordinate += 2;
            }
        }
    }

    private void seaToOcean() {
        IO biq = Main.biqFile.get(Main.biqIndex);
        for (int yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int xCoordinate;
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                int index = biq.calculateTileIndex(xCoordinate, yCoordinate);
                if (biq.tile.get(index).getBaseTerrain() == 12) {
                    ArrayList<Integer> surroundingTiles = biq.getSurroundingTiles(xCoordinate, yCoordinate);
                    boolean allCoast = true;
                    for (int i = 0; i < surroundingTiles.size(); ++i) {
                        byte terr = biq.tile.get((Integer)surroundingTiles.get(i)).getBaseTerrain();
                        if (terr == 13 || terr == 12) continue;
                        allCoast = false;
                    }
                    if (allCoast) {
                        biq.tile.get(index).setTerrain(13, 13);
                    }
                }
                xCoordinate += 2;
            }
        }
    }

    private void resolveTundra() {
        IO biq = Main.biqFile.get(Main.biqIndex);
        int yCoordinate = 0;
        int xCoordinate = 0;
        for (yCoordinate = 0; yCoordinate < this.mapHeight; ++yCoordinate) {
            int n = xCoordinate = yCoordinate % 2 == 0 ? 0 : 1;
            while (xCoordinate < this.mapWidth) {
                this.recalculateFileAndIndex(xCoordinate, yCoordinate);
                int idx = biq.calculateTileIndex(xCoordinate, yCoordinate);
                if (biq.tile.get(idx).getBaseTerrain() == 3) {
                    ArrayList<Integer> neighbors = biq.getSurroundingTiles(xCoordinate, yCoordinate);
                    Iterator iterator = neighbors.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        byte terrain = biq.tile.get(i).getBaseTerrain();
                        if (terrain != 1 && terrain != 0) continue;
                        biq.tile.get(idx).setTerrain(2, 2);
                        break;
                    }
                }
                boolean hasGrassland = false;
                boolean hasPlains = false;
                boolean hasDesert = false;
                boolean hasCoast = false;
                int hasCount = 0;
                if (biq.tile.get(idx).getBaseTerrain() == 11) {
                    hasCoast = true;
                    hasCount = (byte)(hasCount + 1);
                } else if (biq.tile.get(idx).getBaseTerrain() == 0) {
                    hasDesert = true;
                    hasCount = (byte)(hasCount + 1);
                } else if (biq.tile.get(idx).getBaseTerrain() == 1) {
                    hasPlains = true;
                    hasCount = (byte)(hasCount + 1);
                } else if (biq.tile.get(idx).getBaseTerrain() == 2) {
                    hasGrassland = true;
                    hasCount = (byte)(hasCount + 1);
                }
                if (hasCount == 1) {
                    ArrayList<Integer> northTiles = biq.getNorthNENW(xCoordinate, yCoordinate);
                    Iterator iterator = northTiles.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        byte terrain = biq.tile.get(i).getRealTerrain();
                        if (terrain == 0 && !hasDesert) {
                            hasDesert = true;
                            hasCount = (byte)(hasCount + 1);
                        }
                        if (terrain == 1 && !hasPlains) {
                            hasPlains = true;
                            hasCount = (byte)(hasCount + 1);
                        }
                        if (terrain == 2 && !hasGrassland) {
                            hasGrassland = true;
                            hasCount = (byte)(hasCount + 1);
                        }
                        if (terrain != 11 || hasCoast) continue;
                        hasCoast = true;
                        hasCount = (byte)(hasCount + 1);
                    }
                }
                if (hasCount == 4) {
                    if (biq.tile.get(idx).getRealTerrain() == 0 || biq.tile.get(idx).getRealTerrain() == 2) {
                        biq.tile.get(idx).setTerrain(1, 1);
                    } else if (biq.tile.get(idx).getRealTerrain() == 1) {
                        biq.tile.get(idx).setTerrain(0, 0);
                    }
                }
                xCoordinate += 2;
            }
        }
    }

    private boolean checkWidthAndHeight() {
        boolean widthOK = true;
        boolean heightOK = true;
        int bmpWidth = this.bitmap.getWidth();
        int bmpHeight = this.bitmap.getHeight();
        int mapWidth = 0;
        int mapHeight = 0;
        bmpHeight -= 16;
        if ((bmpWidth -= 32) % 32 != 0) {
            widthOK = false;
        }
        if (bmpHeight % 16 != 0) {
            heightOK = false;
        }
        if (!widthOK || !heightOK) {
            JOptionPane.showMessageDialog(null, "<html>The width of the bitmap must be divisible by 32, and the height by 16, but this is not the case.<br>The width should be 32*Civ3MapWidth + 32, and the height should be 16*Civ3MapWidth + 16<br>Please modify the bitmap so this is the case.</html>");
            return false;
        }
        mapWidth = bmpWidth / 32;
        mapHeight = bmpHeight / 16;
        if (mapWidth % 2 == 1 || mapHeight % 2 == 1) {
            JOptionPane.showMessageDialog(null, "<html>Either the width of the height of the Civ3 map would be an odd number, which Civ3 doesn't allow.<br>The width should be 32*Civ3MapWidth + 32, and the height should be 16*Civ3MapWidth + 16<br>Please adjust the bitmap so the Civ3 map will have an even width and height.</html>");
            return false;
        }
        if (mapWidth * mapHeight / 2 > 65536) {
            JOptionPane.showMessageDialog(null, "<html>The bitmap is too big - the Civ3 map would have " + mapWidth * mapHeight / 2 + " tiles, which is bigger than the 65536 that Civ3 allows.<br>The width should be 32*Civ3MapWidth + 32, and the height should be 16*Civ3MapWidth + 16<br>Please make the bitmap smaller, so it can be used to create a Civ3 map.</html>");
            return false;
        }
        return true;
    }

    public void chkAdvancedMode() {
        this.chkAdvanced.setEnabled(false);
        NUM_TERR_CHOICES = 40;
        for (int i = 0; i < this.paletteSize; ++i) {
            this.mdlMapToModel[i].addElement("Plains Pine Forest");
            this.mdlMapToModel[i].addElement("Snow-Capped Mountains");
            this.mdlMapToModel[i].addElement("LM Water");
            this.mdlMapToModel[i].addElement("LM Grassland");
            this.mdlMapToModel[i].addElement("LM Plains");
            this.mdlMapToModel[i].addElement("LM Desert");
            this.mdlMapToModel[i].addElement("LM Tundra");
            this.mdlMapToModel[i].addElement("LM Forest");
            this.mdlMapToModel[i].addElement("LM Jungle");
            this.mdlMapToModel[i].addElement("LM Hills");
            this.mdlMapToModel[i].addElement("LM Mountains");
            this.mdlMapToModel[i].addElement("LM Marsh");
            this.mdlMapToModel[i].addElement("LM Volcano");
            this.mdlMapToModel[i].addElement("LM Flood Plain");
            this.mdlMapToModel[i].addElement("LM Plains Forest");
            this.mdlMapToModel[i].addElement("LM Tundra Forest");
            this.mdlMapToModel[i].addElement("LM Pine Forest");
            this.mdlMapToModel[i].addElement("LM Tundra Pine Forest");
            this.mdlMapToModel[i].addElement("LM Plains Pine Forest");
            this.mdlMapToModel[i].addElement("LM Snow-Capped Mountains");
        }
    }
}

