/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TILE;
import java.text.DecimalFormat;

public class MapStats {
    public static String calculateMapStats(IO biq) {
        int numDesert = 0;
        int numPlains = 0;
        int numGrassland = 0;
        int numTundra = 0;
        int numFloodplain = 0;
        int numHills = 0;
        int numMountains = 0;
        int numForest = 0;
        int numJungle = 0;
        int numMarsh = 0;
        int numVolcano = 0;
        int numCoast = 0;
        int numSea = 0;
        int numOcean = 0;
        int numBonusGrassland = 0;
        for (TILE tile : biq.tile) {
            byte terr = tile.getRealTerrain();
            switch (terr) {
                case 0: {
                    ++numDesert;
                    break;
                }
                case 1: {
                    ++numPlains;
                    break;
                }
                case 2: {
                    ++numGrassland;
                    if (!tile.hasBonusGrassland()) break;
                    ++numBonusGrassland;
                    break;
                }
                case 3: {
                    ++numTundra;
                    break;
                }
                case 4: {
                    ++numFloodplain;
                    break;
                }
                case 5: {
                    ++numHills;
                    break;
                }
                case 6: {
                    ++numMountains;
                    break;
                }
                case 7: {
                    ++numForest;
                    break;
                }
                case 8: {
                    ++numJungle;
                    break;
                }
                case 9: {
                    ++numMarsh;
                    break;
                }
                case 10: {
                    ++numVolcano;
                    break;
                }
                case 11: {
                    ++numCoast;
                    break;
                }
                case 12: {
                    ++numSea;
                    break;
                }
                case 13: {
                    ++numOcean;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Terrain Statistics\n\n");
        double totalTiles = biq.tile.size();
        DecimalFormat df = new DecimalFormat("0.0%");
        sb.append("Total tiles: " + biq.tile.size()).append("\n\n");
        sb.append("Desert tiles: " + numDesert).append(" (").append(df.format((double)numDesert / totalTiles)).append(")\n");
        sb.append("Plains tiles: " + numPlains).append(" (").append(df.format((double)numPlains / totalTiles)).append(")\n");
        sb.append("Grassland tiles: " + numGrassland).append(" (").append(df.format((double)numGrassland / totalTiles)).append(")\n");
        sb.append("  Bonus Grassland tiles: " + numBonusGrassland).append(" (").append(df.format((double)numBonusGrassland / totalTiles)).append(")\n");
        sb.append("  Bonus as % of Grassland: " + df.format((double)numBonusGrassland / ((double)numGrassland + 0.0))).append("\n");
        sb.append("Tundra tiles: " + numTundra).append(" (").append(df.format((double)numTundra / totalTiles)).append(")\n");
        sb.append("Floodplain tiles: " + numFloodplain).append(" (").append(df.format((double)numFloodplain / totalTiles)).append(")\n");
        sb.append("Hills tiles: " + numHills).append(" (").append(df.format((double)numHills / totalTiles)).append(")\n");
        sb.append("Mountains tiles: " + numMountains).append(" (").append(df.format((double)numMountains / totalTiles)).append(")\n");
        sb.append("Forest tiles: " + numForest).append(" (").append(df.format((double)numForest / totalTiles)).append(")\n");
        sb.append("Jungle tiles: " + numJungle).append(" (").append(df.format((double)numJungle / totalTiles)).append(")\n");
        sb.append("Marsh tiles: " + numMarsh).append(" (").append(df.format((double)numMarsh / totalTiles)).append(")\n");
        sb.append("Volcano tiles: " + numVolcano).append(" (").append(df.format((double)numVolcano / totalTiles)).append(")\n");
        sb.append("Coast tiles: " + numCoast).append(" (").append(df.format((double)numCoast / totalTiles)).append(")\n");
        sb.append("Sea tiles: " + numSea).append(" (").append(df.format((double)numSea / totalTiles)).append(")\n");
        sb.append("Ocean tiles: " + numOcean).append(" (").append(df.format((double)numOcean / totalTiles)).append(")\n");
        return sb.toString();
    }
}

