/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.tabs.map.MapDirection;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MapUtils {
    static Logger logger = Logger.getLogger(MapUtils.class);

    public static MapDirection determineRiverDirection(int xOffset, int yOffset, int riverX, int riverY) {
        logger.info("mapDir xOffset: " + xOffset);
        logger.info("mapDir yOffset: " + yOffset);
        logger.info("riverX, riverY: " + riverX + ", " + riverY);
        int riverProximityMax = Main.settings.riverProximityMax;
        int riverCornerRadius = Main.settings.riverCornerRadius;
        if (Math.abs(2 * yOffset + (xOffset - 64)) < riverProximityMax && yOffset > riverCornerRadius >>> 1 && xOffset > riverCornerRadius) {
            logger.warn("NW river toggle on " + riverX + ", " + riverY);
            return MapDirection.NORTHWEST;
        }
        if (Math.abs(-2 * yOffset + (xOffset - 64)) < riverProximityMax && xOffset < 128 - riverCornerRadius && yOffset > riverCornerRadius >>> 1) {
            logger.warn("NE river toggle on " + riverX + ", " + riverY);
            return MapDirection.NORTHEAST;
        }
        if (Math.abs(-2 * (yOffset - 32) + xOffset) < riverProximityMax && xOffset > riverCornerRadius && yOffset < 64 - riverCornerRadius) {
            logger.warn("SW river toggle on " + riverX + ", " + riverY);
            return MapDirection.SOUTHWEST;
        }
        if (Math.abs(2 * (yOffset - 64) + (xOffset - 64)) < riverProximityMax && xOffset < 128 - riverCornerRadius && yOffset < 64 - riverCornerRadius) {
            logger.warn("SE river toggle on " + riverX + ", " + riverY);
            return MapDirection.SOUTHEAST;
        }
        return MapDirection.NONE;
    }

    public static void recalculateFileAndIndex(IO biq, int x, int y) {
        int southID = biq.calculateTileIndex(x, y);
        TILE south = southID == -1 ? null : biq.tile.get(southID);
        int westID = biq.calculateTileIndex(x - 1, y - 1);
        TILE west = westID == -1 ? null : biq.tile.get(westID);
        int northID = biq.calculateTileIndex(x, y - 2);
        TILE north = northID == -1 ? null : biq.tile.get(northID);
        int eastID = biq.calculateTileIndex(x + 1, y - 1);
        TILE east = eastID == -1 ? null : biq.tile.get(eastID);
        int terr1 = 0;
        byte terr2 = 0;
        byte terr3 = 0;
        boolean needToCalculateImage = true;
        if (south == null) {
            south = new TILE(biq.version);
            south.setBaseTerrain(11);
            south.setRealTerrain(11);
            south.setUpNibbles();
        }
        if (east == null) {
            east = new TILE(biq.version);
            east.setBaseTerrain(11);
            east.setRealTerrain(11);
            east.setUpNibbles();
        }
        if (north == null) {
            north = new TILE(biq.version);
            north.setBaseTerrain(11);
            north.setRealTerrain(11);
            north.setUpNibbles();
        }
        if (west == null) {
            west = new TILE(biq.version);
            west.setBaseTerrain(11);
            west.setRealTerrain(11);
            west.setUpNibbles();
        }
        if (south.getBaseTerrain() == 13 && east.getBaseTerrain() == 13 && west.getBaseTerrain() == 13 && north.getBaseTerrain() == 13) {
            if (logger.isDebugEnabled()) {
                logger.debug("WOOO");
            }
            south.setFile((byte)8);
            south.setImage((byte)0);
            needToCalculateImage = false;
        } else if (south.getBaseTerrain() == 12 && east.getBaseTerrain() == 12 && west.getBaseTerrain() == 12 && north.getBaseTerrain() == 12) {
            if (logger.isDebugEnabled()) {
                logger.debug("WSSS");
            }
            south.setFile((byte)7);
            south.setImage((byte)0);
            needToCalculateImage = false;
        } else if (south.getBaseTerrain() == 3 || east.getBaseTerrain() == 3 || west.getBaseTerrain() == 3 || north.getBaseTerrain() == 3) {
            if (logger.isDebugEnabled()) {
                logger.debug("XTGC");
            }
            south.setFile((byte)0);
            terr1 = 3;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 12 || east.getBaseTerrain() == 12 || west.getBaseTerrain() == 12 || north.getBaseTerrain() == 12) {
            if (logger.isDebugEnabled()) {
                logger.debug("WCSO");
            }
            south.setFile((byte)6);
            terr1 = 11;
            terr2 = 12;
            terr3 = 13;
        } else if (south.getBaseTerrain() != 11 && east.getBaseTerrain() != 11 && west.getBaseTerrain() != 11 && north.getBaseTerrain() != 11) {
            if (logger.isDebugEnabled()) {
                logger.debug("XDGP");
            }
            south.setFile((byte)4);
            terr1 = 0;
            terr2 = 2;
            terr3 = 1;
        } else if (south.getBaseTerrain() == 0 || east.getBaseTerrain() == 0 || west.getBaseTerrain() == 0 || north.getBaseTerrain() == 0) {
            if (south.getBaseTerrain() == 1 || east.getBaseTerrain() == 1 || west.getBaseTerrain() == 1 || north.getBaseTerrain() == 1) {
                if (logger.isDebugEnabled()) {
                    logger.debug("XDPC");
                }
                south.setFile((byte)3);
                terr1 = 0;
                terr2 = 1;
                terr3 = 11;
            } else if (south.getBaseTerrain() == 2 || east.getBaseTerrain() == 2 || west.getBaseTerrain() == 2 || north.getBaseTerrain() == 2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("XDGC");
                }
                south.setFile((byte)2);
                terr1 = 0;
                terr2 = 2;
                terr3 = 11;
            } else if (south.getBaseTerrain() == 11 || east.getBaseTerrain() == 11 || west.getBaseTerrain() == 11 || north.getBaseTerrain() == 11) {
                if (logger.isDebugEnabled()) {
                    logger.debug("XDPC");
                }
                south.setFile((byte)2);
                terr1 = 0;
                terr2 = 1;
                terr3 = 11;
            } else {
                logger.error("XKCD1.  X: " + x + ", Y: " + y + ", North: " + north.getBaseTerrain() + ", East: " + east.getBaseTerrain() + ", South: " + south.getBaseTerrain() + ", West: " + west.getBaseTerrain());
                JOptionPane.showMessageDialog(null, "Error XKCD, type 1 - error calculating terrain image file.  Please report.", "Error XKCD", 0);
            }
        } else if (south.getBaseTerrain() == 1 || east.getBaseTerrain() == 1 || west.getBaseTerrain() == 1 || north.getBaseTerrain() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug("XPGC");
            }
            south.setFile((byte)1);
            terr1 = 1;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 2 || east.getBaseTerrain() == 2 || west.getBaseTerrain() == 2 || north.getBaseTerrain() == 2) {
            if (logger.isDebugEnabled()) {
                logger.debug("XGGC");
            }
            south.setFile((byte)5);
            terr1 = 2;
            terr2 = 2;
            terr3 = 11;
        } else if (south.getBaseTerrain() == 11 || east.getBaseTerrain() == 11 || west.getBaseTerrain() == 11 || north.getBaseTerrain() == 11) {
            if (logger.isDebugEnabled()) {
                logger.debug("WSCO Final");
            }
            south.setFile((byte)6);
            terr1 = 11;
            terr2 = 12;
            terr3 = 13;
        } else {
            logger.error("XKCD2  X: " + x + ", Y: " + y + ", North: " + north.getBaseTerrain() + ", East: " + east.getBaseTerrain() + ", South: " + south.getBaseTerrain() + ", West: " + west.getBaseTerrain());
            JOptionPane.showMessageDialog(null, "Error XKCD, type 2 - error calculating terrain image file.  Please report.", "Error XKCD", 0);
        }
        if (needToCalculateImage) {
            if (logger.isDebugEnabled()) {
                logger.debug("Calculating image");
                logger.debug("north real: " + north.getBaseTerrain());
                logger.debug("west real: " + west.getBaseTerrain());
                logger.debug("east real: " + east.getBaseTerrain());
                logger.debug("south real: " + south.getBaseTerrain());
            }
            byte sum = 0;
            if (north.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 1);
            }
            if (north.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 2);
            }
            if (west.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 3);
            }
            if (west.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 6);
            }
            if (east.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 9);
            }
            if (east.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 18);
            }
            if (south.getBaseTerrain() == terr2) {
                sum = (byte)(sum + 27);
            }
            if (south.getBaseTerrain() == terr3) {
                sum = (byte)(sum + 54);
            }
            south.setImage(sum);
        }
    }

    public static boolean validChangeOnTiles(IO biq, int one, int two, int three, int four) {
        TILE tileOne = one == -1 ? null : biq.tile.get(one);
        TILE tileTwo = two == -1 ? null : biq.tile.get(two);
        TILE tileThree = three == -1 ? null : biq.tile.get(three);
        TILE tileFour = four == -1 ? null : biq.tile.get(four);
        TILE[] tiles = new TILE[]{tileOne, tileTwo, tileThree, tileFour};
        boolean seaOrOcean = false;
        for (TILE t : tiles) {
            if (t == null || t.getBaseTerrain() < 12) continue;
            seaOrOcean = true;
            break;
        }
        if (seaOrOcean) {
            for (TILE t : tiles) {
                if (t == null || t.getBaseTerrain() >= 11) continue;
                return false;
            }
            return true;
        }
        boolean tundra = false;
        for (TILE t : tiles) {
            if (t == null || t.getBaseTerrain() != 3) continue;
            tundra = true;
            break;
        }
        if (tundra) {
            for (TILE t : tiles) {
                if (t == null || t.getBaseTerrain() == 11 || t.getBaseTerrain() == 3 || t.getBaseTerrain() == 2) continue;
                return false;
            }
            return true;
        }
        boolean grassland = false;
        boolean desert = false;
        boolean plains = false;
        boolean coast = false;
        for (TILE t : tiles) {
            if (t != null && t.getBaseTerrain() == 2) {
                grassland = true;
            }
            if (t != null && t.getBaseTerrain() == 0) {
                desert = true;
            }
            if (t != null && t.getBaseTerrain() == 1) {
                plains = true;
            }
            if (t == null || t.getBaseTerrain() != 11) continue;
            coast = true;
        }
        return !grassland || !plains || !desert || !coast;
    }
}

