/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import com.civfanatics.civ3.biqFile.EXPR;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.UNIT;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.ButtonInTableRenderer;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.JLabelInTableRenderer;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.JSpinnerInTableRenderer;
import com.civfanatics.civ3.xplatformeditor.Main;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class UnitNameWindow
extends JDialog {
    DefaultComboBoxModel mdlExprs = new DefaultComboBoxModel();
    JTable existingUnits;
    DefaultTableModel existingUnitModel = new DefaultTableModel();
    ButtonInTableRenderer buttonRenderer = new ButtonInTableRenderer();
    JSpinnerInTableRenderer spinnerRenderer = new JSpinnerInTableRenderer();
    JLabelInTableRenderer labelRenderer = new JLabelInTableRenderer();
    List<UNIT> units;
    List<EXPR> exprs;
    List<PRTO> prtos;
    JLabel[] unitTypes;
    JComboBox[] exprDropdowns;
    JTextField[] unitName;
    JComboBox[] aiStrategies;
    Map<Integer, Integer>[] comboToStrategy;
    JScrollPane scrUnits = new JScrollPane();
    JPanel pnlExistingUnits = new JPanel();
    GridBagLayout existingUnitsLayout = new GridBagLayout();

    public UnitNameWindow() {
        super((Frame)Main.mainMain, true);
        this.setLocationRelativeTo(Main.mainMain);
        this.setLocation(this.getParent().getWidth() / 2, this.getParent().getHeight() / 2);
        this.setTitle("Update Unit Names");
        this.scrUnits.setViewportView(this.pnlExistingUnits);
        this.pnlExistingUnits.setLayout(this.existingUnitsLayout);
        this.add(this.scrUnits);
        GridBagConstraints euc = new GridBagConstraints();
        euc.weighty = 0.1;
        euc.gridheight = 1;
        euc.gridwidth = 1;
        this.mdlExprs.addElement("Conscript");
        this.mdlExprs.addElement("Regular");
        this.mdlExprs.addElement("Veteran");
        this.mdlExprs.addElement("Elite");
        this.setPreferredSize(new Dimension(640, 480));
        this.pack();
    }

    public void setPrtoList(List<PRTO> prtos) {
        this.prtos = prtos;
    }

    public void setUnits(List<UNIT> units) {
        this.units = units;
        this.updateUI();
    }

    public void setExpr(List<EXPR> exprs) {
        this.exprs = exprs;
    }

    private void updateUI() {
        this.setTitle("Update Unit Names");
        this.pnlExistingUnits.setLayout(this.existingUnitsLayout);
        GridBagConstraints euc = new GridBagConstraints();
        euc.weighty = 0.1;
        euc.gridheight = 1;
        euc.gridwidth = 1;
        euc.gridx = 0;
        euc.gridy = 0;
        euc.weightx = 0.1;
        euc.fill = 2;
        euc.insets = new Insets(5, 5, 5, 5);
        JLabel typeLabel = new JLabel("Unit Type");
        JLabel exprLabel = new JLabel("Experience");
        JLabel nameLabel = new JLabel("Unit Name");
        this.pnlExistingUnits.add((Component)typeLabel, euc);
        ++euc.gridx;
        this.pnlExistingUnits.add((Component)exprLabel, euc);
        ++euc.gridx;
        this.pnlExistingUnits.add((Component)nameLabel, euc);
        euc.gridx = 0;
        ++euc.gridy;
        JScrollPane existingUnitsScroll = new JScrollPane();
        this.unitTypes = new JLabel[this.units.size()];
        this.exprDropdowns = new JComboBox[this.units.size()];
        this.unitName = new JTextField[this.units.size()];
        this.aiStrategies = new JComboBox[this.units.size()];
        this.comboToStrategy = new HashMap[this.units.size()];
        JButton[] deleteButton = new JButton[this.units.size()];
        for (int i = 0; i < this.units.size(); ++i) {
            UNIT unit = this.units.get(i);
            this.unitTypes[i] = new JLabel();
            this.unitTypes[i].setText(this.prtos.get(unit.getPRTONumber()).getName());
            this.exprDropdowns[i] = new JComboBox();
            DefaultComboBoxModel<String> mdl = new DefaultComboBoxModel<String>();
            for (EXPR expr : this.exprs) {
                mdl.addElement(expr.getName());
            }
            this.exprDropdowns[i].setModel(mdl);
            this.exprDropdowns[i].setSelectedIndex(unit.getExperienceLevel());
            this.unitName[i] = new JTextField();
            this.unitName[i].setText(unit.getPTWCustomName());
            deleteButton[i] = new JButton();
            deleteButton[i].setText("X");
            DefaultComboBoxModel<String> stratMdl = new DefaultComboBoxModel<String>();
            PRTO unitPrto = this.prtos.get(unit.getPRTONumber());
            this.comboToStrategy[i] = new HashMap<Integer, Integer>();
            HashMap<Integer, Integer> strategyToCombo = new HashMap<Integer, Integer>();
            Boolean[] strategySet = unitPrto.getAIStrategySet();
            int comboCount = 0;
            for (int s = 0; s < strategySet.length; ++s) {
                if (!strategySet[s].booleanValue()) continue;
                stratMdl.addElement(PRTO.strategyNames[s]);
                this.comboToStrategy[i].put(comboCount, s);
                strategyToCombo.put(s, comboCount);
                ++comboCount;
            }
            if (stratMdl.getSize() > 1) {
                stratMdl.addElement("Random");
                this.comboToStrategy[i].put(comboCount, -1);
                strategyToCombo.put(-1, comboCount);
            }
            this.aiStrategies[i] = new JComboBox();
            this.aiStrategies[i].setModel(stratMdl);
            if (unit.getAIStrategy() == -1) {
                this.aiStrategies[i].setSelectedItem("Random");
            } else {
                this.aiStrategies[i].setSelectedIndex((Integer)strategyToCombo.get(unit.getAIStrategy()));
            }
            this.pnlExistingUnits.add((Component)this.unitTypes[i], euc);
            ++euc.gridx;
            this.pnlExistingUnits.add((Component)this.exprDropdowns[i], euc);
            ++euc.gridx;
            this.pnlExistingUnits.add((Component)this.unitName[i], euc);
            ++euc.gridx;
            this.pnlExistingUnits.add((Component)this.aiStrategies[i], euc);
            euc.gridx = 0;
            ++euc.gridy;
        }
        euc.gridx = 1;
        JButton btnUpdate = new JButton("Update");
        euc.fill = 0;
        this.pnlExistingUnits.add((Component)btnUpdate, euc);
        ++euc.gridx;
        JButton btnCancel = new JButton("Cancel");
        this.pnlExistingUnits.add((Component)btnCancel, euc);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitNameWindow.this.cancelAction();
            }
        });
        btnUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UnitNameWindow.this.updateAction();
            }
        });
        this.pack();
    }

    private void cancelAction() {
        this.dispose();
    }

    private void updateAction() {
        for (int i = 0; i < this.exprDropdowns.length; ++i) {
            this.units.get(i).setExperienceLevel(this.exprDropdowns[i].getSelectedIndex());
            this.units.get(i).setPTWCustomName(this.unitName[i].getText());
            this.units.get(i).setAIStrategy(this.comboToStrategy[i].get(this.aiStrategies[i].getSelectedIndex()));
        }
        this.dispose();
    }

    public static void main(String[] args) {
        new UnitNameWindow().setVisible(true);
    }
}

