/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map;

import com.civfanatics.civ3.biqFile.CITY;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.Main;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class frmBuildingsInCities
extends JFrame {
    JList lstBuildings = new JList();
    JList lstCivilizations = new JList();
    JList lstPlayers = new JList();
    JList lstAffected = new JList();
    JScrollPane jsp1 = new JScrollPane(this.lstBuildings);
    JScrollPane jsp2 = new JScrollPane(this.lstCivilizations);
    JScrollPane jsp3 = new JScrollPane(this.lstPlayers);
    JScrollPane jsp4 = new JScrollPane(this.lstAffected);
    JLabel lblCitySize = new JLabel("Min size: ");
    JSpinner spnrCitySize = new JSpinner();
    JLabel lblMaxCitySize = new JLabel("Max size: ");
    JSpinner spnrMaxCitySize = new JSpinner();
    int minSize = 1;
    int maxSize = 99;
    SpinnerModel spnrMin = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
    SpinnerModel spnrMax = new SpinnerNumberModel(99, 1, Integer.MAX_VALUE, 1);
    DefaultListModel mdlBLDG = new DefaultListModel();
    DefaultListModel mdlCIV = new DefaultListModel();
    DefaultListModel mdlPLYR = new DefaultListModel();
    DefaultListModel mdlAffectedCities = new DefaultListModel();
    JCheckBox chkCoastal = new JCheckBox("Coastal only");
    JCheckBox chkLeaveExisting = new JCheckBox("Leave existing buildings");
    JLabel lblInstructions = new JLabel("Instructions");
    JButton cmdOK = new JButton("Add Buildings");
    JButton cmdCancel = new JButton("Cancel");
    IO biqFile;

    public frmBuildingsInCities(IO biq) {
        int i;
        this.setTitle("Add Buildings to Many Cities at Once");
        this.setIconImage(Main.icon);
        this.biqFile = biq;
        this.lblInstructions.setText("<html>This utility allows you to add buildings to many cities at once.  You can use the multi-select lists to choose buildings, and ownership of cities, as well as the coastal check box and<br>city size parameters.  The Affected City lists helps double-check which cities are affected.  Then Click OK to apply the changes.</html>");
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        GridBagConstraints g = new GridBagConstraints();
        for (i = 0; i < biq.buildings.size(); ++i) {
            this.mdlBLDG.addElement(biq.buildings.get(i).getName());
        }
        for (i = 0; i < biq.civilization.size(); ++i) {
            this.mdlCIV.addElement(biq.civilization.get(i).getName());
        }
        if (biq.hasCustomPlayerData()) {
            for (i = 0; i < biq.player.size(); ++i) {
                this.mdlPLYR.addElement("Player " + (i + 1));
            }
        }
        this.lstBuildings.setModel(this.mdlBLDG);
        this.lstPlayers.setModel(this.mdlPLYR);
        this.lstCivilizations.setModel(this.mdlCIV);
        this.lstAffected.setEnabled(false);
        this.lstAffected.setModel(this.mdlAffectedCities);
        g.fill = 1;
        g.insets = new Insets(2, 2, 2, 2);
        g.gridwidth = 8;
        g.gridheight = 1;
        g.gridx = 0;
        g.gridy = 0;
        g.weightx = 0.5;
        g.weighty = 0.05;
        this.getContentPane().add((Component)this.lblInstructions, g);
        this.spnrCitySize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                frmBuildingsInCities.this.minSize = (Integer)frmBuildingsInCities.this.spnrCitySize.getModel().getValue();
                frmBuildingsInCities.this.selectionChanged();
            }
        });
        this.spnrMaxCitySize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                frmBuildingsInCities.this.maxSize = (Integer)frmBuildingsInCities.this.spnrMaxCitySize.getModel().getValue();
                frmBuildingsInCities.this.selectionChanged();
            }
        });
        this.spnrCitySize.setModel(this.spnrMin);
        this.spnrMaxCitySize.setModel(this.spnrMax);
        ++g.gridy;
        g.gridwidth = 2;
        g.fill = 2;
        this.getContentPane().add((Component)this.chkCoastal, g);
        g.gridx += 2;
        g.gridwidth = 1;
        this.getContentPane().add((Component)this.lblCitySize, g);
        ++g.gridx;
        this.getContentPane().add((Component)this.spnrCitySize, g);
        ++g.gridx;
        g.gridwidth = 1;
        this.getContentPane().add((Component)this.lblMaxCitySize, g);
        ++g.gridx;
        g.gridwidth = 1;
        this.getContentPane().add((Component)this.spnrMaxCitySize, g);
        JLabel lblBuildings = new JLabel("Add Buildings");
        JLabel lblCivs = new JLabel("Owned By Civ");
        JLabel lblPlayers = new JLabel("Owned by Player");
        JLabel lblAffected = new JLabel("Affected Cities");
        g.weighty = 0.0;
        g.gridx = 0;
        ++g.gridy;
        g.weighty = 0.05;
        g.gridwidth = 2;
        this.getContentPane().add((Component)lblBuildings, g);
        g.gridx += 2;
        this.getContentPane().add((Component)lblCivs, g);
        g.gridx += 2;
        this.getContentPane().add((Component)lblPlayers, g);
        g.gridx += 2;
        this.getContentPane().add((Component)lblAffected, g);
        g.gridx = 0;
        ++g.gridy;
        g.weighty = 0.9;
        g.gridwidth = 2;
        g.fill = 1;
        this.getContentPane().add((Component)this.jsp1, g);
        g.gridx += 2;
        this.getContentPane().add((Component)this.jsp2, g);
        g.gridx += 2;
        this.getContentPane().add((Component)this.jsp3, g);
        g.gridx += 2;
        this.getContentPane().add((Component)this.jsp4, g);
        g.weighty = 0.0;
        g.gridx = 0;
        ++g.gridy;
        g.weighty = 0.05;
        g.gridwidth = 4;
        this.chkLeaveExisting.setSelected(true);
        this.getContentPane().add((Component)this.chkLeaveExisting, g);
        g.gridwidth = 1;
        g.gridx += 6;
        this.getContentPane().add((Component)this.cmdCancel, g);
        ++g.gridx;
        g.weightx = 0.75;
        this.getContentPane().add((Component)this.cmdOK, g);
        this.cmdCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmBuildingsInCities.this.cmdCancelAction();
            }
        });
        this.cmdOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmBuildingsInCities.this.cmdOKAction();
            }
        });
        this.lstCivilizations.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    frmBuildingsInCities.this.selectionChanged();
                }
            }
        });
        this.lstPlayers.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    frmBuildingsInCities.this.selectionChanged();
                }
            }
        });
        this.chkCoastal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frmBuildingsInCities.this.selectionChanged();
            }
        });
        this.pack();
    }

    private void cmdOKAction() {
        List<CITY> affected = this.findAffectedCities();
        int[] buildings = this.lstBuildings.getSelectedIndices();
        for (CITY city : affected) {
            int i;
            if (!this.chkLeaveExisting.isSelected()) {
                city.removeAllBuildings();
                for (i = 0; i < buildings.length; ++i) {
                    city.addBuilding(buildings[i]);
                }
                continue;
            }
            for (i = 0; i < buildings.length; ++i) {
                if (city.hasBuilding(buildings[i])) continue;
                city.addBuilding(buildings[i]);
            }
        }
        JOptionPane.showMessageDialog(this, "Applied changes", "Buildings Added", 1);
    }

    private void cmdCancelAction() {
        this.dispose();
    }

    private List<CITY> findAffectedCities() {
        LinkedList<CITY> affected = new LinkedList<CITY>();
        int[] civs = this.lstCivilizations.getSelectedIndices();
        Arrays.sort(civs);
        int[] players = this.lstPlayers.getSelectedIndices();
        Arrays.sort(players);
        boolean mustBeCoastal = this.chkCoastal.isSelected();
        for (CITY city : this.biqFile.city) {
            if (mustBeCoastal && !city.isCoastal() || city.getSize() < this.minSize || city.getSize() > this.maxSize) continue;
            if (city.getOwnerType() == 2) {
                if (Arrays.binarySearch(civs, city.getOwner()) < 0) continue;
                affected.add(city);
                continue;
            }
            if (city.getOwner() != 3 || Arrays.binarySearch(players, city.getOwner()) < 0) continue;
            affected.add(city);
        }
        return affected;
    }

    public static void main(String[] args) {
        new frmBuildingsInCities(null);
    }

    private void selectionChanged() {
        List<CITY> affected = this.findAffectedCities();
        this.mdlAffectedCities.clear();
        for (CITY c : affected) {
            this.mdlAffectedCities.addElement(c.getName());
        }
    }
}

