/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map.renderer;

import com.civfanatics.civ3.biqFile.CITY;
import com.civfanatics.civ3.biqFile.CLNY;
import com.civfanatics.civ3.biqFile.GOOD;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.biqFile.LEAD;
import com.civfanatics.civ3.biqFile.PRTO;
import com.civfanatics.civ3.biqFile.RACE;
import com.civfanatics.civ3.biqFile.RULE;
import com.civfanatics.civ3.biqFile.SLOC;
import com.civfanatics.civ3.biqFile.TILE;
import com.civfanatics.civ3.biqFile.UNIT;
import com.civfanatics.civ3.biqFile.WMAP;
import com.civfanatics.civ3.biqFile.util.MapDirection;
import com.civfanatics.civ3.xplatformeditor.Main;
import com.civfanatics.civ3.xplatformeditor.Settings;
import com.civfanatics.civ3.xplatformeditor.imageSupport.Units32Supplier;
import com.civfanatics.civ3.xplatformeditor.tabs.map.GraphicsAssets;
import com.civfanatics.civ3.xplatformeditor.tabs.map.renderer.Renderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ClassicRenderer
extends Renderer {
    Logger logger = Logger.getLogger(this.getClass());
    Random rnd = new Random();
    private List<TILE> tiles = null;
    private WMAP wmap = null;
    List<LEAD> player;
    List<CITY> city;
    List<SLOC> startingLocation;
    List<RACE> civ;
    List<GOOD> resource;
    List<CLNY> colony;
    List<RULE> rule;
    IO biq;
    Set encounteredExceptions = new HashSet();

    public ClassicRenderer(Image buffer, GraphicsAssets assets, IO biq) {
        BUFFERWIDTH = Main.mainMain.getWidth();
        this.assets = assets;
        this.biq = biq;
        this.buffer = (BufferedImage)buffer;
        this.tiles = biq.tile;
        this.wmap = biq.worldMap.get(0);
        this.player = biq.player;
        this.city = biq.city;
        this.startingLocation = biq.startingLocation;
        this.civ = biq.civilization;
        this.resource = biq.resource;
        this.colony = biq.colony;
        this.rule = biq.rule;
    }

    @Override
    public void setViewportSize(int x, int y) {
        BUFFERWIDTH = x;
        BUFFERHEIGHT = y;
        this.buffer = new BufferedImage(BUFFERWIDTH, BUFFERHEIGHT, 2);
    }

    @Override
    public void render() {
        if (this.buffer == null) {
            this.buffer = new BufferedImage(BUFFERWIDTH, BUFFERHEIGHT, 2);
        }
        Graphics2D bufferGraphics = this.buffer.createGraphics();
        int xIndex = 0;
        int yIndex = 0;
        ArrayList<TILE> visibleTiles = new ArrayList<TILE>();
        for (TILE t : this.tiles) {
            if (!this.tileIsVisible(t.xPos, t.yPos)) continue;
            visibleTiles.add(t);
        }
        for (TILE t : visibleTiles) {
            this.drawBaseTerrain(t, this.horizScrollOffset, this.vertScrollOffset, bufferGraphics);
        }
        if (this.assets.largeRuinGraphics && Main.settings.ruinsEnabled) {
            this.drawLargeRuinGraphics(visibleTiles, bufferGraphics);
        }
        this.drawTileElements(visibleTiles, bufferGraphics);
        this.drawStartingLocations(bufferGraphics);
        this.drawCityNames(bufferGraphics);
        if (Main.settings.gridEnabled) {
            this.drawGrid(xIndex, yIndex, bufferGraphics);
        }
    }

    private void drawLargeRuinGraphics(List<TILE> visibleTiles, Graphics bufferGraphics) {
        for (TILE t : visibleTiles) {
            this.drawRuins(t, this.horizScrollOffset, this.vertScrollOffset, bufferGraphics);
        }
    }

    private void drawTileElements(List<TILE> visibleTiles, Graphics bufferGraphics) {
        for (TILE t : visibleTiles) {
            try {
                this.drawTileElements(t, this.horizScrollOffset, this.vertScrollOffset, bufferGraphics);
            }
            catch (Exception ex) {
                this.logger.error("Unexpected exception while rendering", ex);
                this.alertUserToError(ex, t.xPos, t.yPos);
            }
        }
    }

    private void drawGrid(int xIndex, int yIndex, Graphics bufferGraphics) {
        xIndex = 0;
        yIndex = 0;
        for (int i = 0; i < this.tiles.size(); ++i) {
            if (this.tileIsVisible(xIndex, yIndex)) {
                this.drawGrid(i, xIndex, yIndex, this.horizScrollOffset, this.vertScrollOffset, bufferGraphics);
            }
            if ((xIndex += 2) <= this.wmap.width - 1) continue;
            xIndex = xIndex % 2 == 0 ? 1 : 0;
            ++yIndex;
        }
    }

    private void drawCityNames(Graphics bufferGraphics) {
        if (Main.settings.cityNamesEnabled) {
            for (int i = 0; i < this.city.size(); ++i) {
                int yIndex;
                int xIndex = this.city.get(i).getX();
                if (!this.tileIsVisible(xIndex, yIndex = this.city.get(i).getY())) continue;
                this.drawCityNames(i, xIndex, yIndex, this.horizScrollOffset, this.vertScrollOffset, bufferGraphics);
            }
        }
    }

    private void drawStartingLocations(Graphics bufferGraphics) {
        for (int i = 0; i < this.startingLocation.size(); ++i) {
            int xIndex = this.startingLocation.get(i).getX();
            int yIndex = this.startingLocation.get(i).getY();
            int tileLeftBoundary = xIndex * 64 - 64;
            int tileRightBoundary = yIndex * 32;
            if (!this.tileIsVisible(xIndex, yIndex)) continue;
            boolean cultGroup = false;
            int owner = -1;
            boolean cityAge = false;
            int color = 0;
            switch (this.startingLocation.get(i).getOwnerType()) {
                case 2: {
                    owner = this.startingLocation.get(i).getOwner();
                    color = this.civ.get(owner).getDefaultColor();
                    break;
                }
                case 3: {
                    if (this.startingLocation.get(i).getOwner() > -1) {
                        if (this.player == null) {
                            color = 0;
                            break;
                        }
                        owner = this.player.get((int)this.startingLocation.get((int)i).getOwner()).civ;
                        if (owner != -3 && owner != -2) {
                            color = this.civ.get(owner).getDefaultColor();
                            break;
                        }
                        color = 0;
                        break;
                    }
                    this.logger.warn("Warning! On owner of sloc " + this.startingLocation.get(i).toEnglish());
                    break;
                }
                default: {
                    this.logger.debug("Starting Location of unrecognized ownership: " + this.startingLocation.get(i).toEnglish());
                }
            }
            bufferGraphics.drawImage(this.assets.startLocGraphics[color], tileLeftBoundary - this.horizScrollOffset, tileRightBoundary - this.vertScrollOffset, null);
        }
    }

    private void drawBaseTerrain(TILE tile, int horizScrollPosition, int vertScrollPosition, Graphics canvas) {
        int tileLeftBoundary = tile.xPos * 64 - 64;
        int tileTopBoundary = tile.yPos * 32 - 32;
        int xDrawingCoordinate = tileLeftBoundary - horizScrollPosition;
        int yDrawingCoordinate = tileTopBoundary - vertScrollPosition;
        if (!tile.isLandmark()) {
            canvas.drawImage(this.assets.baseTerrainGraphics[tile.getFile()][tile.getImage()], xDrawingCoordinate, yDrawingCoordinate, null);
        } else {
            canvas.drawImage(this.assets.lmTerrainGraphics[tile.getFile()][tile.getImage()], xDrawingCoordinate, yDrawingCoordinate, null);
        }
    }

    private void drawCityNames(int i, int xpos, int ypos, int x, int y, Graphics g) {
        int gpxX = xpos * 64 - 64;
        int gpxY = ypos * 32;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Drawing city name for " + this.city.get(i).getName());
        }
        if (gpxX - x + 50 > 0 && gpxX - x + 50 < BUFFERWIDTH && gpxY - y + 50 > 0 && gpxY - y + 50 < BUFFERHEIGHT) {
            CITY thisCity = this.city.get(i);
            int defenseBonus = thisCity.calculateDefensiveBonus();
            String cityInfo = this.city.get(i).getName() + " - " + this.city.get(i).getSize() + " (+" + defenseBonus + "%)";
            int length = this.city.get(i).getName().length() * 2;
            if (Main.settings.biqLanguage.equals("Chinese")) {
                length *= 2;
            }
            length += 14;
            if (defenseBonus > 1000) {
                length += 4;
            }
            g.setColor(Color.WHITE);
            g.fillRect(gpxX - (x + length) + 32, gpxY - y + 48, 40 + length * 3, 20);
            g.setColor(Color.BLACK);
            g.drawString(cityInfo, gpxX - (x + length) + 40, gpxY - y + 64);
        }
    }

    private void drawGrid(int i, int xpos, int ypos, int x, int y, Graphics g) {
        int gpxX = xpos * 64 - 64;
        int gpxY = ypos * 32;
        g.setColor(Color.DARK_GRAY);
        g.drawLine(gpxX - x, gpxY - 32 - y, gpxX + 64 - x, gpxY - y);
        g.drawLine(gpxX - x, gpxY - 32 - y, gpxX + 64 - x, gpxY - 64 - y);
    }

    private void alertUserToError(Exception ex, int xindex, int yindex) {
        if (!this.encounteredExceptions.contains(ex.getStackTrace()[0])) {
            JOptionPane.showMessageDialog(null, "<html>An unexpected map rendering error was encountered.  <br/>Though the editor will generally keep working, you may encounter issues on the tile (" + xindex + ", " + yindex + ") that caused the error.  <br/>This error may occur on other tiles as well, and those will be logged, but pop-ups will be suppressed unless a different error occurs, so you can still get some work done.  <br/>The details are in log.txt, and reporting them would be appreciated.", "Unexpected rendering error", 0);
            this.encounteredExceptions.add(ex.getStackTrace()[0]);
        }
    }

    private void drawTileElements(TILE tile, int horizScrollPosition, int vertScrollPosition, Graphics canvas) {
        int defaultXPosition = tile.xPos * 64 - 64 - horizScrollPosition;
        int defaultYPosition = tile.yPos * 32 - vertScrollPosition;
        if (Main.settings.woodlandsEnabled) {
            this.drawForestJungle(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.hillsEnabled) {
            this.drawHillyTerrain(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.marshEnabled && tile.getRealTerrain() == 9) {
            BufferedImage randomMarsh = this.assets.largeMarsh[(tile.xPos + tile.yPos) % 8];
            canvas.drawImage(randomMarsh, defaultXPosition, defaultYPosition, null);
        }
        if (Main.settings.irrigationEnabled && ClassicRenderer.maskSet(tile.C3COverlays, 8)) {
            this.drawIrrigationGraphics(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.roadsEnabled) {
            if (ClassicRenderer.maskSet(tile.C3COverlays, 1)) {
                int roadIndex = this.calculateRoadImageIndex(tile.xPos, tile.yPos, 1);
                BufferedImage roadGraphic = this.assets.roadGraphics[roadIndex];
                canvas.drawImage(roadGraphic, defaultXPosition, defaultYPosition, null);
            }
            if (ClassicRenderer.maskSet(tile.C3COverlays, 2)) {
                int railIndex = this.calculateRoadImageIndex(tile.xPos, tile.yPos, 2);
                BufferedImage railGraphic = this.assets.roadGraphics[railIndex];
                canvas.drawImage(railGraphic, defaultXPosition, defaultYPosition, null);
            }
        }
        if (Main.settings.colonialBuildingsEnabled) {
            this.drawColonies(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.minesEnabled && ClassicRenderer.maskSet(tile.C3COverlays, 4)) {
            canvas.drawImage(this.assets.buildingGraphics[6], defaultXPosition, defaultYPosition, null);
        }
        if (Main.settings.riversEnabled) {
            this.drawRivers(tile, horizScrollPosition, vertScrollPosition, canvas);
        }
        if (Main.settings.barbarianCampsEnabled && ClassicRenderer.maskSet(tile.C3COverlays, 128)) {
            canvas.drawImage(this.assets.buildingGraphics[2], defaultXPosition, defaultYPosition, null);
        }
        if (Main.settings.goodyHutsEnabled && ClassicRenderer.maskSet(tile.C3COverlays, 32)) {
            canvas.drawImage(this.assets.goodyhutGraphics[(tile.xPos + tile.yPos) % 8], defaultXPosition, defaultYPosition, null);
        }
        this.drawTNT(tile, horizScrollPosition, vertScrollPosition, canvas);
        if (Main.settings.fortificationsEnabled) {
            this.drawFortifications(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.pollutionEnabled) {
            this.drawPollution(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.cratersEnabled) {
            this.drawCraters(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.ruinsEnabled && !this.assets.largeRuinGraphics) {
            this.drawRuins(tile, horizScrollPosition, vertScrollPosition, canvas);
        }
        if (Main.settings.bordersEnabled) {
            this.drawBorders(tile, horizScrollPosition, vertScrollPosition, canvas);
        }
        if (Main.settings.citiesEnabled && tile.getCity() > -1) {
            this.drawCities(tile, defaultXPosition, defaultYPosition, canvas);
        }
        if (Main.settings.vplsEnabled && tile.getVictoryPointLocation() == 0) {
            canvas.drawImage(this.assets.victoryPointGraphics, defaultXPosition, defaultYPosition, null);
        }
        if (tile.isLandmark()) {
            canvas.drawImage(this.assets.landmarkOverlay, defaultXPosition, defaultYPosition, null);
        }
        if (Main.settings.resourcesEnabled && tile.resourceInt != -1) {
            canvas.drawImage(this.assets.resourceGraphics[this.resource.get(tile.resourceInt).getIcon()], defaultXPosition + 40, defaultYPosition + 9, null);
        }
        if (Main.settings.unitsEnabled) {
            this.drawUnits(tile, horizScrollPosition, vertScrollPosition, canvas);
        }
        if (Main.settings.showFog && tile.getFogOfWar() == 0) {
            canvas.drawImage(this.assets.fog, defaultXPosition, defaultYPosition, null);
        }
    }

    private static boolean maskSet(int field, int MASK) {
        return (field & MASK) == MASK;
    }

    private void drawIrrigationGraphics(TILE tile, int defaultXPosition, int defaultYPosition, Graphics canvas) {
        int irrigationIndex = this.getIrrigrationIndex(tile.xPos, tile.yPos);
        if (tile.getBaseTerrain() == 0) {
            canvas.drawImage(this.assets.desertIrrigationGraphics[irrigationIndex], defaultXPosition, defaultYPosition, null);
        } else if (tile.getBaseTerrain() == 1) {
            canvas.drawImage(this.assets.plainsIrrigationGraphics[irrigationIndex], defaultXPosition, defaultYPosition, null);
        } else if (tile.getBaseTerrain() == 2) {
            canvas.drawImage(this.assets.irrigationGraphics[irrigationIndex], defaultXPosition, defaultYPosition, null);
        } else if (tile.getBaseTerrain() == 3) {
            canvas.drawImage(this.assets.tundraIrrigationGraphics[irrigationIndex], defaultXPosition, defaultYPosition, null);
        } else {
            this.logger.warn("Water tile being irrigated.  Position: " + tile.xPos + ", " + tile.yPos);
        }
    }

    private void drawForestJungle(TILE tile, int xPosition, int yPosition, Graphics canvas) {
        int xpos = tile.xPos;
        int ypos = tile.yPos;
        if (tile.getRealTerrain() == 7 || tile.getRealTerrain() == 8) {
            BufferedImage toDraw = null;
            if (tile.getRealTerrain() == 8) {
                toDraw = this.assets.largeJungle[(xpos + ypos) % 8];
            } else if (ClassicRenderer.maskSet(tile.C3CBonuses, 32)) {
                if (tile.getBaseTerrain() == 1) {
                    toDraw = this.assets.plainsPineForest[(xpos + ypos) % 12];
                } else if (tile.getBaseTerrain() == 2) {
                    toDraw = this.assets.grassPineForest[(xpos + ypos) % 12];
                } else if (tile.getBaseTerrain() == 3) {
                    toDraw = this.assets.tundraPineForest[(xpos + ypos) % 12];
                }
            } else if (tile.getBaseTerrain() == 1) {
                toDraw = this.assets.largePlainsForest[(xpos + ypos) % 8];
            } else if (tile.getBaseTerrain() == 2) {
                toDraw = this.assets.largeGrassForest[(xpos + ypos) % 8];
            } else if (tile.getBaseTerrain() == 3) {
                toDraw = this.assets.largeTundraForest[(xpos + ypos) % 8];
            }
            canvas.drawImage(toDraw, xPosition, yPosition, null);
        }
    }

    private void drawHillyTerrain(TILE tile, int defaultXPosition, int defaultYPosition, Graphics canvas) {
        int HILLS_Y_POS = defaultYPosition - 12;
        int MOUNTAINS_Y_POS = defaultYPosition - 24;
        if (tile.getRealTerrain() == 6 || tile.getRealTerrain() == 5 || tile.getRealTerrain() == 10) {
            int graphicsIndex = this.getMountainIndex(tile.xPos, tile.yPos);
            int forestJungleCheck = this.useForestOrJungleHillVariant(tile);
            if (tile.getRealTerrain() == 5) {
                if (tile.isLandmark()) {
                    canvas.drawImage(this.assets.lmHillGraphics[graphicsIndex], defaultXPosition, HILLS_Y_POS, null);
                } else if (forestJungleCheck == 7) {
                    canvas.drawImage(this.assets.forestHillGraphics[graphicsIndex], defaultXPosition, HILLS_Y_POS, null);
                } else if (forestJungleCheck == 8) {
                    canvas.drawImage(this.assets.jungleHillGraphics[graphicsIndex], defaultXPosition, HILLS_Y_POS, null);
                } else {
                    canvas.drawImage(this.assets.hillGraphics[graphicsIndex], defaultXPosition, HILLS_Y_POS, null);
                }
            } else if (tile.getRealTerrain() == 10) {
                if (forestJungleCheck == 7) {
                    canvas.drawImage(this.assets.forestVolcanoGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                } else if (forestJungleCheck == 8) {
                    canvas.drawImage(this.assets.jungleVolcanoGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                } else {
                    canvas.drawImage(this.assets.volcanoGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                }
            } else if (tile.getRealTerrain() == 6) {
                if (tile.isLandmark()) {
                    canvas.drawImage(this.assets.lmMountainGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                } else if (ClassicRenderer.maskSet(tile.C3CBonuses, 16)) {
                    canvas.drawImage(this.assets.snowMountainGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                } else if (forestJungleCheck == 7) {
                    canvas.drawImage(this.assets.forestMountainGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                } else if (forestJungleCheck == 8) {
                    canvas.drawImage(this.assets.jungleMountainGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                } else {
                    canvas.drawImage(this.assets.mountainGraphics[graphicsIndex], defaultXPosition, MOUNTAINS_Y_POS, null);
                }
            }
        }
    }

    private int useForestOrJungleHillVariant(TILE tile) {
        TILE northEast = tile.neighbor(MapDirection.NORTHEAST);
        TILE southEast = tile.neighbor(MapDirection.SOUTHEAST);
        TILE southWest = tile.neighbor(MapDirection.SOUTHWEST);
        TILE northWest = tile.neighbor(MapDirection.NORTHWEST);
        int hillyNeighborCount = 0;
        int forestNeighborCount = 0;
        int jungleNeighborCount = 0;
        ArrayList<TILE> neighbors = new ArrayList<TILE>();
        neighbors.add(northEast);
        neighbors.add(southEast);
        neighbors.add(southWest);
        neighbors.add(northWest);
        for (TILE t : neighbors) {
            if (t == null) continue;
            if (t.getRealTerrain() == 5 || t.getRealTerrain() == 6 || t.getRealTerrain() == 10) {
                ++hillyNeighborCount;
                continue;
            }
            if (t.getRealTerrain() == 7) {
                ++forestNeighborCount;
                continue;
            }
            if (t.getRealTerrain() != 8) continue;
            ++jungleNeighborCount;
        }
        if (forestNeighborCount == 0 && jungleNeighborCount == 0) {
            return -1;
        }
        if (forestNeighborCount + jungleNeighborCount + hillyNeighborCount < 4) {
            return -1;
        }
        if (forestNeighborCount > jungleNeighborCount) {
            return 7;
        }
        if (jungleNeighborCount > forestNeighborCount) {
            return 8;
        }
        if (tile.xPos % 2 == 0) {
            return 7;
        }
        return 8;
    }

    private int getMountainIndex(int xIndex, int yIndex) {
        int mtnIndex = 0;
        TILE center = this.getTile(xIndex, yIndex);
        TILE northEast = center.neighbor(MapDirection.NORTHEAST);
        TILE southEast = center.neighbor(MapDirection.SOUTHEAST);
        TILE southWest = center.neighbor(MapDirection.SOUTHWEST);
        TILE northWest = center.neighbor(MapDirection.NORTHWEST);
        if (northEast != null && (northEast.getRealTerrain() == 6 || northEast.getRealTerrain() == 5 || northEast.getRealTerrain() == 10)) {
            mtnIndex += 2;
        }
        if (southWest != null && (southWest.getRealTerrain() == 6 || southWest.getRealTerrain() == 5 || southWest.getRealTerrain() == 10)) {
            mtnIndex += 4;
        }
        if (southEast != null && (southEast.getRealTerrain() == 6 || southEast.getRealTerrain() == 5 || southEast.getRealTerrain() == 10)) {
            mtnIndex += 8;
        }
        if (northWest != null && (northWest.getRealTerrain() == 6 || northWest.getRealTerrain() == 5 || northWest.getRealTerrain() == 10)) {
            ++mtnIndex;
        }
        return mtnIndex;
    }

    private int getIrrigrationIndex(int xIndex, int yIndex) {
        int irrigationIndex = 0;
        TILE center = this.getTile(xIndex, yIndex);
        TILE northEast = center.neighbor(MapDirection.NORTHEAST);
        TILE southEast = center.neighbor(MapDirection.SOUTHEAST);
        TILE southWest = center.neighbor(MapDirection.SOUTHWEST);
        TILE northWest = center.neighbor(MapDirection.NORTHWEST);
        if (northEast != null && (northEast.C3COverlays & 8) == 8) {
            irrigationIndex += 2;
        }
        if (southWest != null && (southWest.C3COverlays & 8) == 8) {
            irrigationIndex += 4;
        }
        if (southEast != null && (southEast.C3COverlays & 8) != 8) {
            irrigationIndex += 8;
        }
        if (northWest != null && (northWest.C3COverlays & 8) != 8) {
            ++irrigationIndex;
        }
        return irrigationIndex;
    }

    private int calculateRoadImageIndex(int xpos, int ypos, int ROAD_MASK) {
        int roadIndex = 0;
        if (this.getTile(xpos + 1, ypos - 1) != null && (this.getTile((int)(xpos + 1), (int)(ypos - 1)).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            ++roadIndex;
        }
        if (this.getTile(xpos + 2, ypos) != null && (this.getTile((int)(xpos + 2), (int)ypos).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            roadIndex += 2;
        }
        if (this.getTile(xpos + 1, ypos + 1) != null && (this.getTile((int)(xpos + 1), (int)(ypos + 1)).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            roadIndex += 4;
        }
        if (this.getTile(xpos, ypos + 2) != null && (this.getTile((int)xpos, (int)(ypos + 2)).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            roadIndex += 8;
        }
        if (this.getTile(xpos - 1, ypos + 1) != null && (this.getTile((int)(xpos - 1), (int)(ypos + 1)).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            roadIndex += 16;
        }
        if (this.getTile(xpos - 2, ypos) != null && (this.getTile((int)(xpos - 2), (int)ypos).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            roadIndex += 32;
        }
        if (this.getTile(xpos - 1, ypos - 1) != null && (this.getTile((int)(xpos - 1), (int)(ypos - 1)).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            roadIndex += 64;
        }
        if (this.getTile(xpos, ypos - 2) != null && (this.getTile((int)xpos, (int)(ypos - 2)).C3COverlays & ROAD_MASK) == ROAD_MASK) {
            roadIndex += 128;
        }
        return roadIndex;
    }

    private void drawColonies(TILE tile, int defaultXPosition, int defaultYPosition, Graphics g) {
        if (tile.getColony() != -1) {
            int colonyType;
            short colIndex = tile.getColony();
            int owner = -1;
            int colonyAge = 0;
            block0 : switch (this.colony.get(colIndex).getOwnerType()) {
                case 2: {
                    owner = this.colony.get(colIndex).getOwner();
                    if (!this.biq.hasCustomPlayerData()) break;
                    for (int p = 0; p < this.player.size(); ++p) {
                        if (this.player.get((int)p).civ != owner) continue;
                        colonyAge = this.player.get((int)p).initialEra == 4 ? 3 : this.player.get((int)p).initialEra;
                        break block0;
                    }
                    break;
                }
                case 3: {
                    if (this.colony.get(colIndex).getOwner() > -1) {
                        colonyAge = this.player.get((int)this.colony.get((int)colIndex).getOwner()).initialEra;
                        break;
                    }
                    this.logger.warn("Warning! On owner of CLNY " + this.colony.get(colIndex).toEnglish());
                    break;
                }
                default: {
                    this.logger.warn("Colony of unrecognized ownership: " + this.colony.get(colIndex).toEnglish());
                }
            }
            if ((colonyType = this.colony.get(colIndex).getImprovementType()) == 0) {
                g.drawImage(this.assets.buildingGraphics[4 * colonyAge + 1], defaultXPosition, defaultYPosition, null);
            } else if (colonyType == 2) {
                g.drawImage(this.assets.radarTowerGraphics, defaultXPosition, defaultYPosition - 64, null);
            } else if (colonyType == 3) {
                if (colonyAge > 2) {
                    colonyAge = 2;
                }
                g.drawImage(this.assets.outpostGraphics[colonyAge], defaultXPosition, defaultYPosition - 64, null);
            } else if (colonyType == 1) {
                if (colonyAge < 2) {
                    g.drawImage(this.assets.airfieldGraphics[0], defaultXPosition, defaultYPosition, null);
                } else {
                    g.drawImage(this.assets.airfieldGraphics[1], defaultXPosition, defaultYPosition, null);
                }
            }
        }
    }

    private void drawRivers(TILE tile, int x, int y, Graphics g) {
        int riverImageIndex;
        int westTile;
        int southTile;
        int eastTile;
        int northTile;
        int gpxX = tile.xPos * 64 - 64;
        int gpxY = tile.yPos * 32;
        if (tile.xPos == 1) {
            northTile = this.biq.calculateTileIndex(tile.xPos - 1, tile.yPos - 1);
            eastTile = tile.index;
            southTile = this.biq.calculateTileIndex(tile.xPos - 1, tile.yPos + 1);
            westTile = -1;
            riverImageIndex = 0;
            if (northTile != -1 && (this.tiles.get(northTile).getRiverConnectionInfo() & 0x20) == 32) {
                ++riverImageIndex;
            }
            if (eastTile != -1 && (this.tiles.get(eastTile).getRiverConnectionInfo() & 0x80) == 128) {
                riverImageIndex += 2;
            }
            if (westTile != -1 && (this.tiles.get(westTile).getRiverConnectionInfo() & 8) == 8) {
                riverImageIndex += 4;
            }
            if (southTile != -1 && (this.tiles.get(southTile).getRiverConnectionInfo() & 2) == 2) {
                riverImageIndex += 8;
            }
            if (riverImageIndex != 0) {
                g.drawImage(this.assets.riverGraphics[riverImageIndex], gpxX - x - 64, gpxY - y, null);
            }
        }
        northTile = -1;
        if (tile.yPos > 1) {
            northTile = this.biq.calculateTileIndex(tile.xPos + 1, tile.yPos - 1);
        }
        eastTile = -1;
        if (tile.xPos < this.wmap.width - 2) {
            eastTile = this.biq.calculateTileIndex(tile.xPos + 2, tile.yPos);
        }
        southTile = -1;
        if (tile.yPos < this.wmap.height - 2) {
            southTile = this.biq.calculateTileIndex(tile.xPos + 1, tile.yPos + 1);
        }
        westTile = tile.index;
        riverImageIndex = 0;
        if (northTile != -1 && (this.tiles.get(northTile).getRiverConnectionInfo() & 0x20) == 32) {
            ++riverImageIndex;
        }
        if (eastTile != -1 && (this.tiles.get(eastTile).getRiverConnectionInfo() & 0x80) == 128) {
            riverImageIndex += 2;
        }
        if (westTile != -1 && (this.tiles.get(westTile).getRiverConnectionInfo() & 8) == 8) {
            riverImageIndex += 4;
        }
        if (southTile != -1 && (this.tiles.get(southTile).getRiverConnectionInfo() & 2) == 2) {
            riverImageIndex += 8;
        }
        if (riverImageIndex != 0) {
            g.drawImage(this.assets.riverGraphics[riverImageIndex], gpxX - x + 64, gpxY - y, null);
        }
    }

    private void drawFortifications(TILE tile, int defaultXPosition, int defaultYPosition, Graphics g) {
        int age;
        if (ClassicRenderer.maskSet(tile.C3COverlays, 16)) {
            age = this.getFortAge(tile);
            g.drawImage(this.assets.buildingGraphics[age * 4], defaultXPosition, defaultYPosition, null);
        }
        if (ClassicRenderer.maskSet(tile.C3COverlays, 0x10000000)) {
            age = this.getFortAge(tile);
            g.drawImage(this.assets.buildingGraphics[age * 4 + 3], defaultXPosition, defaultYPosition, null);
        }
    }

    private int getFortAge(TILE tile) {
        int age;
        int owner = tile.owner;
        int playerOwner = -1;
        if (this.biq.hasCustomPlayerData()) {
            for (int j = 0; j < this.player.size(); ++j) {
                if (this.player.get((int)j).civ != owner) continue;
                playerOwner = j;
                break;
            }
        }
        int n = age = playerOwner == -1 ? 0 : this.player.get((int)playerOwner).initialEra;
        if (age > 3) {
            return 3;
        }
        return age;
    }

    private void drawPollution(TILE tile, int defaultXPosition, int defaultYPosition, Graphics g) {
        int xpos = tile.xPos;
        int ypos = tile.yPos;
        if (ClassicRenderer.maskSet(tile.C3COverlays, 64)) {
            int pollutionIndex = this.getNeighborInfluencedOverlayGraphicsIndex(xpos, ypos, 64);
            if (pollutionIndex != 0) {
                g.drawImage(this.assets.pollutionGraphics[pollutionIndex + 9], defaultXPosition, defaultYPosition, null);
            } else {
                g.drawImage(this.assets.pollutionGraphics[(xpos + ypos) % 10], defaultXPosition, defaultYPosition, null);
            }
        }
    }

    private void drawBorders(TILE tile, int x, int y, Graphics g) {
        int gpxX = tile.xPos * 64 - 64;
        int gpxY = tile.yPos * 32;
        if (tile.owner != -1) {
            int owner = tile.owner;
            int borderColors = tile.borderColor;
            boolean nwBorder = false;
            boolean neBorder = false;
            boolean swBorder = false;
            boolean seBorder = false;
            if (tile.neighbor(MapDirection.NORTHWEST) != null) {
                boolean bl = nwBorder = tile.neighbor((MapDirection)MapDirection.NORTHWEST).owner != owner;
            }
            if (tile.neighbor(MapDirection.NORTHEAST) != null) {
                boolean bl = neBorder = tile.neighbor((MapDirection)MapDirection.NORTHEAST).owner != owner;
            }
            if (tile.neighbor(MapDirection.SOUTHWEST) != null) {
                boolean bl = swBorder = tile.neighbor((MapDirection)MapDirection.SOUTHWEST).owner != owner;
            }
            if (tile.neighbor(MapDirection.SOUTHEAST) != null) {
                boolean bl = seBorder = tile.neighbor((MapDirection)MapDirection.SOUTHEAST).owner != owner;
            }
            if (nwBorder) {
                g.drawImage(this.assets.borderGraphics[borderColors][0], gpxX - x, gpxY - y - 12, null);
            }
            if (neBorder) {
                g.drawImage(this.assets.borderGraphics[borderColors][2], gpxX - x, gpxY - y - 12, null);
            }
            if (swBorder) {
                g.drawImage(this.assets.borderGraphics[borderColors][4], gpxX - x, gpxY - y - 12, null);
            }
            if (seBorder) {
                g.drawImage(this.assets.borderGraphics[borderColors][6], gpxX - x, gpxY - y - 12, null);
            }
        }
    }

    private void drawCities(TILE tile, int defaultXPosition, int defaultYPosition, Graphics g) {
        CITY thisCity = this.city.get(tile.getCity());
        int cultGroup = 0;
        int owner = -1;
        int cityAge = 0;
        block0 : switch (thisCity.getOwnerType()) {
            case 2: {
                owner = thisCity.getOwner();
                cultGroup = this.civ.get(owner).getCultureGroup();
                if (!this.biq.hasCustomPlayerData()) break;
                for (int p = 0; p < this.player.size(); ++p) {
                    if (this.player.get((int)p).civ != owner) continue;
                    cityAge = this.player.get((int)p).initialEra == 4 ? 3 : this.player.get((int)p).initialEra;
                    break block0;
                }
                break;
            }
            case 3: {
                if (thisCity.getOwner() > -1) {
                    if (!this.biq.hasCustomPlayerData()) break;
                    owner = this.player.get((int)thisCity.getOwner()).civ;
                    cultGroup = owner > -1 ? this.civ.get(owner).getCultureGroup() : 2;
                    cityAge = this.player.get((int)thisCity.getOwner()).initialEra == 4 ? 3 : this.player.get((int)thisCity.getOwner()).initialEra;
                    break;
                }
                this.logger.warn("Warning! On owner of city " + thisCity.getName());
                break;
            }
            default: {
                this.logger.warn("City of unrecognized ownership: " + thisCity.getName());
            }
        }
        BufferedImage cityGraphics = null;
        if (this.cityGraphicsHaveWalls(thisCity)) {
            cityGraphics = this.assets.wallCityGraphics[cultGroup][cityAge];
        } else {
            int size = -1;
            size = thisCity.getSize() <= this.rule.get(0).getMaxCity1Size() ? 0 : (thisCity.getSize() <= this.rule.get(0).getMaxCity2Size() ? 1 : 2);
            if (size < 2 && thisCity.isCapital()) {
                ++size;
            }
            cityGraphics = this.assets.noWallCityGraphics[cultGroup][cityAge][size];
        }
        int heightOffset = 0;
        int widthOffset = 0;
        if (cityGraphics.getHeight() > 95) {
            heightOffset = (cityGraphics.getHeight() - 95) / 2;
        }
        if (cityGraphics.getWidth() > 167) {
            widthOffset = (cityGraphics.getWidth() - 167) / 2;
        }
        g.drawImage(cityGraphics, defaultXPosition - 18 - widthOffset, defaultYPosition - 18 - heightOffset, null);
    }

    private boolean cityGraphicsHaveWalls(CITY thisCity) {
        return thisCity.getSize() <= this.rule.get(0).getMaxCity1Size() && thisCity.hasWallStyleBuilding();
    }

    private void drawTNT(TILE tile, int horizScrollPosition, int vertScrollPosition, Graphics canvas) {
        int tileLeftBoundary = tile.xPos * 64 - 64;
        int tileTopBoundary = tile.yPos * 32 - 32;
        int xDrawingCoordinate = tileLeftBoundary - horizScrollPosition;
        int yDrawingCoordinate = tileTopBoundary - vertScrollPosition + 32;
        int idx = tile.index % 3;
        if (Settings.showFoodAndShields) {
            if (tile.getRealTerrain() == 1) {
                canvas.drawImage(this.assets.tntPlains[idx], xDrawingCoordinate, yDrawingCoordinate, null);
            } else if (tile.getRealTerrain() == 0) {
                canvas.drawImage(this.assets.tntDesert[idx], xDrawingCoordinate, yDrawingCoordinate, null);
            } else if (tile.getRealTerrain() == 4) {
                canvas.drawImage(this.assets.tntFloodPlains[idx], xDrawingCoordinate, yDrawingCoordinate, null);
            } else if (tile.getRealTerrain() == 3) {
                canvas.drawImage(this.assets.tntTundra[idx], xDrawingCoordinate, yDrawingCoordinate, null);
            } else if (tile.getRealTerrain() == 2) {
                if (tile.hasBonusGrassland()) {
                    canvas.drawImage(this.assets.tntGrassShield[idx], xDrawingCoordinate, yDrawingCoordinate, null);
                } else {
                    canvas.drawImage(this.assets.tntGrass[idx], xDrawingCoordinate, yDrawingCoordinate, null);
                }
            }
        } else if (tile.getRealTerrain() == 2 && tile.hasBonusGrassland()) {
            canvas.drawImage(this.assets.tntDesert[idx], xDrawingCoordinate, yDrawingCoordinate, null);
        }
    }

    private void drawCraters(TILE tile, int defaultXPosition, int defaultYPosition, Graphics g) {
        if (ClassicRenderer.maskSet(tile.C3COverlays, 256)) {
            int craterIndex = this.getNeighborInfluencedOverlayGraphicsIndex(tile.xPos, tile.yPos, 256);
            if (craterIndex != 0) {
                g.drawImage(this.assets.craterGraphics[craterIndex + 9], defaultXPosition, defaultYPosition, null);
            } else {
                g.drawImage(this.assets.craterGraphics[(tile.xPos + tile.yPos) % 10], defaultXPosition, defaultYPosition, null);
            }
        }
    }

    private int getNeighborInfluencedOverlayGraphicsIndex(int xpos, int ypos, int MASK) {
        int index = 0;
        if (this.getTile(xpos + 1, ypos - 1) != null && (this.getTile((int)(xpos + 1), (int)(ypos - 1)).C3COverlays & MASK) == MASK) {
            index += 2;
        }
        if (this.getTile(xpos - 1, ypos + 1) != null && (this.getTile((int)(xpos - 1), (int)(ypos + 1)).C3COverlays & MASK) == MASK) {
            index += 8;
        }
        if (this.getTile(xpos + 1, ypos + 1) != null && (this.getTile((int)(xpos + 1), (int)(ypos + 1)).C3COverlays & MASK) == MASK) {
            index += 4;
        }
        if (this.getTile(xpos - 1, ypos - 1) != null && (this.getTile((int)(xpos - 1), (int)(ypos - 1)).C3COverlays & MASK) == MASK) {
            ++index;
        }
        return index;
    }

    private void drawRuins(TILE tile, int x, int y, Graphics g) {
        int gpxX = tile.xPos * 64 - 64;
        int gpxY = tile.yPos * 32;
        int xOffset = 20;
        int yOffset = 15;
        if (this.assets.largeRuinGraphics) {
            xOffset = this.assets.ruinGraphics[0].getWidth() / 2 - 60;
            yOffset = this.assets.ruinGraphics[0].getHeight() / 2 - 45;
        }
        if (tile.ruin == 1) {
            g.drawImage(this.assets.ruinGraphics[0], gpxX - x - xOffset, gpxY - y - yOffset, null);
        }
    }

    private void drawUnits(TILE tile, int x, int y, Graphics g) {
        int gpxX = tile.xPos * 64 - 64;
        int gpxY = tile.yPos * 32;
        if (tile.unitWithBestDefence != -1 && gpxX - x + 50 > 0 && gpxX - x + 50 < BUFFERWIDTH && gpxY - y + 50 > 0 && gpxY - y + 50 < BUFFERHEIGHT) {
            UNIT mapUnit = this.biq.mapUnit.get(tile.unitsOnTile.get(tile.unitWithBestDefence));
            PRTO unitType = this.biq.unit.get(mapUnit.getPRTONumber());
            int index = unitType.getIconIndex();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Drawing a " + unitType.getName() + " on tile " + tile.xPos + ", " + tile.yPos);
            }
            BufferedImage civColoredImage = Units32Supplier.getUnit32Image(index, tile.borderColor);
            g.drawImage(civColoredImage, gpxX - x + 48, gpxY - y + 9, null);
        }
    }

    private TILE getTile(int xPos, int yPos) {
        int index = 0;
        index += yPos / 2 * this.wmap.width;
        if (yPos % 2 == 1) {
            index += this.wmap.width / 2;
        }
        index += xPos / 2;
        try {
            return this.tiles.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    private boolean southeastConnection(int xpos, int ypos) {
        if (ypos < 0 || ypos >= this.wmap.height - 1) {
            return false;
        }
        int numberOfFives = ypos / 5;
        int baseX = xpos;
        int baseY = ypos;
        if (baseX < baseY) {
            baseX += this.wmap.width;
        }
        baseX -= 5 * numberOfFives;
        baseY -= 5 * numberOfFives;
        boolean noSE = false;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("baseX, baseY: " + baseX + ", " + baseY);
        }
        while (baseX >= 0) {
            if (baseX == 0 && baseY == 0) {
                noSE = true;
            }
            if (baseX == 4 && baseY == 2) {
                noSE = true;
            }
            if (baseX == 8 && baseY == 4) {
                noSE = true;
            }
            if (baseX == 7 && baseY == 1) {
                noSE = true;
            }
            if (baseX == 11 && baseY == 3) {
                noSE = true;
            }
            baseX -= 5;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("X: " + xpos + ", Y: " + ypos + " connects SE? " + !noSE);
        }
        return !noSE;
    }

    @Override
    public Image drawTile(int x, int y) {
        int tileIndex = this.biq.calculateTileIndex(x, y);
        BufferedImage image = new BufferedImage(196, 88, 2);
        Graphics g = image.getGraphics();
        if (g != null && tileIndex != -1) {
            TILE tile = this.tiles.get(tileIndex);
            int realTileX = tile.xPos;
            int realTileY = tile.yPos;
            tile.xPos = 0;
            tile.yPos = 0;
            this.drawBaseTerrain(this.tiles.get(tileIndex), -64, -56, g);
            this.drawTileElements(this.tiles.get(tileIndex), -64, -24, g);
            tile.xPos = realTileX;
            tile.yPos = realTileY;
        } else {
            this.logger.error("Graphics null in drawTile(x,y)");
        }
        return image.getSubimage(0, 0, 128, image.getHeight());
    }
}

