/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.tabs.map.renderer;

import com.civfanatics.civ3.xplatformeditor.tabs.map.GraphicsAssets;
import java.awt.Image;
import java.awt.image.BufferedImage;

public abstract class Renderer {
    protected static int BUFFERWIDTH = 1300;
    protected static int BUFFERHEIGHT = 1200;
    protected static int TILE_WIDTH = 128;
    protected static int TILE_HEIGHT = 64;
    protected BufferedImage buffer = null;
    protected GraphicsAssets assets = null;
    protected int horizScrollOffset;
    protected int vertScrollOffset;

    public abstract void render();

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    protected boolean tileIsVisible(int xIndex, int yIndex) {
        int tileLeftBoundary = xIndex * 64 - 64;
        int tileTopBoundary = yIndex * 32;
        int leftBoundaryOnCanvas = tileLeftBoundary - this.horizScrollOffset + TILE_WIDTH;
        int topBoundaryOnCanvas = tileTopBoundary - this.vertScrollOffset + TILE_HEIGHT;
        return leftBoundaryOnCanvas > 0 && leftBoundaryOnCanvas < BUFFERWIDTH && topBoundaryOnCanvas > 0 && topBoundaryOnCanvas < BUFFERHEIGHT;
    }

    public void setHorizPosition(int x) {
        this.horizScrollOffset = x;
    }

    public void setVertPosition(int y) {
        this.vertScrollOffset = y;
    }

    public abstract void setViewportSize(int var1, int var2);

    public abstract Image drawTile(int var1, int var2);
}

