/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor.undoRedo;

import com.civfanatics.civ3.biqFile.BIQSection;
import com.civfanatics.civ3.biqFile.CTZN;
import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.EditMenu;
import java.util.ArrayDeque;
import java.util.Deque;

public class UndoStack {
    IO biq;
    EditMenu editMenu;
    Deque<UndoElement> elements = new ArrayDeque<UndoElement>();

    public UndoStack(IO biq, EditMenu editMenu) {
        this.biq = biq;
        this.editMenu = editMenu;
        editMenu.undoStack = this;
    }

    public void push(BIQSection biqElement, int itemIndex) {
        UndoElement u = new UndoElement();
        u.indexWithinSection = itemIndex;
        u.item = biqElement;
        this.elements.push(u);
        this.editMenu.undo.setText("Undo editing " + biqElement.getProperty("name"));
        this.editMenu.undo.setEnabled(true);
    }

    public void pop() {
        UndoElement u = this.elements.pop();
        if (u.item instanceof CTZN) {
            CTZN citizen = (CTZN)u.item;
            System.out.println("Undoing changes for " + citizen.getName());
            this.biq.citizens.set(u.indexWithinSection, citizen);
        }
        if (this.elements.peek() != null) {
            System.out.println("Setting label to " + this.elements.peek().item.getProperty("name"));
            this.editMenu.undo.setText("Undo editing " + this.elements.peek().item.getProperty("name"));
        } else {
            this.editMenu.undo.setText("Undo");
            this.editMenu.undo.setEnabled(false);
        }
    }

    class UndoElement {
        BIQSection item;
        int indexWithinSection;

        UndoElement() {
        }
    }
}

