/*
 * Decompiled with CFR 0.152.
 */
package com.civfanatics.civ3.xplatformeditor;

import com.civfanatics.civ3.biqFile.IO;
import com.civfanatics.civ3.xplatformeditor.CustomComponents.SuperListModel;
import com.civfanatics.civ3.xplatformeditor.Main;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextInputDialog;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.apache.log4j.Logger;

public final class utils {
    static String autoDetectFail = " does not exist; auto-detect failed";
    static Logger logger = Logger.getLogger(utils.class);

    private utils() {
    }

    public static void removeFromList(int index, List storage, SuperListModel model, JList list) {
        storage.remove(index);
        model.slRemove(index);
        if (model.size() > index) {
            list.setSelectedIndex(index);
        } else {
            list.setSelectedIndex(index - 1);
        }
    }

    public static void removeFromList(int index, List storage, DefaultListModel model, JList list) {
        storage.remove(index);
        model.remove(index);
        if (model.size() > index) {
            list.setSelectedIndex(index);
        } else {
            list.setSelectedIndex(index - 1);
        }
    }

    public static void removeFromList(int index, DefaultListModel model, JList list) {
        model.remove(index);
        if (model.size() > index) {
            list.setSelectedIndex(index);
        } else {
            list.setSelectedIndex(index - 1);
        }
    }

    private static String findFileWindows(String name, String folderStruct, IO biq) throws FileNotFoundException {
        String fileName;
        File file;
        if (biq.scenarioProperty.size() > 0) {
            for (int i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
                String fileName2 = Main.settings.civInstallDir + Main.fileSlash + "Conquests" + Main.fileSlash + "Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
                File file2 = new File(fileName2);
                if (!file2.exists()) continue;
                return fileName2;
            }
        }
        if ((file = new File(fileName = Main.settings.civInstallDir + Main.fileSlash + "Conquests" + Main.fileSlash + folderStruct + name)).exists()) {
            return fileName;
        }
        fileName = Main.settings.civInstallDir + Main.fileSlash + "Civ3PTW" + Main.fileSlash + folderStruct + name;
        file = new File(fileName);
        if (file.exists()) {
            return fileName;
        }
        fileName = Main.settings.civInstallDir + Main.fileSlash + folderStruct + name;
        file = new File(fileName);
        if (file.exists()) {
            return fileName;
        }
        throw new FileNotFoundException("Could not find file (using Windows method); last hope was " + fileName);
    }

    private static String findFileUnix(String name, String folderStruct, IO biq) throws FileNotFoundException {
        for (int i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
            String fileName = Main.settings.civInstallDir + Main.fileSlash + "Conquests" + Main.fileSlash + "Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
            File file = new File(fileName);
            if (file.exists()) {
                return fileName;
            }
            file = new File(fileName = fileName.substring(0, fileName.length() - 3) + "PCX");
            if (!file.exists()) continue;
            return fileName;
        }
        String fileName = Main.settings.civInstallDir + Main.fileSlash + "Conquests" + Main.fileSlash + folderStruct + name;
        File file = new File(fileName);
        if (file.exists()) {
            return fileName;
        }
        file = new File(fileName = fileName.substring(0, fileName.length() - 3) + "PCX");
        if (file.exists()) {
            return fileName;
        }
        fileName = Main.settings.civInstallDir + Main.fileSlash + "Civ3PTW" + Main.fileSlash + folderStruct + name;
        file = new File(fileName);
        if (file.exists()) {
            return fileName;
        }
        file = new File(fileName = fileName.substring(0, fileName.length() - 3) + "PCX");
        if (file.exists()) {
            return fileName;
        }
        fileName = Main.settings.civInstallDir + Main.fileSlash + folderStruct + name;
        file = new File(fileName);
        if (file.exists()) {
            return fileName;
        }
        file = new File(fileName = fileName.substring(0, fileName.length() - 3) + "PCX");
        if (file.exists()) {
            return fileName;
        }
        if (fileName.contains("Units")) {
            file = new File(fileName = fileName.replaceAll("Units", "units"));
            if (file.exists()) {
                return fileName;
            }
            fileName = fileName.substring(0, fileName.length() - 3) + "pcx";
            file = new File(fileName);
        }
        if (file.exists()) {
            return fileName;
        }
        throw new FileNotFoundException("Could not find file (using UNIX method); last hope was " + fileName);
    }

    public static String findFile(String fullName, IO biq) throws FileNotFoundException {
        int slashDex = fullName.lastIndexOf(Main.fileSlash);
        return utils.findFile(fullName.substring(slashDex + 1), fullName.substring(0, slashDex + 1), biq);
    }

    public static String findFile(String name, String folderStruct, IO biq) throws FileNotFoundException {
        if (Main.os.name.toLowerCase().contains("mac") || Main.os.name.toLowerCase().contains("os x")) {
            return utils.findFileOSX(name, folderStruct, biq);
        }
        if (Main.os.name.toLowerCase().contains("windows")) {
            return utils.findFileWindows(name, folderStruct, biq);
        }
        return utils.findFileUnix(name, folderStruct, biq);
    }

    private static String findFileOSX(String name, String folderStruct, IO biq) throws FileNotFoundException {
        File file;
        String fileName;
        int i;
        for (i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
            fileName = Main.settings.civInstallDir + Main.fileSlash + "Conquests Game Data" + Main.fileSlash + "Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
            file = new File(fileName);
            if (!file.exists()) continue;
            return fileName;
        }
        for (i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
            fileName = "~/Documents/Civilization 3 Conquests/Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
            file = new File(fileName);
            if (!file.exists()) continue;
            return fileName;
        }
        String fileName2 = Main.settings.civInstallDir + Main.fileSlash + "Conquests Game Data" + Main.fileSlash + folderStruct + name;
        File file2 = new File(fileName2);
        if (file2.exists()) {
            return fileName2;
        }
        fileName2 = Main.settings.civInstallDir + Main.fileSlash + "Play the World Game Data" + Main.fileSlash + folderStruct + name;
        file2 = new File(fileName2);
        if (file2.exists()) {
            return fileName2;
        }
        fileName2 = Main.settings.civInstallDir + Main.fileSlash + "Civilization 3 Game Data" + Main.fileSlash + folderStruct + name;
        file2 = new File(fileName2);
        if (file2.exists()) {
            return fileName2;
        }
        throw new FileNotFoundException("Could not find file (using OSX version); last hope was " + fileName2);
    }

    public static boolean verifyGoodInstall(String installDir) {
        String path = installDir + Main.fileSlash;
        logger.info("path for install: " + path);
        if (Main.os.name.toLowerCase().contains("mac")) {
            String civ3BasePath = path + "Civilization 3 Game Data";
            File f = new File(civ3BasePath);
            if (!f.exists()) {
                logger.warn(civ3BasePath + autoDetectFail);
                return false;
            }
            String ptwBasePath = path + "Play the World Game Data";
            f = new File(ptwBasePath);
            if (!f.exists()) {
                logger.warn(ptwBasePath + autoDetectFail);
                return false;
            }
            String conquestsBasePath = path + "Conquests Game Data";
            f = new File(conquestsBasePath);
            if (!f.exists()) {
                logger.warn(conquestsBasePath + autoDetectFail);
                return false;
            }
            String mainArtPath = civ3BasePath + Main.fileSlash + "Art";
            f = new File(mainArtPath);
            if (!f.exists()) {
                logger.warn(mainArtPath + autoDetectFail);
                return false;
            }
            String mainSoundsPath = civ3BasePath + Main.fileSlash + "Sounds";
            f = new File(mainSoundsPath);
            if (!f.exists()) {
                logger.warn(mainSoundsPath + autoDetectFail);
                return false;
            }
            String mainTextPath = civ3BasePath + Main.fileSlash + "Text";
            f = new File(mainTextPath);
            if (!f.exists()) {
                logger.warn(mainTextPath + autoDetectFail);
                return false;
            }
        } else {
            String ptwBasePath = path + "Civ3PTW";
            File f = new File(ptwBasePath);
            if (!f.exists()) {
                logger.warn(ptwBasePath + autoDetectFail);
                return false;
            }
            String conquestsBasePath = path + "Conquests";
            f = new File(conquestsBasePath);
            if (!f.exists()) {
                logger.warn(conquestsBasePath + autoDetectFail);
                return false;
            }
            String mainArtPath = path + "Art";
            f = new File(mainArtPath);
            if (!f.exists()) {
                logger.warn(mainArtPath + autoDetectFail);
                return false;
            }
            String mainSoundsPath = path + "Sounds";
            f = new File(mainSoundsPath);
            if (!f.exists()) {
                logger.warn(mainSoundsPath + autoDetectFail);
                return false;
            }
            String mainTextPath = path + "Text";
            f = new File(mainTextPath);
            if (!f.exists()) {
                logger.warn(mainTextPath + autoDetectFail);
                return false;
            }
        }
        return true;
    }

    public static void addWithPossibleDuplicates(String toAdd, DefaultComboBoxModel dcbm) {
        while (dcbm.getIndexOf(toAdd) != -1) {
            toAdd = toAdd + " ";
        }
        dcbm.addElement(toAdd);
    }

    public static void renameItemInComboBox(int indexInModel, String newName, DefaultComboBoxModel dcbm) {
        boolean renamingSelectedItem = dcbm.getElementAt(indexInModel).equals(dcbm.getSelectedItem());
        dcbm.removeElementAt(indexInModel);
        dcbm.insertElementAt(newName, indexInModel);
        if (renamingSelectedItem) {
            dcbm.setSelectedItem(newName);
        }
    }

    public static String cTrim(String s) {
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < s.length() && s.charAt(i) != '\u0000'; ++i) {
            newString.append(s.charAt(i));
        }
        return newString.toString();
    }

    public static int[] integerArrayToIntArray(Integer[] array) {
        int[] newArray = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static String spliceInSearchFolder(String firaxisPath, String searchFolder) {
        String conquestsFolder = utils.getConquestsFolder(Main.settings.civInstallDir);
        int index = firaxisPath.indexOf(conquestsFolder);
        if (index == 0) {
            int introLength = conquestsFolder.length();
            String firaxisFileSpecificPath = firaxisPath.substring(introLength);
            return conquestsFolder + "Scenarios" + Main.fileSlash + searchFolder + Main.fileSlash + firaxisFileSpecificPath;
        }
        String ptwFolder = utils.getPTWFolder(Main.settings.civInstallDir);
        index = firaxisPath.indexOf(ptwFolder);
        if (index == 0) {
            int introLength = ptwFolder.length();
            String firaxisFileSpecificPath = firaxisPath.substring(introLength);
            return conquestsFolder + "Scenarios" + Main.fileSlash + searchFolder + Main.fileSlash + firaxisFileSpecificPath;
        }
        String vanillaFolder = utils.getVanillaFolder(Main.settings.civInstallDir);
        index = firaxisPath.indexOf(vanillaFolder);
        if (index == 0) {
            int introLength = vanillaFolder.length();
            String firaxisFileSpecificPath = firaxisPath.substring(introLength);
            return conquestsFolder + "Scenarios" + Main.fileSlash + searchFolder + Main.fileSlash + firaxisFileSpecificPath;
        }
        return firaxisPath;
    }

    public static boolean copyFile(String source, String destination) {
        boolean directoriesMade;
        int lastSlash = destination.lastIndexOf(Main.fileSlash);
        String destinationFolder = destination.substring(0, lastSlash);
        File folder = new File(destinationFolder);
        if (!folder.exists() && !(directoriesMade = folder.mkdirs())) {
            logger.error("Could not create directories for scenario PCX files");
            return false;
        }
        File in = new File(source);
        File out = new File(destination);
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buffer = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = fis.read(buffer)) > 0) {
                fos.write(buffer, 0, bytesRead);
            }
            fis.close();
            fos.close();
        }
        catch (FileNotFoundException ex) {
            logger.error("File not found", ex);
            return false;
        }
        catch (IOException ex) {
            logger.error("IOException in file copying", ex);
        }
        return true;
    }

    public static String getConquestsFolder(String installDir) {
        if (Main.os.name.toLowerCase().contains("mac") || Main.os.name.toLowerCase().contains("os x")) {
            return installDir + Main.fileSlash + "Conquests Game Data" + Main.fileSlash;
        }
        if (Main.os.name.toLowerCase().contains("windows")) {
            return installDir + Main.fileSlash + "Conquests" + Main.fileSlash;
        }
        return installDir + Main.fileSlash + "Conquests" + Main.fileSlash;
    }

    public static String getPTWFolder(String installDir) {
        if (Main.os.name.toLowerCase().contains("mac") || Main.os.name.toLowerCase().contains("os x")) {
            return installDir + Main.fileSlash + "Play the World Game Data" + Main.fileSlash;
        }
        if (Main.os.name.toLowerCase().contains("windows")) {
            return installDir + Main.fileSlash + "Civ3PTW" + Main.fileSlash;
        }
        return installDir + Main.fileSlash + "Civ3PTW" + Main.fileSlash;
    }

    public static String getVanillaFolder(String installDir) {
        if (Main.os.name.toLowerCase().contains("mac") || Main.os.name.toLowerCase().contains("os x")) {
            return installDir + Main.fileSlash + "Civilization 3 Game Data" + Main.fileSlash;
        }
        if (Main.os.name.toLowerCase().contains("windows")) {
            return installDir + Main.fileSlash;
        }
        return installDir + Main.fileSlash;
    }

    public static boolean isInScenarioFolder(String name, String folderStruct, IO biq) {
        if (Main.os.name.toLowerCase().contains("mac") || Main.os.name.toLowerCase().contains("os x")) {
            return utils.isInScenarioFolderOSX(name, folderStruct, biq);
        }
        if (Main.os.name.toLowerCase().contains("windows")) {
            return utils.isInScenarioFolderWindows(name, folderStruct, biq);
        }
        return utils.isInScenarioFolderUnix(name, folderStruct, biq);
    }

    private static boolean isInScenarioFolderWindows(String name, String folderStruct, IO biq) {
        for (int i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
            String fileName = Main.settings.civInstallDir + Main.fileSlash + "Conquests" + Main.fileSlash + "Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
            File file = new File(fileName);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean isInScenarioFolderOSX(String name, String folderStruct, IO biq) {
        File file;
        String fileName;
        int i;
        for (i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
            fileName = Main.settings.civInstallDir + Main.fileSlash + "Conquests Game Data" + Main.fileSlash + "Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
            file = new File(fileName);
            if (!file.exists()) continue;
            return true;
        }
        for (i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
            fileName = "~/Documents/Civilization 3 Conquests/Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
            file = new File(fileName);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private static boolean isInScenarioFolderUnix(String name, String folderStruct, IO biq) {
        for (int i = 0; i < biq.scenarioProperty.get(0).getSearchFolderLength(); ++i) {
            String fileName = Main.settings.civInstallDir + Main.fileSlash + "Conquests" + Main.fileSlash + "Scenarios" + Main.fileSlash + biq.scenarioProperty.get(0).getSearchFolder(i) + Main.fileSlash + folderStruct + name;
            File file = new File(fileName);
            if (file.exists()) {
                return true;
            }
            file = new File(fileName = fileName.substring(0, fileName.length() - 3) + "PCX");
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public static void copy(String source, String destination, boolean deleteSource) throws IOException {
        Path path;
        System.out.println("\nLocation: " + source);
        File destFile = new File(destination);
        if (!destFile.exists()) {
            Files.createDirectory(Paths.get(destination, new String[0]), new FileAttribute[0]);
        }
        if (Files.isDirectory(path = Paths.get(source, new String[0]), new LinkOption[0])) {
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            for (Path file : stream) {
                Path target = Paths.get(destination + "\\" + file.getFileName(), new String[0]);
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    System.out.print(".");
                    Files.copy(file, target, StandardCopyOption.REPLACE_EXISTING);
                    if (!deleteSource) continue;
                    Files.delete(file);
                    continue;
                }
                if (!Files.exists(Paths.get(destination + "\\" + file.getFileName(), new String[0]), new LinkOption[0])) {
                    Files.createDirectory(Paths.get(destination + "\\" + file.getFileName(), new String[0]), new FileAttribute[0]);
                }
                utils.copy(source + "\\" + file.getFileName(), destination + "\\" + file.getFileName(), deleteSource);
            }
        }
        if (deleteSource) {
            Files.delete(Paths.get(source, new String[0]));
        }
    }

    public static String getItemName(String title, String header, String instructions, String defaultText) {
        Optional result;
        TextInputDialog addUnitPopup = new TextInputDialog(defaultText);
        addUnitPopup.setTitle(title);
        addUnitPopup.setHeaderText(header);
        addUnitPopup.setContentText(instructions);
        while ((result = addUnitPopup.showAndWait()).isPresent()) {
            String unitName = (String)result.get();
            if (unitName.length() > 31) {
                Alert tooLongAlert = new Alert(Alert.AlertType.ERROR, "The name is longer than the max length of 31 characters.  Please enter a shorter name.", new ButtonType[0]);
                tooLongAlert.setHeaderText("Name too long");
                tooLongAlert.setTitle("Name too long");
                tooLongAlert.showAndWait();
                continue;
            }
            if (unitName.length() <= 0) break;
            return unitName;
        }
        return "";
    }

    public static HttpURLConnection getHttpConnection(String url) throws IOException {
        URL theUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)theUrl.openConnection();
        conn.connect();
        return conn;
    }

    public static void downloadFromHttpConnection(HttpURLConnection conn, String fileName) throws IOException {
        int bytesRead;
        InputStream is = conn.getInputStream();
        BufferedInputStream reader = new BufferedInputStream(is);
        File file = new File(fileName);
        FileOutputStream fos = new FileOutputStream(file);
        int bytesDownloaded = 0;
        byte[] buffer = new byte[1024];
        while ((bytesRead = reader.read(buffer)) > -1) {
            fos.write(buffer, 0, bytesRead);
            bytesDownloaded += bytesRead;
        }
        fos.close();
        is.close();
        conn.disconnect();
    }

    public static void addFileToRecentFiles(String pathToBin, String biq) {
        if (Main.os.name.contains("Windows")) {
            try {
                String[] query = new String[]{pathToBin + "./bin/win/AddToRecentDocs.exe", biq};
                Process dcp = Runtime.getRuntime().exec(query);
                dcp.waitFor();
            }
            catch (IOException | InterruptedException ex) {
                logger.info("Unable to add BIQ " + biq + " to recent documents list");
            }
        }
    }
}

