/*
 * Decompiled with CFR 0.152.
 */
package webbrowserfx;

import com.civfanatics.civ3.xplatformeditor.UnitDownloadWindowController;
import com.sun.webkit.dom.HTMLAnchorElementImpl;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MouseEvent;
import webbrowserfx.WebBrowserFX;

public class BrowserTab
extends Tab {
    private volatile boolean isActive = false;
    private String address = "";
    private String title = "";
    private boolean focusOnInput = false;
    WebBrowserFX hostWindow;
    private UnitDownloadWindowController controller = null;

    public BrowserTab(WebBrowserFX host, String startUrl) {
        this.hostWindow = host;
        WebView webKit = new WebView();
        final WebEngine engine = webKit.getEngine();
        engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    BrowserTab.this.setAddress(engine.getLocation());
                    BrowserTab.this.setTitle(engine.getTitle());
                    NodeList nl = engine.getDocument().getElementsByTagName("a");
                    for (int i = 0; i < nl.getLength(); ++i) {
                        EventTarget et = (EventTarget)((Object)nl.item(i));
                        String href = ((HTMLAnchorElementImpl)et).getHref();
                        if (href == null || !href.contains("resources")) continue;
                        et.addEventListener("click", new EventListener(){

                            @Override
                            public void handleEvent(Event evt) {
                                MouseEvent me = (MouseEvent)evt;
                                System.out.println("Shift? " + me.getShiftKey());
                                System.out.println("A HREF event");
                                System.out.println("Type: " + evt.getType());
                                if (me.getCtrlKey()) {
                                    evt.preventDefault();
                                    System.out.println("Background tab");
                                    BrowserTab.this.hostWindow.addTab(evt.getTarget().toString(), false);
                                    System.out.println("Target: " + evt.getTarget().toString());
                                    System.out.println("Engine location: " + engine.getLocation());
                                } else if (me.getShiftKey()) {
                                    evt.preventDefault();
                                    BrowserTab.this.hostWindow.addTab(evt.getTarget().toString(), true);
                                } else {
                                    System.out.println("Same tab");
                                    String target = evt.getCurrentTarget().toString();
                                    if (target.contains("/download?")) {
                                        evt.preventDefault();
                                        System.out.println("Download!");
                                        BrowserTab.this.controller.downloadUnit(target);
                                    }
                                }
                            }
                        }, true);
                    }
                    NodeList n2 = engine.getDocument().getElementsByTagName("input");
                    System.out.println(n2.getLength());
                    for (int i = 0; i < n2.getLength(); ++i) {
                        System.out.println("Input " + i);
                        org.w3c.dom.Node node = n2.item(i);
                        NamedNodeMap nnm = node.getAttributes();
                        for (int j = 0; j < nnm.getLength(); ++j) {
                            org.w3c.dom.Node attribute = nnm.item(j);
                            System.out.println(attribute.getNodeName() + " = " + attribute.getNodeValue());
                        }
                        System.out.println();
                        EventTarget et = (EventTarget)((Object)n2.item(i));
                        et.addEventListener("click", new EventListener(){

                            @Override
                            public void handleEvent(Event evt) {
                                System.out.println("Clicked on an input");
                            }
                        }, true);
                        et.addEventListener("focus", new EventListener(){

                            @Override
                            public void handleEvent(Event evt) {
                                System.out.println("Focus event");
                                BrowserTab.this.focusOnInput = true;
                            }
                        }, true);
                        et.addEventListener("blur", new EventListener(){

                            @Override
                            public void handleEvent(Event evt) {
                                System.out.println("Lost focus event");
                                BrowserTab.this.focusOnInput = false;
                            }
                        }, true);
                    }
                }
            }
        });
        engine.load(startUrl);
        this.setContent((Node)webKit);
        this.setText("Tab One");
    }

    private void setTitle(String title) {
        this.title = title;
        this.setText(title);
        if (this.isActive) {
            this.hostWindow.setWindowTitle(title);
        }
    }

    private void setAddress(String address) {
        this.address = address;
        if (this.isActive) {
            this.hostWindow.setAddressBar(address);
        }
    }

    boolean getFocusOnInput() {
        return this.focusOnInput;
    }

    public void setController(UnitDownloadWindowController controller) {
        this.controller = controller;
    }
}

