/*
 * Decompiled with CFR 0.152.
 */
package webbrowserfx;

import com.civfanatics.civ3.xplatformeditor.UnitDownloadWindowController;
import java.io.File;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javax.swing.JFileChooser;
import webbrowserfx.BrowserTab;
import webbrowserfx.Shortcuts;

public class WebBrowserFX
extends Application {
    String homepage = "http://www.google.com";
    Button btnBack = new Button("Back");
    Button btnForward = new Button("Forward");
    Button btnReload = new Button("Reload");
    TextField txtAddressBar = new TextField(this.homepage);
    TabPane tabs = new TabPane();
    BrowserTab currentTab = null;
    UnitDownloadWindowController controller = null;

    public void start(final Stage primaryStage) {
        this.tabs.setPrefSize(400.0, 400.0);
        this.tabs.setSide(Side.TOP);
        this.tabs.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.tabs.getTabs().addListener((ListChangeListener)new ListChangeListener<Tab>(){

            public void onChanged(ListChangeListener.Change<? extends Tab> change) {
                WebBrowserFX.this.currentTab = (BrowserTab)((Object)WebBrowserFX.this.tabs.getSelectionModel().getSelectedItem());
            }
        });
        this.addTab();
        MenuBar menu = new MenuBar();
        Menu file = new Menu("File");
        MenuItem exit = new MenuItem("Close");
        exit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                primaryStage.close();
            }
        });
        MenuItem newTab = new MenuItem("New Tab");
        newTab.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                WebBrowserFX.this.addTab(WebBrowserFX.this.homepage, true);
            }
        });
        newTab.setAccelerator(Shortcuts.newTab);
        MenuItem open = new MenuItem("Open");
        open.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                JFileChooser chooser = new JFileChooser();
                int rtrnVal = chooser.showOpenDialog(null);
                if (rtrnVal != 0) {
                    return;
                }
                File file = chooser.getSelectedFile();
                String path = "file:///" + file.getAbsolutePath();
                WebBrowserFX.this.addTab(path);
            }
        });
        open.setAccelerator(Shortcuts.open);
        MenuItem closeTab = new MenuItem("Close Tab");
        closeTab.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                WebBrowserFX.this.tabs.getTabs().remove(WebBrowserFX.this.tabs.getSelectionModel().getSelectedIndex());
            }
        });
        closeTab.setAccelerator(Shortcuts.closeTab);
        file.getItems().add((Object)newTab);
        file.getItems().add((Object)open);
        file.getItems().add((Object)closeTab);
        file.getItems().add((Object)exit);
        menu.getMenus().add((Object)file);
        this.txtAddressBar.setOnKeyTyped((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                System.out.println(WebBrowserFX.this.txtAddressBar.getText());
                System.out.println("Code: " + t.getCharacter());
                System.out.println("Enter: " + KeyCode.ENTER);
                System.out.println("Char: " + t.getCharacter().charAt(0));
                if (t.getCharacter().charAt(0) == '\r') {
                    System.out.println("Navigating...");
                    System.out.println(WebBrowserFX.this.txtAddressBar.getText());
                    final WebView view = (WebView)WebBrowserFX.this.currentTab.getContent();
                    view.getEngine().getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

                        public void changed(ObservableValue ov, Worker.State oldState, Worker.State newState) {
                            if (newState == Worker.State.SUCCEEDED) {
                                WebBrowserFX.this.txtAddressBar.setText(view.getEngine().getLocation());
                                WebBrowserFX.this.currentTab.setText(view.getEngine().getTitle());
                            } else if (newState == Worker.State.FAILED) {
                                System.out.println("Could not navigate to " + WebBrowserFX.this.txtAddressBar.getText());
                            }
                        }
                    });
                    view.getEngine().load(WebBrowserFX.this.txtAddressBar.getText());
                }
            }
        });
        this.btnBack.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                WebView v = (WebView)WebBrowserFX.this.currentTab.getContent();
                if (v.getEngine().getHistory().getCurrentIndex() != 0) {
                    v.getEngine().getHistory().go(-1);
                }
            }
        });
        this.btnForward.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                WebView v = (WebView)WebBrowserFX.this.currentTab.getContent();
                if (v.getEngine().getHistory().getCurrentIndex() != v.getEngine().getHistory().getMaxSize()) {
                    v.getEngine().getHistory().go(1);
                }
            }
        });
        this.btnReload.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                WebView v = (WebView)WebBrowserFX.this.currentTab.getContent();
                v.getEngine().reload();
            }
        });
        GridPane controlBar = new GridPane();
        RowConstraints controlRow = new RowConstraints();
        controlRow.setPercentHeight(100.0);
        ColumnConstraints backConstriants = new ColumnConstraints();
        ColumnConstraints forwardConstraints = new ColumnConstraints();
        ColumnConstraints reloadConstraints = new ColumnConstraints();
        ColumnConstraints addressBarConstraints = new ColumnConstraints();
        addressBarConstraints.setHgrow(Priority.ALWAYS);
        controlBar.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{backConstriants, forwardConstraints, reloadConstraints, addressBarConstraints});
        controlBar.getRowConstraints().addAll((Object[])new RowConstraints[]{controlRow});
        GridPane.setConstraints((Node)this.btnBack, (int)0, (int)0);
        controlBar.getChildren().add((Object)this.btnBack);
        GridPane.setConstraints((Node)this.btnForward, (int)1, (int)0);
        controlBar.getChildren().add((Object)this.btnForward);
        GridPane.setConstraints((Node)this.btnReload, (int)2, (int)0);
        controlBar.getChildren().add((Object)this.btnReload);
        GridPane.setConstraints((Node)this.txtAddressBar, (int)3, (int)0);
        controlBar.getChildren().add((Object)this.txtAddressBar);
        BorderPane configPane = new BorderPane();
        configPane.setTop((Node)menu);
        configPane.setCenter((Node)controlBar);
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)this.tabs);
        borderPane.setTop((Node)configPane);
        StackPane root = new StackPane();
        root.getChildren().add((Object)borderPane);
        Scene scene = new Scene((Parent)root, 800.0, 600.0);
        primaryStage.setTitle("Web Browser!");
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.getScene().setOnKeyPressed(new EventHandler(){

            public void handle(Event t) {
                KeyEvent ke = (KeyEvent)t;
                System.out.println(ke.getText());
                if (ke.getText().length() > 0) {
                    if (ke.getText().charAt(0) == '2' && !WebBrowserFX.this.currentTab.getFocusOnInput()) {
                        System.out.println("Next tab");
                        WebBrowserFX.this.tabs.getSelectionModel().selectNext();
                    } else if (ke.getText().charAt(0) == '1' && !WebBrowserFX.this.currentTab.getFocusOnInput()) {
                        WebBrowserFX.this.tabs.getSelectionModel().selectPrevious();
                    }
                }
            }
        });
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    private void addTab() {
        this.addTab(this.homepage);
    }

    void addTab(String url) {
        this.addTab(url, true);
    }

    void addTab(String url, boolean makeActive) {
        final BrowserTab tab = new BrowserTab(this, url);
        tab.setController(this.controller);
        if (makeActive) {
            this.currentTab = tab;
        }
        tab.setOnSelectionChanged(new EventHandler(){

            public void handle(Event t) {
                WebBrowserFX.this.TabChange(t, tab);
            }
        });
        this.tabs.getTabs().addAll((Object[])new Tab[]{tab});
        if (makeActive) {
            this.tabs.getSelectionModel().select(this.tabs.getTabs().size() - 1);
        }
    }

    private void TabChange(Event t, BrowserTab tab) {
        if (tab.isSelected()) {
            this.currentTab = tab;
            this.txtAddressBar.setText(((WebView)this.currentTab.getContent()).getEngine().getLocation());
            tab.setText(((WebView)this.currentTab.getContent()).getEngine().getTitle());
        }
    }

    public static void main(String[] args) {
        WebBrowserFX.launch((String[])args);
    }

    void setWindowTitle(String title) {
    }

    void setAddressBar(String url) {
        this.txtAddressBar.setText(url);
    }

    public void setMaster(UnitDownloadWindowController controller) {
        this.controller = controller;
    }
}

