/*
 * Decompiled with CFR 0.152.
 */
package webpageviewer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import webpageviewer.BrowserWindow;

public class BrowserTab
extends JPanel {
    JEditorPane jep = new JEditorPane();
    JScrollPane scrollPane = new JScrollPane(this.jep);
    BrowserWindow main;

    public BrowserTab(BrowserWindow m) {
        this.main = m;
        this.jep.setEditable(false);
        this.jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        System.out.println("Going to " + evt.getURL().toString());
                        BrowserTab.this.jep.setPage(evt.getURL());
                        BrowserTab.this.main.addressBar.setText(evt.getURL().toString());
                    }
                    catch (IOException e) {
                        System.out.println(e);
                    }
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.gridy = 0;
        g.gridx = 0;
        g.weighty = 1.0;
        g.weightx = 1.0;
        g.fill = 1;
        this.add((Component)this.scrollPane, g);
    }

    public void goToPage(URL page) {
        try {
            this.jep.setPage(page);
        }
        catch (IOException e) {
            this.jep.setContentType("text/html");
            this.jep.setText("Could not load " + page);
        }
    }

    public void goToPage(String string) {
        try {
            URL url = new URL(string);
            this.goToPage(url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

