/*
 * Decompiled with CFR 0.152.
 */
package webpageviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import webpageviewer.BrowserTab;

public class BrowserWindow {
    JTextField addressBar = new JTextField();
    JTabbedPane browserTabs = new JTabbedPane();
    JButton newTab = new JButton();
    ArrayList<BrowserTab> tabs = new ArrayList(2);
    BrowserWindow main;
    String defaultURL = "help/civ3editor.html";
    boolean showNavigationBar = true;
    boolean tabbedInterface = true;
    JFrame f;
    int currentTab = 0;

    public static void main(String[] args) {
        new BrowserWindow();
    }

    public BrowserWindow() {
        this("Web Viewer", true, true);
    }

    public BrowserWindow(String title, boolean tabbedInterface, boolean showNavigationBar) {
        this.tabbedInterface = tabbedInterface;
        this.showNavigationBar = showNavigationBar;
        this.defaultURL = "file:////" + System.getProperty("user.dir") + "/" + this.defaultURL;
        this.main = this;
        this.tabs.add(new BrowserTab(this.main));
        this.browserTabs.add("Tab 1", this.tabs.get(0));
        this.tabs.get(0).goToPage(this.defaultURL);
        this.f = new JFrame(title);
        this.f.setLocationRelativeTo(null);
        this.f.setDefaultCloseOperation(1);
        this.f.getContentPane().setLayout(new GridBagLayout());
        Container cp = this.f.getContentPane();
        GridBagConstraints g = new GridBagConstraints();
        g.gridy = 0;
        g.gridx = 0;
        g.weightx = 0.9;
        g.weighty = 0.0;
        g.fill = 2;
        this.addressBar.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                System.out.println(e.getKeyChar());
                if (e.getKeyCode() == 10) {
                    System.out.println(e.getKeyCode());
                    try {
                        URL whereTo = new URL(BrowserWindow.this.addressBar.getText());
                        System.out.println("Request to go to : " + whereTo.toString());
                        BrowserWindow.this.tabs.get(BrowserWindow.this.currentTab).goToPage(whereTo);
                    }
                    catch (MalformedURLException ex) {
                        System.err.println(ex);
                    }
                    catch (IOException ex) {
                        System.err.println(ex);
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        if (showNavigationBar) {
            cp.add((Component)this.addressBar, g);
            ++g.gridx;
            g.weightx = 0.1;
            this.newTab.setText("New tab");
            this.newTab.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BrowserWindow.this.tabs.add(new BrowserTab(BrowserWindow.this.main));
                    BrowserWindow.this.browserTabs.add("New Tab", BrowserWindow.this.tabs.get(BrowserWindow.this.tabs.size() - 1));
                    BrowserWindow.this.browserTabs.setSelectedIndex(BrowserWindow.this.tabs.size() - 1);
                    BrowserWindow.this.currentTab = BrowserWindow.this.tabs.size() - 1;
                }
            });
            cp.add((Component)this.newTab, g);
        }
        ++g.gridy;
        g.gridwidth = 2;
        g.gridx = 0;
        g.weighty = 1.0;
        g.fill = 1;
        if (tabbedInterface) {
            cp.add((Component)this.browserTabs, g);
        } else {
            cp.add((Component)this.tabs.get(0), g);
        }
        this.f.setSize(800, 600);
        this.browserTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BrowserWindow.this.currentTab = BrowserWindow.this.browserTabs.getSelectedIndex();
            }
        });
    }

    public void goHome() {
        this.tabs.get(0).goToPage(this.defaultURL);
    }

    public void goToUrl(String url) {
        this.tabs.get(0).goToPage(url);
    }

    public void setVisible(boolean value) {
        this.f.setVisible(value);
    }

    public void setLocationRelativeTo(Component c) {
        this.f.setLocationRelativeTo(c);
    }
}

